/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.net.ssl;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.net.ssl.impl.SSLConfigurationProviderImpl;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.FactoryBean;

public class SSLConfigurationProviderBuilder {
    private static final String PROP_NAME_PROTOCOL = "ssl.protocol";
    private static final String PROP_NAME_ENABLED_PROTOCOLS = "ssl.enabledProtocols";
    private static final String PROP_NAME_ENABLED_CIPHER_SUITES = "ssl.enabledCipherSuites";
    private String _protocol;
    private String[] _enabledProtocols;
    private String[] _enabledCipherSuites;

    public SSLConfigurationProviderBuilder protocol(@Nonnull String string) {
        Validate.notNull((Object)string);
        this._protocol = string;
        return this;
    }

    public SSLConfigurationProviderBuilder enabledProtocols(@Nonnull String string) {
        Validate.notNull((Object)string, (String)"commaSeparatedProtocols is null");
        String[] stringArray = string.split(",");
        return this.enabledProtocols(stringArray);
    }

    public SSLConfigurationProviderBuilder enabledProtocols(@Nonnull String[] stringArray) {
        ValidationUtil.noNullOrWhitespaceElements(stringArray, false);
        this._enabledProtocols = stringArray;
        return this;
    }

    public SSLConfigurationProviderBuilder enabledCipherSuites(@Nonnull String string) {
        Validate.notNull((Object)string, (String)"commaSeparatedCiphers is null");
        String[] stringArray = string.split(",");
        return this.enabledCipherSuites(stringArray);
    }

    public SSLConfigurationProviderBuilder enabledCipherSuites(@Nonnull String[] stringArray) {
        ValidationUtil.noNullOrWhitespaceElements(stringArray, false);
        this._enabledCipherSuites = stringArray;
        return this;
    }

    public SSLConfigurationProvider build() {
        return new SSLConfigurationProviderImpl(this._protocol, this._enabledProtocols, this._enabledCipherSuites);
    }

    public static SSLConfigurationProvider buildFromConfigurationService(@Nonnull ConfigurationService configurationService) {
        Validate.notNull((Object)configurationService);
        String string = configurationService.getProperty(PROP_NAME_PROTOCOL);
        String string2 = configurationService.getProperty(PROP_NAME_ENABLED_PROTOCOLS);
        String string3 = configurationService.getProperty(PROP_NAME_ENABLED_CIPHER_SUITES);
        SSLConfigurationProviderBuilder sSLConfigurationProviderBuilder = new SSLConfigurationProviderBuilder();
        if (!StringUtil.isNullOrWhitespace(string)) {
            sSLConfigurationProviderBuilder.protocol(string);
        }
        if (!StringUtil.isNullOrWhitespace(string2)) {
            sSLConfigurationProviderBuilder.enabledProtocols(string2);
        }
        if (!StringUtil.isNullOrWhitespace(string3)) {
            sSLConfigurationProviderBuilder.enabledCipherSuites(string3);
        }
        SSLConfigurationProvider sSLConfigurationProvider = sSLConfigurationProviderBuilder.build();
        return sSLConfigurationProvider;
    }

    @VisibleForTesting
    static class SSLConfigurationProviderFactoryBean
    implements FactoryBean<SSLConfigurationProvider> {
        private final ConfigurationService _configService;

        public SSLConfigurationProviderFactoryBean(ConfigurationService configurationService) {
            Validate.notNull((Object)configurationService);
            this._configService = configurationService;
        }

        public SSLConfigurationProvider getObject() throws Exception {
            return SSLConfigurationProviderBuilder.buildFromConfigurationService(this._configService);
        }

        public Class<?> getObjectType() {
            return SSLConfigurationProvider.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

