/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.osgi;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleProxyClassLoader
extends ClassLoader {
    private final Bundle _bundle;
    private final boolean _getResourcesOnlyFromTheBundleJar;

    private BundleProxyClassLoader(Bundle bundle, boolean bl) {
        super(null);
        if (bundle == null) {
            throw new IllegalArgumentException("The bundle should not be null.");
        }
        this._bundle = bundle;
        this._getResourcesOnlyFromTheBundleJar = bl;
    }

    public static BundleProxyClassLoader createBundleProxyClassLoader(Bundle bundle) {
        return BundleProxyClassLoader.createBundleProxyClassLoader(bundle, true);
    }

    public static BundleProxyClassLoader createBundleProxyClassLoader(final Bundle bundle, final boolean bl) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleProxyClassLoader>(){

            @Override
            public BundleProxyClassLoader run() {
                return new BundleProxyClassLoader(bundle, bl);
            }
        });
    }

    public static BundleProxyClassLoader createBundleProxyClassLoader(@Nonnull BundleContext bundleContext, boolean bl) {
        Bundle bundle = bundleContext.getBundle();
        BundleProxyClassLoader bundleProxyClassLoader = BundleProxyClassLoader.createBundleProxyClassLoader(bundle, bl);
        return bundleProxyClassLoader;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this._bundle.loadClass(string);
    }

    @Override
    public URL getResource(String string) {
        if (this._getResourcesOnlyFromTheBundleJar) {
            return this._bundle.getEntry(string);
        }
        return this._bundle.getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration enumeration = this._getResourcesOnlyFromTheBundleJar ? this._bundle.findEntries(string, null, false) : this._bundle.getResources(string);
        return enumeration;
    }
}

