/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.osgi;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.osgi.OSGIUtil;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class OSGIServiceRegistry
implements ServiceRegistry {
    private static final Log _logger = LogFactory.getLog(OSGIServiceRegistry.class);
    private BundleContext _bundleContext;
    private final ConcurrentMap<InterfaceAndListener, ServiceTrackerThatNotifiesListener<?, ?>> _serviceTrackers;

    public OSGIServiceRegistry(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTrackers = new ConcurrentHashMap();
    }

    public List<Object> getServices(String string) {
        ServiceReference<?>[] serviceReferenceArray = this.getServiceReferences(string);
        List<Object> list = OSGIUtil.getServices(serviceReferenceArray);
        return list;
    }

    public <T> T getService(String string) {
        ServiceReference serviceReference = this._bundleContext.getServiceReference(string);
        Object object = this._bundleContext.getService(serviceReference);
        return (T)object;
    }

    @Override
    public void registerService(String string, Object object) {
    }

    @Override
    public void registerServiceListener(String string, ServiceListener serviceListener) {
        ValidationUtil.paramsNotNull(string, serviceListener);
        InterfaceAndListener interfaceAndListener = new InterfaceAndListener(string, serviceListener);
        if (this._serviceTrackers.containsKey(interfaceAndListener)) {
            this.logDuplicateListener(string, serviceListener);
            return;
        }
        ServiceTrackerThatNotifiesListener serviceTrackerThatNotifiesListener = new ServiceTrackerThatNotifiesListener(this._bundleContext, string, serviceListener);
        ServiceTrackerThatNotifiesListener serviceTrackerThatNotifiesListener2 = this._serviceTrackers.putIfAbsent(interfaceAndListener, serviceTrackerThatNotifiesListener);
        if (serviceTrackerThatNotifiesListener2 != null) {
            this.logDuplicateListener(string, serviceListener);
            return;
        }
        serviceTrackerThatNotifiesListener.open();
    }

    private void logDuplicateListener(String string, ServiceListener serviceListener) {
        _logger.warn((Object)("The " + ServiceListener.class.getSimpleName() + " " + serviceListener + " is already registered for interface " + string));
    }

    public boolean unregisterServiceListener(String string, ServiceListener serviceListener) {
        ValidationUtil.paramsNotNull(string, serviceListener);
        InterfaceAndListener interfaceAndListener = new InterfaceAndListener(string, serviceListener);
        ServiceTrackerThatNotifiesListener serviceTrackerThatNotifiesListener = (ServiceTrackerThatNotifiesListener)((Object)this._serviceTrackers.remove(interfaceAndListener));
        boolean bl = false;
        if (serviceTrackerThatNotifiesListener != null) {
            bl = true;
            serviceTrackerThatNotifiesListener.close();
        }
        return bl;
    }

    public void unregisterAllServiceListeners() {
        Set set = this._serviceTrackers.entrySet();
        for (Map.Entry entry : set) {
            InterfaceAndListener interfaceAndListener = (InterfaceAndListener)entry.getKey();
            ServiceTrackerThatNotifiesListener serviceTrackerThatNotifiesListener = (ServiceTrackerThatNotifiesListener)((Object)entry.getValue());
            serviceTrackerThatNotifiesListener.close();
            this._serviceTrackers.remove(interfaceAndListener, (Object)serviceTrackerThatNotifiesListener);
        }
    }

    private ServiceReference<?>[] getServiceReferences(String string) {
        ServiceReference[] serviceReferenceArray = null;
        try {
            serviceReferenceArray = this._bundleContext.getAllServiceReferences(string, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            _logger.error((Object)invalidSyntaxException.getLocalizedMessage());
        }
        if (serviceReferenceArray == null) {
            serviceReferenceArray = new ServiceReference[]{};
        }
        return serviceReferenceArray;
    }

    private static class InterfaceAndListener {
        private final String _interfaceName;
        private final ServiceListener _serviceListener;
        private volatile int _cachedHashCode;

        public InterfaceAndListener(String string, ServiceListener serviceListener) {
            this._interfaceName = string;
            this._serviceListener = serviceListener;
        }

        public int hashCode() {
            int n = this._cachedHashCode;
            if (n == 0) {
                n = 1;
                n = 31 * n + (this._interfaceName == null ? 0 : this._interfaceName.hashCode());
                this._cachedHashCode = n = 31 * n + (this._serviceListener == null ? 0 : this._serviceListener.hashCode());
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            InterfaceAndListener interfaceAndListener = (InterfaceAndListener)object;
            boolean bl = (this._interfaceName == null ? interfaceAndListener._interfaceName == null : this._interfaceName.equals(interfaceAndListener._interfaceName)) && this._serviceListener == interfaceAndListener._serviceListener;
            return bl;
        }
    }

    private static class ServiceTrackerThatNotifiesListener<S, T>
    extends ServiceTracker<S, T> {
        private final ServiceListener _serviceListener;

        public ServiceTrackerThatNotifiesListener(BundleContext bundleContext, String string, ServiceListener serviceListener) {
            super(bundleContext, string, null);
            ValidationUtil.paramsNotNull(serviceListener);
            this._serviceListener = serviceListener;
        }

        public T addingService(ServiceReference<S> serviceReference) {
            Object object = super.addingService(serviceReference);
            if (object != null) {
                try {
                    this._serviceListener.serviceAdded(object);
                }
                catch (Exception exception) {
                    _logger.error((Object)(ServiceListener.class.getSimpleName() + " " + this._serviceListener + " failed when adding reference " + serviceReference), (Throwable)exception);
                }
            }
            return (T)object;
        }

        public void removedService(ServiceReference<S> serviceReference, T t) {
            try {
                this._serviceListener.serviceRemoved(t);
            }
            catch (Exception exception) {
                _logger.error((Object)(ServiceListener.class.getSimpleName() + " " + this._serviceListener + " failed when removing reference " + serviceReference), (Throwable)exception);
            }
            super.removedService(serviceReference, t);
        }
    }
}

