/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.osgi;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

class OSGIUtil {
    OSGIUtil() {
    }

    public static <Type> List<Type> getServices(ServiceReference<?>[] serviceReferenceArray) {
        if (serviceReferenceArray == null) {
            return null;
        }
        int n = serviceReferenceArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (ServiceReference<?> serviceReference : serviceReferenceArray) {
            BundleContext bundleContext = serviceReference.getBundle().getBundleContext();
            Object object = bundleContext.getService(serviceReference);
            arrayList.add(object);
            bundleContext.ungetService(serviceReference);
        }
        return arrayList;
    }

    public static void ungetServices(ServiceReference<?>[] serviceReferenceArray) {
        if (serviceReferenceArray == null) {
            return;
        }
        for (ServiceReference<?> serviceReference : serviceReferenceArray) {
            BundleContext bundleContext = serviceReference.getBundle().getBundleContext();
            bundleContext.ungetService(serviceReference);
        }
    }

    public static String getAttributeFilter(String string, String string2, boolean bl) {
        if (bl) {
            return "(" + string + "=" + string2 + ")";
        }
        return "(|(" + string + "=" + string2 + ")(!(" + string + "=*)))";
    }

    public static <Type> Type getService(Class<?> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        if (bundle == null) {
            return null;
        }
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(clazz.getName());
        if (serviceReference == null) {
            return null;
        }
        Object object = bundleContext.getService(serviceReference);
        bundleContext.ungetService(serviceReference);
        return (Type)object;
    }
}

