/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.profiling;

import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionProfilerImpl
implements ExecutionProfiler {
    public static final ExecutionProfiler PASS_THROUGH_PROFILER = new EmptyExecutionProfiler();
    private final ConcurrentMap<String, AtomicInteger> _invocationCountByLabel;
    private final ConcurrentMap<Object, Long> _startTimeInNanosByKey;
    private final ConcurrentNavigableMap<Key, Long> _elapsedTimeInMillisByKey;
    private final String _prefix;

    public ExecutionProfilerImpl(String string) {
        ValidationUtil.paramsNotNull(string);
        if (string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this._invocationCountByLabel = new ConcurrentHashMap<String, AtomicInteger>();
        this._startTimeInNanosByKey = new ConcurrentHashMap<Object, Long>();
        this._elapsedTimeInMillisByKey = new ConcurrentSkipListMap<Key, Long>();
        this._prefix = string;
    }

    @Override
    public Object startTimer(String string) {
        if (string == null) {
            return null;
        }
        Key key = this.getUniqueKeyForLabel(string);
        Long l = this._startTimeInNanosByKey.putIfAbsent(key, System.nanoTime());
        if (l != null) {
            throw new IllegalStateException("Should not be possible to add a duplicate start time: " + key);
        }
        return key;
    }

    @Override
    public Long stopTimer(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Key)) {
            throw new IllegalArgumentException("Invalid key type.");
        }
        Long l = (Long)this._startTimeInNanosByKey.remove(object);
        if (l == null) {
            throw new IllegalArgumentException("Timer never started or already stopped for: " + object);
        }
        Long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
        Long l3 = this._elapsedTimeInMillisByKey.putIfAbsent((Key)object, l2);
        if (l3 != null) {
            throw new IllegalStateException("Should not be possible to add a duplicate elapsed time=: " + object);
        }
        return l2;
    }

    @Override
    public Map<String, Long> getExecutionTimes() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (Map.Entry entry : this._elapsedTimeInMillisByKey.entrySet()) {
            hashMap.put(((Key)entry.getKey()).toString(), (Long)entry.getValue());
        }
        return hashMap;
    }

    @Override
    public void putExecutionTime(String string, Long l) {
        ValidationUtil.paramsNotNull(string, l);
        Key key = this.getUniqueKeyForLabel(string);
        Long l2 = this._elapsedTimeInMillisByKey.put(key, l);
        if (l2 != null) {
            throw new IllegalStateException("Should not be possible to add a duplicate elapsed time=: " + key);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void mergeProfilingResults(ExecutionProfiler executionProfiler) {
        if (executionProfiler == null) {
            return;
        }
        Map<String, Long> map = executionProfiler.getExecutionTimes();
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            this.putExecutionTime(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (Map.Entry entry : this._elapsedTimeInMillisByKey.entrySet()) {
            stringBuilder.append(((Key)entry.getKey()).toString());
            stringBuilder.append(": ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(" milliseconds\n");
        }
        return stringBuilder.toString();
    }

    private Key getUniqueKeyForLabel(String string) {
        Number number;
        String string2 = this._prefix + "." + string;
        Number number2 = (AtomicInteger)this._invocationCountByLabel.get(string2);
        if (number2 == null && (number = this._invocationCountByLabel.putIfAbsent(string2, (AtomicInteger)(number2 = new AtomicInteger(0)))) != null) {
            number2 = number;
        }
        number = number2.getAndIncrement();
        Key key = new Key(string2, (Integer)number);
        return key;
    }

    private static class EmptyExecutionProfiler
    implements ExecutionProfiler {
        private EmptyExecutionProfiler() {
        }

        @Override
        public Object startTimer(String string) {
            return null;
        }

        @Override
        public Long stopTimer(Object object) {
            return null;
        }

        @Override
        public Map<String, Long> getExecutionTimes() {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void putExecutionTime(String string, Long l) {
        }

        @Override
        public void mergeProfilingResults(ExecutionProfiler executionProfiler) {
        }
    }

    private static class Key
    implements Comparable<Key> {
        final Pair<String, Integer> _labelAndIndex;
        final String _toString;

        Key(String string, Integer n) {
            boolean bl = true;
            this._labelAndIndex = new Pair<String, Integer>(string, n, bl);
            this._toString = string + "-" + n;
        }

        public int hashCode() {
            return this._labelAndIndex.hashCode();
        }

        public boolean equals(Object object) {
            return this._labelAndIndex.equals(object);
        }

        public String toString() {
            return this._toString;
        }

        @Override
        public int compareTo(Key key) {
            return this._toString.compareTo(key._toString);
        }
    }
}

