/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.security;

import com.vmware.vise.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CertificateUtil {
    private static CertificateFactory _certFactory;
    private static final String BEGIN_CERT_MARKER = "-----BEGIN CERTIFICATE-----\n";
    private static final String ENG_CERT_MARKER = "\n-----END CERTIFICATE-----\n";
    public static final String PEM_PRIVATEKEY_PREFIX = "-----BEGIN[A-Z ]*KEY-----(\n)?";
    public static final String PEM_PRIVATEKEY_SUFFIX = "(\n)?-----END[A-Z ]*KEY-----(\n)*";
    private static final Log _logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate generateCertificate(String string) throws UnsupportedEncodingException, CertificateException {
        InputStream inputStream = null;
        try {
            Certificate certificate;
            string = CertificateUtil.appendCertificateMarkers(string);
            inputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            Certificate certificate2 = certificate = _certFactory.generateCertificate(inputStream);
            return certificate2;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String encodeCertificate(X509Certificate x509Certificate) throws Exception {
        if (x509Certificate == null) {
            throw new IllegalStateException("Invalid Certificate, certificate cannot be null");
        }
        byte[] byArray = Base64.encodeBase64((byte[])x509Certificate.getEncoded());
        String string = new String(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && i % 64 == 0) {
                stringBuffer.append("\n");
                stringBuffer.append(string.charAt(i));
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return BEGIN_CERT_MARKER + stringBuffer.toString() + ENG_CERT_MARKER;
    }

    public static X509Certificate decodeCertificate(String string) throws UnsupportedEncodingException {
        byte[] byArray = Base64.decodeBase64((byte[])string.getBytes("UTF-8"));
        X509Certificate x509Certificate = CertificateUtil.decodeCertificate(byArray);
        return x509Certificate;
    }

    public static X509Certificate[] getCertificateChain(String string) throws CertificateException {
        if (string == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        Collection<? extends Certificate> collection = null;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        collection = certificateFactory.generateCertificates(byteArrayInputStream);
        try {
            ((InputStream)byteArrayInputStream).close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("ByteArrayInputStream failed to close.", iOException);
        }
        X509Certificate[] x509CertificateArray = collection.toArray(new X509Certificate[0]);
        return x509CertificateArray;
    }

    public static PrivateKey getPrivateKey(String string) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey privateKey;
        byte[] byArray;
        if (string == null) {
            return null;
        }
        string = string.replaceFirst(PEM_PRIVATEKEY_PREFIX, "");
        string = string.replaceFirst(PEM_PRIVATEKEY_SUFFIX, "");
        try {
            byArray = Base64.decodeBase64((byte[])string.getBytes());
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Not able to do decode private key");
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        try {
            privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Not able to generate private key from encoded key spec.");
            unrecoverableKeyException.initCause(invalidKeySpecException);
            throw unrecoverableKeyException;
        }
        return privateKey;
    }

    public static X509Certificate decodeCertificate(byte[] byArray) {
        CertificateFactory certificateFactory;
        if (byArray == null) {
            throw new IllegalArgumentException("Argument certificateDer cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("Internal error: X.509 Certificate Factory is not available (uncompliant JRE?)", certificateException);
        }
        try {
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            throw new IllegalArgumentException("Invalid certificate bytes", certificateException);
        }
    }

    public static Collection<Certificate> generateCertificatesFromDirectory(String string, boolean bl) {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        File file = new File(string);
        if (!file.exists()) {
            return arrayList;
        }
        for (File file2 : file.listFiles()) {
            try {
                Collection<Certificate> collection = null;
                if (file2.isDirectory()) {
                    if (!bl) continue;
                    collection = CertificateUtil.generateCertificatesFromDirectory(file2.getPath(), bl);
                    arrayList.addAll(collection);
                    continue;
                }
                collection = CertificateUtil.generateCertificatesFromFile(file2.getPath());
                arrayList.addAll(collection);
            }
            catch (Exception exception) {
                _logger.warn((Object)String.format("Failed to generate certificate for %1s - %2s.", file2.getPath(), exception.getMessage()));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Certificate> generateCertificatesFromFile(String string) throws FileNotFoundException, CertificateException {
        FileInputStream fileInputStream = null;
        try {
            Collection<Certificate> collection;
            fileInputStream = new FileInputStream(string);
            Collection<Certificate> collection2 = collection = _certFactory.generateCertificates(fileInputStream);
            return collection2;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static KeyStore getKeyStore(String string) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Certificate certificate = CertificateUtil.generateCertificate(string);
        return CertificateUtil.getKeyStore(certificate);
    }

    public static KeyStore getKeyStore(Certificate certificate) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        keyStore.setEntry("SslTrustAnchor", new KeyStore.TrustedCertificateEntry(certificate), null);
        return keyStore;
    }

    public static String[] getThumbprints(String[] stringArray) throws UnsupportedEncodingException, CertificateException, NoSuchAlgorithmException {
        if (ArrayUtil.isNullOrEmpty(stringArray)) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = CertificateUtil.getThumbprint(stringArray[i]);
        }
        return stringArray2;
    }

    public static String getThumbprint(String string) throws UnsupportedEncodingException, CertificateException, NoSuchAlgorithmException {
        Certificate certificate = CertificateUtil.generateCertificate(string);
        return CertificateUtil.getThumbprint(certificate);
    }

    public static String getThumbprint(Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        String string = "SHA";
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray = certificate.getEncoded();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return CertificateUtil.hexify(byArray2);
    }

    public static String trimCertificateMarkers(String string) {
        string = string.replaceAll(BEGIN_CERT_MARKER, "");
        string = string.replaceAll(ENG_CERT_MARKER, "");
        return string;
    }

    public static String appendCertificateMarkers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.startsWith(BEGIN_CERT_MARKER)) {
            stringBuffer.append(BEGIN_CERT_MARKER);
        }
        stringBuffer.append(string);
        if (!string.endsWith(ENG_CERT_MARKER)) {
            stringBuffer.append(ENG_CERT_MARKER);
        }
        return stringBuffer.toString();
    }

    private static String hexify(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(cArray[(byArray[i] & 0xF0) >> 4]);
            stringBuffer.append(cArray[byArray[i] & 0xF]);
            if (i == byArray.length - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString().toUpperCase(Locale.ENGLISH);
    }

    static {
        _logger = LogFactory.getLog(CertificateUtil.class);
        try {
            _certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

