/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.security;

import com.vmware.vise.util.session.SessionUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NonceUtil {
    private static final String NONCE_MAP = "NONCE_MAP";
    private static final String SYNC_OBJ = "NONCE_MAP-sync";
    private static final Log _logger = LogFactory.getLog(NonceUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createNonce(HttpSession httpSession) {
        String string;
        Object object;
        if (httpSession == null) {
            throw new IllegalArgumentException("A session is required to create and register a Nonce.");
        }
        Object object2 = object = SessionUtil.getSyncObject(SYNC_OBJ, httpSession);
        synchronized (object2) {
            boolean bl = false;
            HashMap<String, NonceInfo> hashMap = (HashMap<String, NonceInfo>)SessionUtil.getData(NONCE_MAP, httpSession);
            if (hashMap == null) {
                bl = true;
                hashMap = new HashMap<String, NonceInfo>();
            }
            string = NonceUtil.createNonceToken();
            NonceInfo nonceInfo = new NonceInfo(string);
            hashMap.put(string, nonceInfo);
            _logger.debug((Object)String.format("Nonce added: %s", nonceInfo));
            if (bl) {
                SessionUtil.setData(NONCE_MAP, hashMap, httpSession);
            }
        }
        return string;
    }

    public static String createNonce() {
        return NonceUtil.createNonce(SessionUtil.getHttpSession());
    }

    public static void consumeNonce(String string) {
        NonceUtil.consumeNonce(SessionUtil.getHttpSession(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consumeNonce(HttpSession httpSession, String string) {
        Object object;
        if (httpSession == null) {
            throw new IllegalArgumentException("No session object found.");
        }
        Object object2 = object = SessionUtil.getSyncObject(SYNC_OBJ, httpSession);
        synchronized (object2) {
            Map map = (Map)SessionUtil.getData(NONCE_MAP, httpSession);
            if (map == null) {
                throw new SecurityException("No Nonce map stored in session.");
            }
            if (!map.containsKey(string)) {
                throw new SecurityException(String.format("Nonce token invalid: %s", string));
            }
            NonceInfo nonceInfo = (NonceInfo)map.get(string);
            if (nonceInfo.isExpired()) {
                throw new SecurityException(String.format("Nonce has expired: %s", string));
            }
            map.remove(string);
            _logger.debug((Object)String.format("Token removed: %s", string));
        }
    }

    private static String createNonceToken() {
        return UUID.randomUUID().toString();
    }

    private static class NonceInfo {
        public static long EXPIRATION_TIMEOUT = 60000L;
        public long timestamp = Calendar.getInstance().getTimeInMillis();
        public String token;

        public NonceInfo(String string) {
            this.token = string;
        }

        public boolean isExpired() {
            return this.isExpired(EXPIRATION_TIMEOUT);
        }

        public boolean isExpired(long l) {
            return new Date(this.timestamp + l).before(new Date());
        }

        public String toString() {
            return this.token;
        }
    }
}

