/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.session;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.profiling.ExecutionProfilerImpl;
import com.vmware.vise.util.session.RequestInfo;
import com.vmware.vise.util.session.SessionDataContainerMissingException;
import com.vmware.vise.util.session.SessionInvalidatedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SessionUtil {
    private static final ThreadLocal<ExecutionProfiler> _profiler = new ThreadLocal();
    private static final long INITIAL_HASHED_SESSION_ID = 100000L;
    private static final AtomicLong HASHED_SESSION_ID_GENERATOR = new AtomicLong(100000L);
    public static final String PLACEHOLDER_HASHED_SESSION_ID = "######";
    private static final long INITIAL_HASHED_CLIENT_ID = 200000L;
    private static final AtomicLong HASHED_CLIENT_ID_GENERATOR = new AtomicLong(200000L);
    public static final String PLACEHOLDER_HASHED_CLIENT_ID = "######";
    private static final long INITIAL_HASHED_REQUEST_ID = 70000000L;
    private static final AtomicLong HASHED_REQUEST_ID_GENERATOR = new AtomicLong(70000000L);
    public static final String PLACEHOLDER_HASHED_REQUEST_ID = "########";
    private static final Log _logger = LogFactory.getLog(SessionUtil.class);
    public static final String SECURITY_CONTEXT = "SECURITY_CONTEXT";
    public static final String WEB_CLIENT_SESSION_ID_KEY = "webClientSessionId";
    public static final String OP_ID_KEY = "opId";
    private static final String CLIENT_ID_ATTR_NAME = "#clientId#";
    private static final String HASHED_REQUEST_ID_ATTR_NAME = "#hashedRequestId#";
    private static final String HASHED_SESSION_ID_ATTR_NAME = "#hashedSessionId#";
    private static final String HASHED_CLIENT_ID_ATTR_NAME = "#hashedClientId#";
    private static final String LOGOUT_STATE_ATTR_NAME = "#LOGOUT_STATE#";
    public static final String CLEANUP_CLIENT_SESSION_LISTENER_ATTR_NAME = "#VMWARE_CLEANUP_CLIENT_SESSION_LISTENER#";
    private static final String SESSION_MONITOR_KEY = "sessionMonitor";
    private static final Object STATIC_CONTEXT_SYNC_OBJECT = new Object();
    private static final ThreadLocal<HttpServletRequest> _request = new ThreadLocal();
    private static final ThreadLocal<HttpSession> _session = new ThreadLocal();
    private static final ConcurrentMap<String, ConcurrentMap<String, Object>> _sessionDataById = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();
    private static final AtomicReference<Cache<String, SessionData>> _sessionHistoryRef = new AtomicReference<Object>(null);
    private static final String PROFILING_PARAM_NAME = "perf";

    private static String getClientIdAttrName() {
        return CLIENT_ID_ATTR_NAME;
    }

    private static String getHashedClientIdAttrName() {
        return HASHED_CLIENT_ID_ATTR_NAME;
    }

    private static String getCleanupClientSessionListenerAttrName() {
        return CLEANUP_CLIENT_SESSION_LISTENER_ATTR_NAME;
    }

    public static void setHttpRequest(HttpServletRequest httpServletRequest) {
        HttpServletRequest httpServletRequest2 = _request.get();
        if (httpServletRequest2 != null && httpServletRequest != null) {
            _logger.warn((Object)"Just clobbered an existing httpRequest");
        }
        if (httpServletRequest2 == null && httpServletRequest == null) {
            _logger.trace((Object)"Existing httpRequest already null. Possible unbalanced clear.");
        }
        _request.set(httpServletRequest);
    }

    public static void setHttpSession(HttpSession httpSession) {
        HttpSession httpSession2 = _session.get();
        if (httpSession2 != null && httpSession != null) {
            _logger.warn((Object)"Just clobbered an existing httpSession");
        }
        if (httpSession2 == null && httpSession == null) {
            _logger.trace((Object)"Existing httpSession already null. Possible unbalanced clear.");
        }
        _session.set(httpSession);
    }

    public static HttpServletRequest getHttpRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest httpServletRequest = null;
        if (requestAttributes != null) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            httpServletRequest = servletRequestAttributes.getRequest();
        }
        if (httpServletRequest == null) {
            httpServletRequest = _request.get();
        }
        return httpServletRequest;
    }

    public static HttpSession getHttpSession(boolean bl) {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        if (httpServletRequest == null) {
            HttpSession httpSession = _session.get();
            if (httpSession != null) {
                _logger.debug((Object)"Returning non-null threadlocal httpsession.");
            }
            return httpSession;
        }
        HttpSession httpSession = httpServletRequest.getSession(bl);
        return httpSession;
    }

    public static HttpSession getHttpSession() {
        HttpSession httpSession = SessionUtil.getHttpSession(true);
        return httpSession;
    }

    public static <T> T getData(String string) {
        T t = SessionUtil.getData(string, (HttpSession)null);
        return t;
    }

    public static <T> T getData(String string, HttpSession httpSession) {
        T t = SessionUtil.getData(string, httpSession, false);
        return t;
    }

    public static <T> T getData(String string, HttpSession httpSession, boolean bl) {
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession(false);
        }
        if (httpSession == null) {
            if (bl) {
                throw new IllegalStateException("Failed to retrieve the current HttpSession");
            }
            return null;
        }
        String string2 = SessionUtil.getClientId(httpSession, bl);
        if (string2 == null) {
            return null;
        }
        T t = SessionUtil.getData(string, string2, bl);
        return t;
    }

    public static <T> T getData(String string, String string2) {
        if (StringUtil.isNullOrEmpty(string2)) {
            return null;
        }
        T t = SessionUtil.getData(string, string2, false);
        return t;
    }

    private static <T> T getData(String string, String string2, boolean bl) {
        assert (!StringUtil.isNullOrEmpty(string2));
        ConcurrentMap<String, Object> concurrentMap = SessionUtil.getSessionDataContainer(string2, bl);
        if (concurrentMap == null) {
            return null;
        }
        Object object = concurrentMap.get(string);
        if (object instanceof ExpirableData) {
            object = ((ExpirableData)object).getData();
        }
        return (T)object;
    }

    public static CountDownLatch getSessionMonitor(HttpSession httpSession) {
        CountDownLatch countDownLatch = (CountDownLatch)SessionUtil.getData(SESSION_MONITOR_KEY, httpSession);
        if (countDownLatch != null) {
            return countDownLatch;
        }
        CountDownLatch countDownLatch2 = new CountDownLatch(1);
        countDownLatch = (CountDownLatch)SessionUtil.setDataIfAbsent(SESSION_MONITOR_KEY, (Object)countDownLatch2, httpSession);
        if (countDownLatch != null) {
            return countDownLatch;
        }
        return countDownLatch2;
    }

    public static CountDownLatch getSessionMonitor(String string) {
        CountDownLatch countDownLatch = (CountDownLatch)SessionUtil.getData(SESSION_MONITOR_KEY, string);
        if (countDownLatch != null) {
            return countDownLatch;
        }
        CountDownLatch countDownLatch2 = new CountDownLatch(1);
        countDownLatch = (CountDownLatch)SessionUtil.setDataIfAbsent(SESSION_MONITOR_KEY, (Object)countDownLatch2, string);
        if (countDownLatch != null) {
            return countDownLatch;
        }
        return countDownLatch2;
    }

    public static Object getSyncObject(String string, HttpSession httpSession) {
        Object object;
        String string2;
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession();
        }
        if ((string2 = SessionUtil.getClientId(httpSession)) == null) {
            String string3 = "clientId is null, probably means this is being called from a static context. Please avoid abusing session utilities in this manner.";
            _logger.warn((Object)string3);
            return STATIC_CONTEXT_SYNC_OBJECT;
        }
        Object object2 = SessionUtil.getData(string, string2);
        if (object2 == null && (object = SessionUtil.setDataIfAbsent(string, object2 = new Object(), string2)) != null) {
            return object;
        }
        return object2;
    }

    public static void setExpirableData(String string, Object object, int n) {
        ExpirableData expirableData = new ExpirableData(object, n);
        SessionUtil.setData(string, expirableData);
    }

    public static void setData(String string, Object object) {
        SessionUtil.setData(string, object, true);
    }

    public static void setData(String string, Object object, boolean bl) {
        SessionUtil.setData(string, object, (HttpSession)null, bl);
    }

    public static void setData(String string, Object object, HttpSession httpSession) {
        SessionUtil.setData(string, object, httpSession, true);
    }

    public static void setData(String string, Object object, HttpSession httpSession, boolean bl) {
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession();
        }
        if (httpSession == null) {
            if (bl) {
                throw new IllegalStateException("Failed to retrieve the current HttpSession");
            }
            return;
        }
        String string2 = SessionUtil.getClientId(httpSession);
        if (StringUtil.isNullOrEmpty(string2)) {
            if (bl) {
                throw new IllegalStateException("There's no clientId in the session");
            }
            return;
        }
        SessionUtil.setData(string, object, string2, bl);
    }

    public static void setData(String string, Object object, String string2) {
        SessionUtil.setData(string, object, string2, true);
    }

    public static void setData(String string, Object object, String string2, boolean bl) {
        if (StringUtil.isNullOrEmpty(string2)) {
            if (bl) {
                throw new IllegalArgumentException("clientId is null or empty");
            }
            return;
        }
        ConcurrentMap<String, Object> concurrentMap = SessionUtil.getSessionDataContainer(string2, bl);
        if (concurrentMap != null) {
            concurrentMap.put(string, object);
        }
    }

    public static Object setDataIfAbsent(String string, Object object) {
        return SessionUtil.setDataIfAbsent(string, object, true);
    }

    public static Object setDataIfAbsent(String string, Object object, boolean bl) {
        Object object2 = SessionUtil.setDataIfAbsent(string, object, (HttpSession)null, bl);
        return object2;
    }

    public static Object setDataIfAbsent(String string, Object object, HttpSession httpSession) {
        return SessionUtil.setDataIfAbsent(string, object, httpSession, true);
    }

    public static Object setDataIfAbsent(String string, Object object, HttpSession httpSession, boolean bl) {
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession();
        }
        if (httpSession == null) {
            if (bl) {
                throw new IllegalStateException("Failed to retrieve the current HttpSession");
            }
            return null;
        }
        String string2 = SessionUtil.getClientId(httpSession);
        if (StringUtil.isNullOrEmpty(string2)) {
            if (bl) {
                throw new IllegalStateException("There's no clientId in the session");
            }
            return null;
        }
        Object object2 = SessionUtil.setDataIfAbsent(string, object, string2, bl);
        return object2;
    }

    public static Object setDataIfAbsent(String string, Object object, String string2) {
        return SessionUtil.setDataIfAbsent(string, object, string2, true);
    }

    public static Object setDataIfAbsent(String string, Object object, String string2, boolean bl) {
        if (StringUtil.isNullOrEmpty(string2)) {
            if (bl) {
                throw new IllegalArgumentException("clientId is null or empty");
            }
            return null;
        }
        ConcurrentMap<String, Object> concurrentMap = SessionUtil.getSessionDataContainer(string2, bl);
        if (concurrentMap == null) {
            return null;
        }
        Object object2 = concurrentMap.putIfAbsent(string, object);
        return object2;
    }

    private static boolean replaceData(String string, Object object, Object object2, String string2) {
        assert (string2 != null);
        ConcurrentMap<String, Object> concurrentMap = SessionUtil.getSessionDataContainer(string2, true);
        if (object == null) {
            Object object3 = concurrentMap.putIfAbsent(string, object2);
            return object3 == null;
        }
        boolean bl = concurrentMap.replace(string, object, object2);
        return bl;
    }

    private static ConcurrentMap<String, Object> generateSessionDataContainer(String string, boolean bl) {
        assert (!StringUtil.isNullOrEmpty(string));
        ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, String>();
        String string2 = SessionUtil.generateHashedClientId(string);
        concurrentHashMap.put(HASHED_CLIENT_ID_ATTR_NAME, string2);
        ConcurrentMap concurrentMap = _sessionDataById.putIfAbsent(string, concurrentHashMap);
        if (concurrentMap != null) {
            if (bl) {
                string2 = SessionUtil.getHashedClientId(concurrentMap);
                throw new IllegalStateException("An attempt was made to generate a session data container for a clientId for which a container already exists: " + string2);
            }
            concurrentHashMap = concurrentMap;
        } else {
            int n = _sessionDataById.size();
            _logger.info((Object)("Added clientId " + string2 + ". Total clientIds so far (incl. the newly added one): " + n));
        }
        return concurrentHashMap;
    }

    private static ConcurrentMap<String, Object> getSessionDataContainer(String string, boolean bl) {
        assert (!StringUtil.isNullOrEmpty(string));
        ConcurrentMap concurrentMap = (ConcurrentMap)_sessionDataById.get(string);
        if (concurrentMap == null) {
            SessionUtil.logHistoryData(string);
            if (bl) {
                throw new SessionDataContainerMissingException("Session data container is missing. It must've been destroyed, probably due to logout.");
            }
        }
        return concurrentMap;
    }

    public static Object removeData(String string) {
        return SessionUtil.removeData(string, (HttpSession)null);
    }

    public static Object removeData(String string, HttpSession httpSession) {
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession();
        }
        if (httpSession == null) {
            return null;
        }
        String string2 = SessionUtil.getClientId(httpSession);
        return SessionUtil.removeData(string, string2);
    }

    public static Object removeData(String string, String string2) {
        if (StringUtil.isNullOrEmpty(string2)) {
            return null;
        }
        ConcurrentMap concurrentMap = (ConcurrentMap)_sessionDataById.get(string2);
        if (concurrentMap == null) {
            return null;
        }
        return concurrentMap.remove(string);
    }

    public static void removeAll(HttpSession httpSession) {
        String string = SessionUtil.getClientId(httpSession);
        if (string == null) {
            return;
        }
        String string2 = SessionUtil.getHashedSessionId(httpSession);
        SessionUtil.removeAll(string, httpSession, string2);
    }

    public static void removeAll(@Nullable String string, @Nullable HttpSession httpSession, @Nullable String string2) {
        if (string == null) {
            return;
        }
        String string3 = SessionUtil.getHashedClientId(string);
        if (httpSession != null && string2 == null) {
            try {
                string2 = SessionUtil.getHashedSessionId(httpSession);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        ConcurrentMap concurrentMap = (ConcurrentMap)_sessionDataById.remove(string);
        String string4 = null;
        if (concurrentMap != null) {
            string4 = SessionUtil.getContextPath(httpSession);
            int n = _sessionDataById.size();
            _logger.info((Object)("Removed clientId " + string3 + " for sessionId " + string2 + " with context path " + string4 + ". Total clientIds after the removal: " + n));
            SessionUtil.recordSessionHistory(httpSession, string2, string, string3, string4);
        } else {
            _logger.info((Object)("sessionId " + string2 + " is associated with clientId " + string3 + " which is already removed. Probably another related " + "session expired and removed it."));
        }
    }

    private static void recordSessionHistory(@Nullable HttpSession httpSession, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        boolean bl;
        Cache<String, SessionData> cache = _sessionHistoryRef.get();
        if (cache == null && !(bl = _sessionHistoryRef.compareAndSet(null, cache = CacheBuilder.newBuilder().maximumSize(700L).build())) && (cache = _sessionHistoryRef.get()) == null) {
            _logger.error((Object)"The history map was created and should have never been destroyed afterwards.");
            return;
        }
        String string5 = null;
        if (httpSession != null) {
            string5 = httpSession.getId();
            if (string4 == null) {
                string4 = SessionUtil.getContextPath(httpSession);
            }
            try {
                if (string == null) {
                    string = SessionUtil.getHashedSessionId(httpSession);
                }
                if (string2 == null) {
                    string2 = SessionUtil.getClientId(httpSession);
                }
                if (string3 == null) {
                    string3 = SessionUtil.getHashedClientId(string2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        boolean bl2 = SessionUtil.isLogoutFilterInStackTrace();
        SessionData sessionData = new SessionData(string5, string, string2, string3, string4, bl2);
        cache.put((Object)string2, (Object)sessionData);
    }

    private static boolean isLogoutFilterInStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().contains("org.springframework.security.web.authentication.logout.LogoutFilter")) continue;
            return true;
        }
        return false;
    }

    private static void logLiveClientIds() {
        try {
            Collection collection = _sessionDataById.values();
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new Comparator<ConcurrentMap<String, Object>>(){

                @Override
                public int compare(ConcurrentMap<String, Object> concurrentMap, ConcurrentMap<String, Object> concurrentMap2) {
                    String string = SessionUtil.getHashedClientId(concurrentMap);
                    String string2 = SessionUtil.getHashedClientId(concurrentMap2);
                    int n = string.compareTo(string2);
                    return n;
                }
            });
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
            for (ConcurrentMap concurrentMap : arrayList) {
                Set set;
                String string = SessionUtil.getHashedClientId(concurrentMap);
                int n = concurrentMap.size();
                if (n <= 5 && (set = concurrentMap.keySet()) != null) {
                    StringBuilder stringBuilder = new StringBuilder(50);
                    stringBuilder.append(string).append(' ');
                    stringBuilder.append(set.toString());
                    string = stringBuilder.toString();
                }
                arrayList2.add(string);
            }
            _logger.trace((Object)("Live clientIds: " + arrayList2));
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to print the live clientIds", (Throwable)exception);
        }
    }

    public static void dumpSessionAttributeNames(HttpSession httpSession) {
        if (!_logger.isTraceEnabled()) {
            return;
        }
        String string = SessionUtil.getClientId(httpSession);
        if (string == null) {
            return;
        }
        ConcurrentMap concurrentMap = (ConcurrentMap)_sessionDataById.get(string);
        if (concurrentMap == null) {
            return;
        }
        Iterator iterator = concurrentMap.keySet().iterator();
        while (iterator.hasNext()) {
            _logger.trace((Object)("Session attribute name : " + (String)iterator.next()));
        }
    }

    public static RequestInfo getRequestInfo() {
        RequestInfo requestInfo = new RequestInfo();
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        requestInfo.remoteAddr = httpServletRequest.getRemoteAddr();
        requestInfo.userAgent = httpServletRequest.getHeader("user-agent");
        return requestInfo;
    }

    public static String getHostName() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            _logger.error((Object)"Error getting host", (Throwable)unknownHostException);
            return null;
        }
    }

    public static String[] getHostIp() {
        String string = SessionUtil.getHostName();
        if (string == null) {
            return null;
        }
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InetAddress inetAddress : inetAddressArray) {
                if (inetAddress.isLoopbackAddress() || !inetAddress.isSiteLocalAddress()) continue;
                arrayList.add(inetAddress.getHostAddress());
            }
            Object[] objectArray = new String[arrayList.size()];
            return (String[])arrayList.toArray(objectArray);
        }
        catch (UnknownHostException unknownHostException) {
            _logger.error((Object)"Error getting host ip", (Throwable)unknownHostException);
            return null;
        }
    }

    public static String getClientId(HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        return SessionUtil.getClientId(httpSession, false);
    }

    private static String getClientId(@Nonnull HttpSession httpSession, boolean bl) {
        assert (httpSession != null);
        String string = null;
        try {
            string = (String)httpSession.getAttribute(CLIENT_ID_ATTR_NAME);
        }
        catch (IllegalStateException illegalStateException) {
            if (bl) {
                throw new SessionInvalidatedException("Failed to retrieve the clientId from the session", illegalStateException);
            }
            if (_logger.isDebugEnabled()) {
                _logger.warn((Object)"IllegalStateException in getClientId because session was already terminated.", (Throwable)illegalStateException);
            } else {
                _logger.warn((Object)"IllegalStateException in getClientId because session was already terminated.");
            }
            return null;
        }
        if (!StringUtil.isNullOrEmpty(string)) {
            return string;
        }
        if (bl) {
            throw new IllegalStateException("Failed to retrieve the clientId from the session");
        }
        return null;
    }

    public static String generateAndSaveClientId(HttpSession httpSession) {
        Object object;
        if (httpSession == null) {
            return null;
        }
        String string = SessionUtil.getClientId(httpSession);
        if (!StringUtil.isNullOrEmpty(string) && (object = SessionUtil.getSessionDataContainer(string, false)) != null) {
            return string;
        }
        string = UUID.randomUUID().toString();
        object = SessionUtil.initClientDataContainerAndAssociateSessionWithClientId(httpSession, string);
        _logger.info((Object)("ClientId " + (String)object + " was automatically generated"));
        return string;
    }

    public static String initClientDataContainerAndAssociateSessionWithClientId(@Nonnull HttpSession httpSession, @Nonnull String string) {
        String string2;
        String string3;
        String string4;
        if (StringUtil.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("clientId is null or whitespace");
        }
        if (httpSession == null) {
            throw new IllegalArgumentException("session is null");
        }
        if (_logger.isDebugEnabled() && (string4 = SessionUtil.getClientId(httpSession)) != null && !string.equals(string4)) {
            string3 = SessionUtil.getHashedSessionId(httpSession);
            string2 = SessionUtil.getHashedClientId(string4);
            _logger.debug((Object)("Session " + string3 + " is already associated with " + "another clientId - " + string2 + " - reassigning nonetheless."));
        }
        SessionUtil.generateSessionDataContainer(string, false);
        string4 = SessionUtil.getHashedClientId(string);
        SessionUtil.associateSessionWithClientId(httpSession, string);
        string3 = SessionUtil.getHashedSessionId(httpSession);
        string2 = SessionUtil.getContextPath(httpSession);
        _logger.info((Object)("Assigned clientId " + string4 + " to session " + string3 + " with context path: " + string2));
        return string4;
    }

    private static String getContextPath(HttpSession httpSession) {
        if (httpSession == null || httpSession.getServletContext() == null) {
            return null;
        }
        try {
            return httpSession.getServletContext().getContextPath();
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to determine the context path", (Throwable)exception);
            return "?";
        }
    }

    public static boolean markAsLoggingOut(@Nonnull HttpSession httpSession) {
        if (httpSession == null) {
            throw new IllegalArgumentException("The session is null");
        }
        String string = SessionUtil.getClientId(httpSession, true);
        return SessionUtil.doMarkAsLoggingOut(string);
    }

    public static boolean markAsLoggingOut(@Nonnull String string) {
        if (string == null) {
            throw new IllegalArgumentException("The clientId is null");
        }
        boolean bl = SessionUtil.doMarkAsLoggingOut(string);
        return bl;
    }

    private static boolean doMarkAsLoggingOut(@Nonnull String string) {
        boolean bl = SessionUtil.replaceData(LOGOUT_STATE_ATTR_NAME, null, (Object)LogoutState.LOGGING_OUT, string);
        if (bl) {
            String string2 = SessionUtil.getHashedClientId(string);
            _logger.info((Object)("Marked clientId " + string2 + " as logging out."));
        }
        return bl;
    }

    public static boolean markAsLoggedOut(@Nonnull HttpSession httpSession) {
        if (httpSession == null) {
            throw new IllegalArgumentException("The session is null");
        }
        String string = SessionUtil.getClientId(httpSession, true);
        boolean bl = SessionUtil.doMarkAsLoggedOut(string);
        return bl;
    }

    public static boolean markAsLoggedOut(@Nonnull String string) {
        if (string == null) {
            throw new IllegalArgumentException("clientId is null");
        }
        return SessionUtil.doMarkAsLoggedOut(string);
    }

    private static boolean doMarkAsLoggedOut(@Nonnull String string) {
        LogoutState logoutState = (LogoutState)((Object)SessionUtil.getData(LOGOUT_STATE_ATTR_NAME, string, true));
        if (logoutState != LogoutState.LOGGING_OUT) {
            return false;
        }
        boolean bl = SessionUtil.replaceData(LOGOUT_STATE_ATTR_NAME, (Object)logoutState, (Object)LogoutState.LOGGED_OUT, string);
        if (bl) {
            String string2 = SessionUtil.getHashedClientId(string);
            _logger.info((Object)("Marked clientId " + string2 + " as logged out."));
        }
        return bl;
    }

    public static boolean isLoggingOut(@Nonnull HttpSession httpSession) {
        if (httpSession == null) {
            throw new IllegalArgumentException("The session is null");
        }
        String string = SessionUtil.getClientId(httpSession);
        return SessionUtil.doIsLoggingOut(string);
    }

    public static boolean isLoggingOut(@Nonnull String string) {
        if (string == null) {
            return false;
        }
        return SessionUtil.doIsLoggingOut(string);
    }

    private static boolean doIsLoggingOut(@Nullable String string) {
        Object t = SessionUtil.getData(LOGOUT_STATE_ATTR_NAME, string);
        return t == LogoutState.LOGGING_OUT;
    }

    public static boolean isLoggedOut(@Nonnull HttpSession httpSession) {
        if (httpSession == null) {
            throw new IllegalArgumentException("The session is null");
        }
        String string = SessionUtil.getClientId(httpSession);
        return SessionUtil.doIsLoggedOut(string);
    }

    public static boolean isLoggedOut(@Nonnull String string) {
        if (string == null) {
            return false;
        }
        return SessionUtil.doIsLoggedOut(string);
    }

    private static boolean doIsLoggedOut(@Nullable String string) {
        Object t = SessionUtil.getData(LOGOUT_STATE_ATTR_NAME, string);
        return t == LogoutState.LOGGED_OUT;
    }

    public static boolean isLogoutInitiated(@Nonnull HttpSession httpSession) {
        if (httpSession == null) {
            throw new IllegalArgumentException("The session is null");
        }
        String string = SessionUtil.getClientId(httpSession);
        return SessionUtil.doIsLogoutInitiated(string);
    }

    public static boolean isLogoutInitiated(@Nonnull String string) {
        if (string == null) {
            return false;
        }
        return SessionUtil.doIsLogoutInitiated(string);
    }

    private static boolean doIsLogoutInitiated(@Nullable String string) {
        Object t = SessionUtil.getData(LOGOUT_STATE_ATTR_NAME, string);
        return t != null;
    }

    public static void associateSessionWithClientId(HttpSession httpSession, String string) {
        if (httpSession == null) {
            return;
        }
        String string2 = SessionUtil.getHashedClientId(string);
        if (string2 == null) {
            Object object;
            boolean bl = false;
            if (string != null) {
                object = (ConcurrentMap)_sessionDataById.get(string);
                boolean bl2 = bl = object != null;
            }
            if (string == null) {
                object = "is null";
            } else if (bl) {
                object = "exists";
            } else {
                String string3 = SessionUtil.getClientIdHistory(string, false);
                object = "doesn't exist (" + (string3 != null ? "history: " + string3 : "no history data available") + ")";
            }
            _logger.error((Object)("Tried to associate a session to an invalid clientId. (" + SessionUtil.getSessionInfo(httpSession) + ", the actual clientId is " + (string != null ? "not " : "") + "null, the new clientId " + (String)object + ")"));
            SessionUtil.logHistoryData(string);
            throw new IllegalArgumentException("Invalid clientId");
        }
        String string4 = SessionUtil.getHashedClientId(httpSession);
        httpSession.setAttribute(CLIENT_ID_ATTR_NAME, (Object)string);
        httpSession.setAttribute(HASHED_CLIENT_ID_ATTR_NAME, (Object)string2);
        SessionUtil.populateLogContext(httpSession);
        boolean bl = false;
        if (httpSession.getAttribute(CLEANUP_CLIENT_SESSION_LISTENER_ATTR_NAME) != null) {
            bl = true;
            SessionUtil.setData(CLEANUP_CLIENT_SESSION_LISTENER_ATTR_NAME, (Object)Boolean.TRUE, string, true);
        }
        String string5 = SessionUtil.getHashedSessionId(httpSession);
        String string6 = httpSession.getServletContext().getContextPath();
        _logger.info((Object)("Associated sessionId " + string5 + " with clientId " + string2 + (string4 != null ? ". It was previously associated with clientId " + string4 : "") + ". Context path: " + string6 + (bl ? ". This session can destroy the client data container when it expires" : "")));
    }

    public static boolean isCleanupClientSessionAssociatedWith(String string) {
        Validate.notEmpty((String)string);
        Object t = SessionUtil.getData(CLEANUP_CLIENT_SESSION_LISTENER_ATTR_NAME, string);
        return t != null;
    }

    public static boolean isAssociatedWithInvalidClientId(HttpSession httpSession) {
        ValidationUtil.paramsNotNull(httpSession);
        String string = SessionUtil.getClientId(httpSession);
        if (string == null) {
            return false;
        }
        ConcurrentMap<String, Object> concurrentMap = SessionUtil.getSessionDataContainer(string, false);
        return concurrentMap == null;
    }

    public static boolean isValidClientId(String string) {
        if (StringUtil.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("The clientId shouldn't be null or whitespace");
        }
        ConcurrentMap<String, Object> concurrentMap = SessionUtil.getSessionDataContainer(string, false);
        boolean bl = concurrentMap != null;
        return bl;
    }

    private static void populateLogContext(HttpSession httpSession) {
        if (httpSession == null) {
            LogUtil.removeSessionInfoFromLogContext();
        } else {
            HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
            if (httpServletRequest != null) {
                LogUtil.putRequestInfoIntoLogContext(httpServletRequest);
            } else if (LogUtil.containsRequestInfo()) {
                LogUtil.putSessionInfoIntoLogContext(httpSession);
            }
        }
    }

    public static ThreadContext getThreadContext() {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        HttpSession httpSession = SessionUtil.getHttpSession(false);
        ExecutionProfiler executionProfiler = _profiler.get();
        return new ThreadContext(httpServletRequest, httpSession, executionProfiler);
    }

    public static ThreadContext getThreadContext(boolean bl) {
        Object object = SessionUtil.getHttpRequest();
        if (bl && object != null && !(object instanceof InternalSessionRequestWrapper)) {
            object = new InternalSessionRequestWrapper((HttpServletRequest)object);
        }
        HttpSession httpSession = SessionUtil.getHttpSession(false);
        ExecutionProfiler executionProfiler = _profiler.get();
        return new ThreadContext((HttpServletRequest)object, httpSession, executionProfiler);
    }

    public static void setThreadContext(ThreadContext threadContext) {
        if (threadContext == null) {
            SessionUtil.setHttpRequest(null);
            SessionUtil.setHttpSession(null);
            LogUtil.removeRequestInfoFromLogContext();
        } else {
            HttpServletRequest httpServletRequest = threadContext.getHttpRequest();
            HttpSession httpSession = threadContext.getHttpSession();
            SessionUtil.setHttpRequest(httpServletRequest);
            SessionUtil.setHttpSession(httpSession);
            SessionUtil.setExecutionProfiler(threadContext.getProfiler());
            if (httpServletRequest != null) {
                LogUtil.putRequestInfoIntoLogContext(httpServletRequest);
            } else if (httpSession != null) {
                LogUtil.putSessionInfoIntoLogContext(httpSession);
            }
        }
    }

    public static String getHashedClientId() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        String string = SessionUtil.getHashedClientId(httpSession);
        return string;
    }

    public static String getHashedClientId(String string) {
        try {
            if (StringUtil.isNullOrEmpty(string)) {
                return null;
            }
            String string2 = (String)SessionUtil.getData(HASHED_CLIENT_ID_ATTR_NAME, string);
            return string2;
        }
        catch (Exception exception) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Failed to calculate hashedClientId", (Throwable)exception);
            } else {
                _logger.error((Object)("Failed to calculate hashedClientId: " + exception.getClass() + ": " + exception.getMessage()));
            }
            return null;
        }
    }

    private static String getHashedClientId(ConcurrentMap<String, Object> concurrentMap) {
        assert (concurrentMap != null);
        String string = (String)concurrentMap.get(HASHED_CLIENT_ID_ATTR_NAME);
        return string;
    }

    public static String getHashedClientId(HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        try {
            String string = (String)httpSession.getAttribute(HASHED_CLIENT_ID_ATTR_NAME);
            if (string != null) {
                return string;
            }
            String string2 = SessionUtil.getClientId(httpSession);
            if (string2 == null) {
                return null;
            }
            string = SessionUtil.getHashedClientId(string2);
            if (string != null) {
                httpSession.setAttribute(HASHED_CLIENT_ID_ATTR_NAME, (Object)string);
            }
            return string;
        }
        catch (Exception exception) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Failed to calculate hashedClientId", (Throwable)exception);
            } else {
                _logger.error((Object)("Failed to calculate hashedClientId: " + exception.getClass() + ": " + exception.getMessage()));
            }
            return null;
        }
    }

    private static String generateHashedClientId(String string) {
        Long l = HASHED_CLIENT_ID_GENERATOR.incrementAndGet();
        String string2 = String.valueOf(l);
        return string2;
    }

    public static String getHashedRequestId() {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        if (httpServletRequest == null) {
            return null;
        }
        String string = SessionUtil.getHashedRequestId(httpServletRequest);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHashedRequestId(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        String string = (String)httpServletRequest.getAttribute(HASHED_REQUEST_ID_ATTR_NAME);
        if (string != null) {
            return string;
        }
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        synchronized (httpServletRequest2) {
            string = (String)httpServletRequest.getAttribute(HASHED_REQUEST_ID_ATTR_NAME);
            if (string != null) {
                return string;
            }
            string = String.valueOf(HASHED_REQUEST_ID_GENERATOR.incrementAndGet());
            httpServletRequest.setAttribute(HASHED_REQUEST_ID_ATTR_NAME, (Object)string);
        }
        return string;
    }

    public static String getHashedSessionId() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        String string = SessionUtil.getHashedSessionId(httpSession);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHashedSessionId(HttpSession httpSession, boolean bl) {
        try {
            if (httpSession == null) {
                return null;
            }
            String string = (String)httpSession.getAttribute(HASHED_SESSION_ID_ATTR_NAME);
            if (string != null) {
                return string;
            }
            Object object = httpSession;
            synchronized (object) {
                string = (String)httpSession.getAttribute(HASHED_SESSION_ID_ATTR_NAME);
                if (string != null) {
                    return string;
                }
                Long l = HASHED_SESSION_ID_GENERATOR.incrementAndGet();
                string = String.valueOf(l);
                httpSession.setAttribute(HASHED_SESSION_ID_ATTR_NAME, (Object)string);
            }
            _logger.info((Object)("Generated hashed session id: " + string));
            object = SessionUtil.getHashedClientId(httpSession);
            if (bl) {
                SessionUtil.populateLogContext(httpSession);
            }
            if (object != null) {
                _logger.info((Object)("Mapping: " + SessionUtil.getContextPath(httpSession) + ": sessionid to -> " + string + " with clientId: " + (String)object));
            }
            return string;
        }
        catch (Exception exception) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Failed to calculate hashedSessionId", (Throwable)exception);
            } else {
                _logger.error((Object)("Failed to calculate hashedSessionId: " + exception.getClass() + ": " + exception.getMessage()));
            }
            return null;
        }
    }

    public static String getHashedSessionId(HttpSession httpSession) {
        return SessionUtil.getHashedSessionId(httpSession, true);
    }

    public static String getSessionInfo() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        String string = SessionUtil.getSessionInfo(httpSession);
        return string;
    }

    public static String getSessionInfo(HttpSession httpSession) {
        if (httpSession == null) {
            return "No session info";
        }
        String string = SessionUtil.getHashedSessionId(httpSession);
        String string2 = SessionUtil.getHashedClientId(httpSession);
        String string3 = SessionUtil.buildSessionInfoString(string, string2);
        return string3;
    }

    public static HashedSessionInfo getSessionInfoObject(HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        String string = SessionUtil.getHashedSessionId(httpSession);
        String string2 = SessionUtil.getHashedClientId(httpSession);
        return new HashedSessionInfo(string, string2);
    }

    private static String buildSessionInfoString(String string, String string2) {
        String string3 = "sessionId " + string + ", clientId " + string2;
        return string3;
    }

    public static String getExtendedSessionInfo() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        String string = SessionUtil.getExtendedSessionInfo(httpSession);
        return string;
    }

    public static String getExtendedSessionInfo(HttpSession httpSession) {
        if (httpSession == null) {
            return "No session info";
        }
        String string = SessionUtil.getHashedSessionId(httpSession);
        String string2 = SessionUtil.getHashedClientId(httpSession);
        String string3 = httpSession.getServletContext().getContextPath();
        boolean bl = SessionUtil.isLogoutInitiated(httpSession);
        String string4 = "sessionId " + string + ", clientId " + string2 + ", contextPath=" + string3 + ", logout_marker=" + bl;
        return string4;
    }

    public static ExecutionProfiler getExecutionProfiler() {
        ExecutionProfiler executionProfiler = _profiler.get();
        if (executionProfiler == null) {
            return ExecutionProfilerImpl.PASS_THROUGH_PROFILER;
        }
        return executionProfiler;
    }

    public static void enableProfiling() {
        SessionUtil.setData(PROFILING_PARAM_NAME, Boolean.TRUE);
    }

    public static boolean isProfilingEnabled() {
        Boolean bl = (Boolean)SessionUtil.getData(PROFILING_PARAM_NAME);
        boolean bl2 = bl != null && bl != false;
        return bl2;
    }

    public static void setExecutionProfiler(ExecutionProfiler executionProfiler) {
        _profiler.set(executionProfiler);
    }

    @CheckForNull
    public static String getClientIdHistory(String string, boolean bl) {
        if (StringUtil.isNullOrWhitespace(string)) {
            return null;
        }
        Cache<String, SessionData> cache = _sessionHistoryRef.get();
        if (cache == null) {
            return null;
        }
        SessionData sessionData = (SessionData)cache.getIfPresent((Object)string);
        if (sessionData == null) {
            return null;
        }
        if (bl) {
            return sessionData.toString();
        }
        return sessionData.toLimitedString();
    }

    @CheckForNull
    public static String getClientIdHistoryByHashedClientId(@Nullable String string) {
        if (StringUtil.isNullOrWhitespace(string)) {
            return null;
        }
        Cache<String, SessionData> cache = _sessionHistoryRef.get();
        if (cache == null) {
            return null;
        }
        for (Map.Entry entry : cache.asMap().entrySet()) {
            SessionData sessionData = (SessionData)entry.getValue();
            if (!string.equals(sessionData._hashedClientId)) continue;
            return sessionData.toString();
        }
        return null;
    }

    private static void logHistoryData(String string) {
        if (!_logger.isTraceEnabled()) {
            return;
        }
        Cache<String, SessionData> cache = _sessionHistoryRef.get();
        if (cache == null) {
            return;
        }
        SessionData sessionData = (SessionData)cache.getIfPresent((Object)string);
        if (sessionData != null && sessionData.compareAndSetAlreadyLogged(false, true)) {
            String string2 = sessionData.toString();
            _logger.trace((Object)string2);
        }
    }

    public static class HashedSessionInfo {
        private final String _hashedSessionId;
        private final String _hashedClientId;
        private volatile String _sessionInfoString;

        public HashedSessionInfo(@Nullable String string, @Nullable String string2) {
            this._hashedSessionId = string;
            this._hashedClientId = string2;
        }

        public String getHashedSessionId() {
            return this._hashedSessionId;
        }

        public String getHashedClientId() {
            return this._hashedClientId;
        }

        public String toString() {
            String string = this._sessionInfoString;
            if (string != null) {
                return string;
            }
            this._sessionInfoString = string = SessionUtil.buildSessionInfoString(this._hashedSessionId, this._hashedClientId);
            return string;
        }
    }

    private static enum LogoutState {
        LOGGING_OUT,
        LOGGED_OUT;

    }

    private static class InternalSessionRequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpSession _session;
        private final ConcurrentMap<String, Object> _attributes;

        public InternalSessionRequestWrapper(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
            this._session = httpServletRequest.getSession();
            this._attributes = new ConcurrentHashMap<String, Object>();
            Enumeration enumeration = httpServletRequest.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = httpServletRequest.getAttribute(string);
                this._attributes.put(string, object);
            }
        }

        public HttpSession getSession() {
            if (this._session != null) {
                return this._session;
            }
            return super.getSession();
        }

        public HttpSession getSession(boolean bl) {
            if (this._session != null) {
                return this._session;
            }
            return super.getSession(bl);
        }

        public Object getAttribute(String string) {
            if (string == null) {
                throw new IllegalArgumentException("The attribute name is null");
            }
            Object v = this._attributes.get(string);
            return v;
        }

        public void setAttribute(String string, Object object) {
            if (string == null) {
                throw new IllegalArgumentException("The attribute name is null");
            }
            if (object == null) {
                this.removeAttribute(string);
            } else {
                this._attributes.put(string, object);
            }
        }

        public void removeAttribute(String string) {
            this._attributes.remove(string);
        }

        public Enumeration<String> getAttributeNames() {
            IteratorEnumeration<String> iteratorEnumeration = new IteratorEnumeration<String>(this._attributes.keySet().iterator());
            return iteratorEnumeration;
        }

        private class IteratorEnumeration<E>
        implements Enumeration<E> {
            private final Iterator<E> _iterator;

            public IteratorEnumeration(Iterator<E> iterator) {
                this._iterator = iterator;
            }

            @Override
            public E nextElement() {
                return this._iterator.next();
            }

            @Override
            public boolean hasMoreElements() {
                return this._iterator.hasNext();
            }
        }
    }

    private static class SessionData {
        private static final SimpleDateFormat _dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        private final String _sessionId;
        private final String _hashedSessionId;
        private final String _clientId;
        private final String _hashedClientId;
        private final String _contextPath;
        private final boolean _explicitLogout;
        private final Date _timestamp;
        private AtomicBoolean _alreadyLogged = new AtomicBoolean(false);

        public SessionData(String string, String string2, String string3, String string4, String string5, boolean bl) {
            this._sessionId = string;
            this._hashedSessionId = string2;
            this._clientId = string3;
            this._hashedClientId = string4;
            this._contextPath = string5;
            this._explicitLogout = bl;
            this._timestamp = new Date();
        }

        public boolean compareAndSetAlreadyLogged(boolean bl, boolean bl2) {
            boolean bl3 = this._alreadyLogged.compareAndSet(bl, bl2);
            return bl3;
        }

        public String toString() {
            String string = _dateFormatter.format(this._timestamp);
            return this.getClass().getSimpleName() + ": hashedClientId=" + this._hashedClientId + ", clientId=" + this._clientId + ", hashedSessionId=" + this._hashedSessionId + ", sessionId=" + this._sessionId + ", contextPath=" + this._contextPath + ", explicitLogout=" + this._explicitLogout + ", timestamp=" + string;
        }

        public String toLimitedString() {
            String string = _dateFormatter.format(this._timestamp);
            return this.getClass().getSimpleName() + ": hashedClientId=" + this._hashedClientId + ", hashedSessionId=" + this._hashedSessionId + ", contextPath=" + this._contextPath + ", explicitLogout=" + this._explicitLogout + ", timestamp=" + string;
        }
    }

    public static class SessionUtilMXBean {
        public int getSessionDataByIdSize() {
            return _sessionDataById.size();
        }

        public String getClientIdHistoryByHashedClientId(String string) {
            String string2 = SessionUtil.getClientIdHistoryByHashedClientId(string);
            return string2;
        }
    }

    public static class ThreadContext {
        private final HttpServletRequest _request;
        private final ExecutionProfiler _profiler;
        private final HttpSession _session;

        private ThreadContext(HttpServletRequest httpServletRequest, HttpSession httpSession, ExecutionProfiler executionProfiler) {
            this._request = httpServletRequest;
            this._profiler = executionProfiler;
            this._session = httpSession;
        }

        private HttpServletRequest getHttpRequest() {
            return this._request;
        }

        private ExecutionProfiler getProfiler() {
            return this._profiler;
        }

        private HttpSession getHttpSession() {
            return this._session;
        }
    }

    private static class ExpirableData {
        private Date _expireOn;
        private Object _data;

        public ExpirableData(Object object, int n) {
            this._data = object;
            this._expireOn = new Date();
            this._expireOn.setTime(this._expireOn.getTime() + (long)n);
        }

        private boolean hasExpired() {
            Date date = new Date();
            return date.after(this._expireOn);
        }

        public Object getData() {
            if (this._data != null && this.hasExpired()) {
                this._data = null;
            }
            return this._data;
        }
    }
}

