/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.core.model;

import com.vmware.vise.core.model.DataObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;

public class NumberDataObject
extends DataObject {
    private Number _value;
    private Boolean _receivedValueAsString;

    public Number getValue() {
        return this._value;
    }

    public void setValue(Number number) {
        this._receivedValueAsString = null;
        this.doSetValue(number);
    }

    private void doSetValue(Number number) {
        this._value = number;
        this.setIsUnset(false);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        boolean bl = this.getIsUnset();
        objectOutput.writeBoolean(bl);
        if (!bl) {
            Number number = this.getValue();
            if (this._receivedValueAsString != null && this._receivedValueAsString.booleanValue() || this._receivedValueAsString == null && number != null && (number instanceof Long || number instanceof AtomicLong || number instanceof BigInteger || number instanceof BigDecimal)) {
                objectOutput.writeObject(null);
                objectOutput.writeObject(number.toString());
            } else {
                objectOutput.writeObject(number);
                objectOutput.writeObject(null);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        boolean bl = objectInput.readBoolean();
        this.setIsUnset(bl);
        if (bl) {
            this._receivedValueAsString = null;
            this._value = null;
        } else {
            Number number = (Number)objectInput.readObject();
            String string = (String)objectInput.readObject();
            this._receivedValueAsString = string != null && !"".equals(string.trim());
            if (this._receivedValueAsString.booleanValue()) {
                this.importValueFromString(string);
            } else {
                this.doSetValue(number);
            }
        }
    }

    private void importValueFromString(String string) {
        block10: {
            if (string == null || "".equals(string.trim())) {
                return;
            }
            try {
                Integer n = Integer.valueOf(string);
                this.doSetValue(n);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Long l = Long.valueOf(string);
                    this.doSetValue(l);
                }
                catch (NumberFormatException numberFormatException2) {
                    if (string.indexOf(46) >= 0) {
                        try {
                            BigDecimal bigDecimal = new BigDecimal(string);
                            this.doSetValue(bigDecimal);
                            break block10;
                        }
                        catch (NumberFormatException numberFormatException3) {
                            throw new NumberFormatException("The string is not a valid number: " + string);
                        }
                    }
                    try {
                        BigInteger bigInteger = new BigInteger(string);
                        this.doSetValue(bigInteger);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        throw new NumberFormatException("The string is not a valid number: " + string);
                    }
                }
            }
        }
    }

    Boolean getFlagReceivedValueAsString() {
        return this._receivedValueAsString;
    }

    void setFlagReceivedValueAsString(Boolean bl) {
        this._receivedValueAsString = bl;
    }
}

