/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.ha.proactive.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HealthUpdateManager;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfraHelper {
    private static final Log _logger = LogFactory.getLog(InfraHelper.class);
    private ManagedObjectReference _clusterRef;
    private Boolean _isInitialized = false;
    private HealthUpdateManager _healthManager;

    public ManagedObjectReference getCluster() {
        return this._clusterRef;
    }

    public HealthUpdateManager getHealthManager() {
        return this._healthManager;
    }

    public InfraHelper(ManagedObjectReference cluster) {
        this._clusterRef = cluster;
    }

    public void initialize() {
        if (this._isInitialized.booleanValue() || this._clusterRef == null) {
            return;
        }
        try {
            VcService service = VimSessionUtil.getService((String)this._clusterRef.getServerGuid());
            if (service == null) {
                _logger.error((Object)"Could not retrieve VcService");
                return;
            }
            ServiceInstanceContent serviceContent = service.getServiceInstanceContent();
            if (serviceContent == null) {
                _logger.error((Object)"Could not retrieve ServiceInstanceContent");
                return;
            }
            this._healthManager = (HealthUpdateManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getHealthUpdateManager());
            if (this._healthManager == null) {
                _logger.error((Object)"Could not retrieve HealthUpdateManager");
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception occured while retrieving the HealthUpdateManager " + ex));
            ex.printStackTrace();
            return;
        }
        this._isInitialized = true;
    }

    public boolean isReady() {
        return this._clusterRef != null && this._healthManager != null && this._isInitialized != false;
    }

    public ManagedObjectReference[] getHostsUnderCluster() throws Exception {
        if (!this.isReady()) {
            return null;
        }
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)this._clusterRef);
        return cluster.getHost();
    }

    public String getHostName(ManagedObjectReference hostMoref) throws Exception {
        HostSystem result = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostMoref);
        return result != null ? result.getName() : null;
    }

    public boolean isCluster(ManagedObjectReference moRef) {
        if (!this.isReady() || moRef == null) {
            return false;
        }
        return moRef.getValue().equals(this._clusterRef.getValue());
    }

    public String getClusterMoid() {
        return this._clusterRef.getValue();
    }

    public ManagedObjectReference getMorefFromString(String strMoref) {
        ManagedObjectReference[] hostMorefs;
        if (this._clusterRef.getValue().equals(strMoref)) {
            return this._clusterRef;
        }
        ClusterComputeResource clusterRes = null;
        try {
            clusterRes = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)this._clusterRef);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (ManagedObjectReference mor : hostMorefs = clusterRes == null ? null : clusterRes.getHost()) {
            if (!mor.getValue().equals(strMoref)) continue;
            return mor;
        }
        return null;
    }
}

