/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.impl;

import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vim.TaskHistoryCollector;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskManager;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.DasAdvancedRuntimeInfo;
import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.cluster.DasFailoverLevelAdvancedRuntimeInfo;
import com.vmware.vim.binding.vim.cluster.DasFdmAvailabilityState;
import com.vmware.vim.binding.vim.cluster.DasFdmHostState;
import com.vmware.vim.binding.vim.cluster.FailoverLevelAdmissionControlPolicy;
import com.vmware.vim.binding.vim.cluster.FailoverResourcesAdmissionControlPolicy;
import com.vmware.vim.binding.vim.cluster.GroupInfo;
import com.vmware.vim.binding.vim.cluster.ResourceUsageSummary;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.vm.QuestionInfo;
import com.vmware.vim.binding.vim.vm.RuntimeInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.data.query.type;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.cluster.HaConfigIssue;
import com.vmware.vsphere.client.cluster.HaFailoverLevelPrecheckResult;
import com.vmware.vsphere.client.cluster.HostHaObject;
import com.vmware.vsphere.client.cluster.HostHaRuntimeInfo;
import com.vmware.vsphere.client.cluster.VmHaRuntimeInfo;
import com.vmware.vsphere.client.cluster.VmStateAndSlotInfo;
import com.vmware.vsphere.client.cluster.groups.GroupsFilterByNameSpec;
import com.vmware.vsphere.client.cluster.ha.AutoResourcePercentage;
import com.vmware.vsphere.client.cluster.ha.HeartbeatDatastoreCandidatesRetriever;
import com.vmware.vsphere.client.cluster.ha.VmcpPrecheckResult;
import com.vmware.vsphere.client.cluster.ha.VmcpPreflighChecker;
import com.vmware.vsphere.client.cluster.ha.proactive.FilterModel;
import com.vmware.vsphere.client.cluster.ha.proactive.ProviderModel;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.FilterManager;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.InfraHelper;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.ProviderManager;
import com.vmware.vsphere.client.cluster.ha.vmcp.InaccessibleDatastoreInfo;
import com.vmware.vsphere.client.cluster.ha.vmcp.InaccessibleDatastoreInfoRetriever;
import com.vmware.vsphere.client.cluster.rp.MorTree;
import com.vmware.vsphere.client.cluster.rp.RpInfo;
import com.vmware.vsphere.client.cluster.rp.RpTreeSerDes;
import com.vmware.vsphere.client.cluster.rp.RpTreeSnapshotter;
import com.vmware.vsphere.client.cluster.rules.RuleInfoEx;
import com.vmware.vsphere.client.cluster.rules.impl.ClusterRuleSpecValidator;
import com.vmware.vsphere.client.cluster.util.EventUtil;
import com.vmware.vsphere.client.cluster.util.Util;
import com.vmware.vsphere.client.common.util.ObjectNamesRetriever;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterServicePropertyProvider
implements PropertyProviderBean {
    private static final String DRS_RUN = "ClusterComputeResource.refreshRecommendation";
    private static final int NUM_TASKS = 10;
    private static final String PROPERTY_CLUSTER_GROUPS = "configurationEx[@type='ClusterConfigInfoEx'].group";
    private static final String DAS_VM_PROTECTION_PROPERTY = "summary.runtime.dasVmProtection";
    private static final String VIRTUAL_MACHINE = "VirtualMachine";
    private static final String VM_PROPERTY = "vm";
    private static final String NAME_PROPERTY = "name";
    private static final String HOST_PROPERTY = "host";
    private static final String CONFIG_ISSUE_PROPERTY = "configIssue";
    private static final String DEFAULT_HARDWARE_VERSION_KEY = "configurationEx.defaultHardwareVersionKey";
    private static final String CLUSTER_TO_HOST_RELATION = "host";
    private static final String HOST_SYSTEM = "HostSystem";
    private static final String VFLASH_CAPACITY = "runtime.vFlashResourceRuntimeInfo.capacity";
    private static final String ADMISSION_CONTROL_POLICY_PROPERTY = "configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy";
    private static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    private static final String VC_VERSION_5_1 = "5.1";
    private static final Log _logger = LogFactory.getLog(ClusterServicePropertyProvider.class);
    private static final String PROP_HOST_MEMORY = "systemResources.config.memoryAllocation.reservation";
    private static final String PROP_HOST_CPU = "systemResources.config.cpuAllocation.reservation";
    private static final String PROP_HOST_CONNECTION_STATE = "runtime.connectionState";
    private static final String PROP_HOST_IN_MAINTENANCE = "runtime.inMaintenanceMode";
    private static final String PROP_HOST_STANDBY = "runtime.standbyMode";
    private static final String PROP_HOST_NAME = "name";
    private static final String PROP_HOSTS = "host";
    private static final int SIZE_IN_MB = 0x100000;
    private static final String PROP_HOST_COUNT = "host._length";
    private DataService _dataService;
    private HeartbeatDatastoreCandidatesRetriever _hbDatastoreCandidatesRetriever;
    private VmcpPreflighChecker _vmcpPreflighChecker;
    private InaccessibleDatastoreInfoRetriever _inaccessibleDatastoreInfoRetriever;

    public ClusterServicePropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public void setHbDatastoreCandidatesRetriever(HeartbeatDatastoreCandidatesRetriever hbDatastoreCandidatesRetriever) {
        this._hbDatastoreCandidatesRetriever = hbDatastoreCandidatesRetriever;
    }

    public void setVmcpPreflighChecker(VmcpPreflighChecker vmcpPreflighChecker) {
        this._vmcpPreflighChecker = vmcpPreflighChecker;
    }

    public void setInaccessibleDatastoreInfoRetriever(InaccessibleDatastoreInfoRetriever inaccessibleDatastoreInfoRetriever) {
        this._inaccessibleDatastoreInfoRetriever = inaccessibleDatastoreInfoRetriever;
    }

    @type(value="ClusterComputeResource")
    @PropertyProvider(value="ClusterComputeResource/ruleConflictInfo")
    public RuleInfoEx[] getRuleConflictInfo(ManagedObjectReference clusterRef) throws Exception {
        ClusterRuleSpecValidator validator = new ClusterRuleSpecValidator(this._dataService, clusterRef, null);
        return validator.getConflictsForExistingRules();
    }

    @type(value="ClusterComputeResource")
    public EVCMode[] getSupportedEvcMode(ManagedObjectReference clusterRef) {
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        VcService service = VimSessionUtil.getService((String)clusterRef.getServerGuid());
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        ServiceInstance si = service.getServiceInstance();
        if (si == null) {
            _logger.error((Object)"Could not retrieve service instance");
            return null;
        }
        Capability caps = si.getCapability();
        if (caps == null) {
            _logger.error((Object)"Could not retrieve instance caps");
            return null;
        }
        return caps.supportedEVCMode;
    }

    @type(value="ClusterComputeResource")
    public DasAdvancedRuntimeInfo getDasAdvancedRuntimeInfo(ManagedObjectReference clusterRef) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        if (cluster == null) {
            _logger.error((Object)"Could not retrieve ClusterComputeResource");
            return null;
        }
        return cluster.retrieveDasAdvancedRuntimeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @type(value="ClusterComputeResource")
    public Date getLastDrsRun(ManagedObjectReference clusterRef) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        VcService service = VimSessionUtil.getService((String)clusterRef.getServerGuid());
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        ServiceInstanceContent serviceContent = service.getServiceInstanceContent();
        if (serviceContent == null) {
            _logger.error((Object)"Could not retrieve ServiceInstanceContent");
            return null;
        }
        TaskManager tm = (TaskManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getTaskManager());
        if (tm == null) {
            _logger.error((Object)"Could not retrieve TaskManager");
            return null;
        }
        TaskFilterSpec tfs = new TaskFilterSpec();
        tfs.entity = new TaskFilterSpec.ByEntity();
        tfs.entity.entity = clusterRef;
        tfs.entity.recursion = TaskFilterSpec.RecursionOption.self;
        ManagedObjectReference thcRef = null;
        try {
            thcRef = tm.createCollector(tfs);
        }
        catch (Exception e) {
            _logger.error((Object)"Could not create Collector", (Throwable)e);
            return null;
        }
        TaskHistoryCollector thc = (TaskHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)thcRef);
        if (thc == null) {
            _logger.error((Object)"Could not get TaskHistoryCollector");
            return null;
        }
        try {
            TaskInfo[] tasks = thc.readNext(10);
            while (tasks != null) {
                for (TaskInfo task : tasks) {
                    if (task == null || !DRS_RUN.equals(task.descriptionId)) continue;
                    Date date = task.completeTime.getTime();
                    return date;
                }
                tasks = thc.readNext(10);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error while retrieveing task history", (Throwable)e);
        }
        finally {
            thc.remove();
        }
        return null;
    }

    @type(value="ClusterComputeResource")
    public GroupInfo[] getClusterGroups(ManagedObjectReference clusterRef, GroupsFilterByNameSpec filterSpec) throws Exception {
        GroupInfo[] clusterGroups = this.getClusterGroups(clusterRef);
        clusterGroups = this.filterGroupsByName(clusterGroups, filterSpec, true);
        return clusterGroups;
    }

    @type(value="ClusterComputeResource")
    public HostHaRuntimeInfo getHostHaRuntimeInfo(ManagedObjectReference clusterRef) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] pv = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)clusterRef, (String)"host", (String)HOST_SYSTEM, (String[])new String[]{"name", "summary.runtime.dasHostState", "summary.runtime.connectionState", "summary.runtime.standbyMode", "summary.runtime.inMaintenanceMode"});
        HostHaRuntimeInfo hostInfo = new HostHaRuntimeInfo();
        HashMap<ManagedObjectReference, HostHaObject> hostsMap = new HashMap<ManagedObjectReference, HostHaObject>();
        for (PropertyValue propertyValue : pv) {
            if (hostsMap.get(propertyValue.resourceObject) == null) {
                hostsMap.put((ManagedObjectReference)propertyValue.resourceObject, new HostHaObject());
            }
            ((HostHaObject)hostsMap.get(propertyValue.resourceObject)).set(propertyValue);
        }
        for (HostHaObject host : hostsMap.values()) {
            this.updateHostAvailabilityState(hostInfo, host);
            this.updateDisconnectedFromVcCount(hostInfo, host);
            this.updateStandbyModeCount(hostInfo, host);
            this.updateInMaintenanceModeCount(hostInfo, host);
        }
        int numOfHostsInCluster = hostsMap.size();
        this.udpateHostsNotConnectedCount(hostInfo, numOfHostsInCluster);
        return hostInfo;
    }

    @type(value="ClusterComputeResource")
    public VmHaRuntimeInfo getVmHaRuntimeInfo(ManagedObjectReference clusterRef) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] pv = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)clusterRef, (String)VM_PROPERTY, (String)VIRTUAL_MACHINE, (String[])new String[]{DAS_VM_PROTECTION_PROPERTY});
        VmHaRuntimeInfo vmInfo = new VmHaRuntimeInfo();
        for (PropertyValue p : pv) {
            if (!p.propertyName.equals(DAS_VM_PROTECTION_PROPERTY)) continue;
            this.updateVmDasCount(vmInfo, (RuntimeInfo.DasProtectionState)p.value);
        }
        return vmInfo;
    }

    @type(value="ClusterComputeResource")
    public HaConfigIssue[] getHaConfigIssues(ManagedObjectReference clusterRef) throws Exception {
        int issuesCount;
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] clusterProperties = QueryUtil.getProperties((DataService)this._dataService, (Object)clusterRef, (String[])new String[]{CONFIG_ISSUE_PROPERTY, "name"});
        PropertyValue[] hostProperties = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)clusterRef, (String)"host", (String)HOST_SYSTEM, (String[])new String[]{CONFIG_ISSUE_PROPERTY, "name", "summary.runtime.dasHostState"});
        List<HaConfigIssue> clusterConfigIssues = null;
        List<HaConfigIssue> hostsConfigIssues = null;
        if (clusterProperties != null && clusterProperties.length > 0) {
            clusterConfigIssues = ClusterServicePropertyProvider.getConfigIssuesForEntity(clusterRef, clusterProperties);
        }
        if (hostProperties != null && hostProperties.length > 0) {
            hostsConfigIssues = ClusterServicePropertyProvider.getConfigIssuesForHosts(hostProperties);
        }
        if ((issuesCount = (clusterConfigIssues == null ? 0 : clusterConfigIssues.size()) + (hostsConfigIssues == null ? 0 : hostsConfigIssues.size())) == 0) {
            return null;
        }
        ArrayList<HaConfigIssue> configIssues = new ArrayList<HaConfigIssue>(issuesCount);
        configIssues.addAll(clusterConfigIssues);
        configIssues.addAll(hostsConfigIssues);
        return (HaConfigIssue[])ArrayUtil.toArray(configIssues, HaConfigIssue.class);
    }

    @type(value="ClusterComputeResource")
    public HaFailoverLevelPrecheckResult getReconfigureHaFailoverLevelPrecheckResult(ManagedObjectReference clusterRef, DasConfigInfo dasConfigInfo) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Null cluster moref encountered.");
            throw new IllegalArgumentException("Null cluster moref encountered.");
        }
        if (dasConfigInfo == null) {
            _logger.error((Object)"Null dasConfigInfo specified.");
            throw new IllegalArgumentException("Null dasConfigInfo specified.");
        }
        if (dasConfigInfo.admissionControlPolicy == null) {
            _logger.error((Object)"Null admissionControlPolicy specified.");
            throw new IllegalArgumentException("Null admissionControlPolicy specified.");
        }
        if (!(dasConfigInfo.admissionControlPolicy instanceof FailoverLevelAdmissionControlPolicy)) {
            _logger.error((Object)"The admissionControlPolicy must be instance of FailoverLevelAdmissionControlPolicy.");
            throw new IllegalArgumentException("The admissionControlPolicy must be instance of FailoverLevelAdmissionControlPolicy.");
        }
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        DasAdvancedRuntimeInfo advancedRuntimeInfo = cluster.checkReconfigureDas(dasConfigInfo, true).getAdmission().getAdvancedInfo();
        if (!(advancedRuntimeInfo instanceof DasFailoverLevelAdvancedRuntimeInfo)) {
            _logger.error((Object)"The expected DasAdvancedRuntimeInfo is not an instance of DasFailoverLevelAdvancedRuntimeInfo");
            throw new IllegalStateException("The expected DasAdvancedRuntimeInfo is not an instance of DasFailoverLevelAdvancedRuntimeInfo");
        }
        DasFailoverLevelAdvancedRuntimeInfo failoverLevelAdvancedRuntimeInfo = (DasFailoverLevelAdvancedRuntimeInfo)advancedRuntimeInfo;
        DasFailoverLevelAdvancedRuntimeInfo.VmSlots[] vmSlots = failoverLevelAdvancedRuntimeInfo.getVmsRequiringMultipleSlots();
        HaFailoverLevelPrecheckResult precheckResult = new HaFailoverLevelPrecheckResult();
        precheckResult.totalVms = failoverLevelAdvancedRuntimeInfo.totalVms;
        if (vmSlots != null && vmSlots.length > 0) {
            PropertyValue[] vmsProperties;
            VmStateAndSlotInfo[] vmInfos = new VmStateAndSlotInfo[vmSlots.length];
            Object[] vmMors = new ManagedObjectReference[vmSlots.length];
            for (int i = 0; i < vmSlots.length; ++i) {
                vmMors[i] = vmSlots[i].vm;
                vmInfos[i] = new VmStateAndSlotInfo();
                vmInfos[i].vmMor = vmSlots[i].vm;
                vmInfos[i].requiredSlots = vmSlots[i].slots;
            }
            for (PropertyValue pv : vmsProperties = QueryUtil.getProperties((DataService)this._dataService, (Object[])vmMors, (String[])new String[]{"name", "overallStatus", "runtime.powerState", "runtime.question", "runtime.faultToleranceState", "ftRole"})) {
                for (VmStateAndSlotInfo vmInfo : vmInfos) {
                    if (!pv.resourceObject.equals(vmInfo.vmMor)) continue;
                    if (pv.propertyName.equals("name")) {
                        vmInfo.vmName = (String)pv.value;
                        continue;
                    }
                    if (pv.propertyName.equals("overallStatus")) {
                        vmInfo.overallStatus = (ManagedEntity.Status)pv.value;
                        continue;
                    }
                    if (pv.propertyName.equals("runtime.powerState")) {
                        vmInfo.powerState = (VirtualMachine.PowerState)pv.value;
                        continue;
                    }
                    if (pv.propertyName.equals("runtime.question")) {
                        vmInfo.questionInfo = (QuestionInfo)pv.value;
                        continue;
                    }
                    if (pv.propertyName.equals("runtime.faultToleranceState")) {
                        vmInfo.ftState = (VirtualMachine.FaultToleranceState)pv.value;
                        continue;
                    }
                    if (!pv.propertyName.equals("ftRole")) continue;
                    vmInfo.ftRole = (Integer)pv.value;
                }
            }
            precheckResult.vmsRequiringMultipleSlots = vmInfos;
        }
        return precheckResult;
    }

    @type(value="ClusterComputeResource")
    public String getVcVersion(ManagedObjectReference clusterRef) {
        if (clusterRef == null) {
            _logger.error((Object)"Null cluster moref encountered.");
            throw new IllegalArgumentException("Null cluster moref encountered.");
        }
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry(null);
        LinkedVcGroup group = registry.getLinkedGroupByServiceUuid(clusterRef.getServerGuid());
        VcService vcService = group.getVcService(clusterRef.getServerGuid());
        return vcService.getServiceVersion();
    }

    @type(value="ClusterComputeResource")
    public boolean getVmcpSupported(ManagedObjectReference clusterRef) {
        return !this.getVcVersion(clusterRef).startsWith(VC_VERSION_5_1);
    }

    @type(value="ClusterComputeResource")
    public byte[] getRpTreeSnapshot(ManagedObjectReference clusterRef) throws Exception {
        byte[] rpTreeBytes;
        MorTree<ManagedObjectReference, RpInfo> rpTree;
        ValidationUtil.paramsNotNull((Object[])new Object[]{clusterRef});
        DataFetchCommand dataFetchCommand = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
        RpTreeSnapshotter rpTreeSnapshoter = new RpTreeSnapshotter(dataFetchCommand);
        try {
            rpTree = rpTreeSnapshoter.snaphotRpTree(clusterRef);
        }
        catch (Exception e) {
            _logger.error((Object)"Error occured during retrieving of cluster rp tree", (Throwable)e);
            Exception localizedEx = new Exception(Util.getLocalizedString("rp.error.retrieve.rpTreeSnapshot"), e);
            throw localizedEx;
        }
        RpTreeSerDes rpTreeSerDes = new RpTreeSerDes();
        try {
            rpTreeBytes = rpTreeSerDes.serialize(rpTree);
        }
        catch (Exception e) {
            _logger.error((Object)"Error occured during serialization of cluster rp tree", (Throwable)e);
            Exception localizedEx = new Exception(Util.getLocalizedString("rp.error.serialization"), e);
            throw localizedEx;
        }
        return rpTreeBytes;
    }

    @type(value="ClusterComputeResource")
    public ManagedObjectReference[] getHbDatastoreCandidates(ManagedObjectReference clusterRef) throws Exception {
        ManagedObjectReference[] datastores = new ManagedObjectReference[]{};
        if (this._hbDatastoreCandidatesRetriever != null) {
            datastores = this._hbDatastoreCandidatesRetriever.getHeartbeatDatastoreCandidates(clusterRef);
        }
        return datastores;
    }

    @type(value="ClusterComputeResource")
    public Long getAggregatedVFlashCapacity(ManagedObjectReference clusterRef) throws Exception {
        PropertyValue[] pv;
        Long totalVFlashCapacity = 0L;
        for (PropertyValue propertyValue : pv = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)clusterRef, (String)"host", (String)HOST_SYSTEM, (String[])new String[]{VFLASH_CAPACITY})) {
            Long hostVFlashCapacity = (Long)propertyValue.value;
            if (hostVFlashCapacity == null) continue;
            totalVFlashCapacity = totalVFlashCapacity + hostVFlashCapacity;
        }
        return totalVFlashCapacity;
    }

    @type(value="ClusterComputeResource")
    public ResourceUsageSummary getResourceUsage(ManagedObjectReference clusterRef) throws Exception {
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        ResourceUsageSummary usage = cluster.getResourceUsage();
        return usage;
    }

    @type(value="ClusterComputeResource")
    public boolean getIsLevelAdmissionControlPolicy(ManagedObjectReference clusterRef) throws Exception {
        Object policy = QueryUtil.getProperty((DataService)this._dataService, (Object)clusterRef, (String)ADMISSION_CONTROL_POLICY_PROPERTY);
        return policy != null && policy instanceof FailoverLevelAdmissionControlPolicy;
    }

    @type(value="ClusterComputeResource")
    public String getDefaultHardwareVersionKey(ManagedObjectReference clusterRef) throws Exception {
        String defaultHardwareVersionKey = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)clusterRef, (String)DEFAULT_HARDWARE_VERSION_KEY);
        return defaultHardwareVersionKey;
    }

    @type(value="ClusterComputeResource")
    public boolean getIsResourcesAdmissionControlPolicy(ManagedObjectReference clusterRef) throws Exception {
        Object policy = QueryUtil.getProperty((DataService)this._dataService, (Object)clusterRef, (String)ADMISSION_CONTROL_POLICY_PROPERTY);
        return policy != null && policy instanceof FailoverResourcesAdmissionControlPolicy;
    }

    @type(value="ClusterComputeResource")
    public VmcpPrecheckResult getVmcpPrecheckResult(ManagedObjectReference clusterRef, DasConfigInfo dasConfigInfo) throws Exception {
        VmcpPrecheckResult precheckResult = new VmcpPrecheckResult();
        if (this._vmcpPreflighChecker != null) {
            precheckResult = this._vmcpPreflighChecker.runVmcpPreflightCheck(clusterRef, dasConfigInfo);
        }
        return precheckResult;
    }

    @type(value="ClusterComputeResource")
    public InaccessibleDatastoreInfo[] getInaccessibleDatastoreInfo(ManagedObjectReference clusterRef) throws Exception {
        InaccessibleDatastoreInfo[] inaccessibleDsInfos = new InaccessibleDatastoreInfo[]{};
        if (this._inaccessibleDatastoreInfoRetriever != null) {
            inaccessibleDsInfos = this._inaccessibleDatastoreInfoRetriever.getInaccessibleDatastoreInfo(clusterRef);
        }
        return inaccessibleDsInfos;
    }

    @type(value="ClusterComputeResource")
    public ProviderModel[] getHealthUpdateProviders(ManagedObjectReference clusterRef) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        InfraHelper controller = new InfraHelper(clusterRef);
        controller.initialize();
        ProviderManager manager = new ProviderManager(controller);
        return manager.initialize().getValidProviders();
    }

    @type(value="ClusterComputeResource")
    public FilterModel getFilterForProvider(ManagedObjectReference clusterRef, String providerId) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        if (Strings.isNullOrEmpty((String)providerId)) {
            _logger.error((Object)"Null providerId encountered.");
            return null;
        }
        try {
            InfraHelper infraHelper = new InfraHelper(clusterRef);
            infraHelper.initialize();
            FilterManager manager = new FilterManager(infraHelper);
            return manager.reset().setProvider(providerId).getFilter();
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception occurred while fetching the FilterList" + ex));
            return null;
        }
    }

    @type(value="ClusterComputeResource")
    public AutoResourcePercentage getAutoComputeValues(ManagedObjectReference clusterRef, int hfctValue) throws Exception {
        if (clusterRef == null) {
            _logger.error((Object)"Null moref encountered.");
            return null;
        }
        PropertyValue[] hostProperties = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)clusterRef, (String)"host", (String)HostSystem.class.getSimpleName(), (String[])new String[]{"name", PROP_HOST_CPU, PROP_HOST_MEMORY, PROP_HOST_CONNECTION_STATE, PROP_HOST_IN_MAINTENANCE, PROP_HOST_STANDBY});
        if (hostProperties == null) {
            _logger.error((Object)"hostInfo is null.");
            return null;
        }
        ArrayList<Long> hostCPU = new ArrayList<Long>();
        ArrayList<Long> hostMemory = new ArrayList<Long>();
        long clusterTotalCPU = 0L;
        long clusterTotalMemory = 0L;
        try {
            for (PropertyValue pv : hostProperties = this.skipBadHAHosts(hostProperties)) {
                if (PROP_HOST_CPU.equals(pv.propertyName)) {
                    Long cpu = (Long)pv.value;
                    hostCPU.add(cpu);
                    clusterTotalCPU += cpu.longValue();
                    continue;
                }
                if (!PROP_HOST_MEMORY.equals(pv.propertyName)) continue;
                Long mem = (Long)pv.value;
                hostMemory.add(mem);
                clusterTotalMemory += mem.longValue();
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"error while retrieving the host summary data");
            return null;
        }
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        ResourceUsageSummary usage = cluster.getResourceUsage();
        if (usage != null && clusterTotalCPU != (long)usage.cpuCapacityMHz) {
            clusterTotalCPU = usage.cpuCapacityMHz;
        }
        if (usage != null && clusterTotalMemory != (long)usage.memCapacityMB) {
            clusterTotalMemory = usage.memCapacityMB;
        }
        AutoResourcePercentage resultAutoCompute = new AutoResourcePercentage();
        if (hfctValue >= hostCPU.size()) {
            resultAutoCompute.percentCPU = 100;
            resultAutoCompute.percentMemory = 100;
            return resultAutoCompute;
        }
        Collections.sort(hostCPU, Collections.reverseOrder());
        Collections.sort(hostMemory, Collections.reverseOrder());
        long hfctCPU = 0L;
        long hfctMemory = 0L;
        for (int i = 0; i < hfctValue; ++i) {
            hfctCPU += ((Long)hostCPU.get(i)).longValue();
            hfctMemory += ((Long)hostMemory.get(i)).longValue();
        }
        resultAutoCompute.percentCPU = (int)(hfctCPU * 100L / clusterTotalCPU);
        resultAutoCompute.percentMemory = (int)(hfctMemory * 100L / clusterTotalMemory);
        return resultAutoCompute;
    }

    private PropertyValue[] skipBadHAHosts(PropertyValue[] input) {
        HashSet<Object> whiteList = new HashSet<Object>();
        HashSet<Object> blackList = new HashSet<Object>();
        for (PropertyValue pv : input) {
            Object host = pv.resourceObject;
            String name = pv.propertyName;
            Object value = pv.value;
            if (PROP_HOST_CONNECTION_STATE.equals(name)) {
                HostSystem.ConnectionState connection = (HostSystem.ConnectionState)value;
                if (HostSystem.ConnectionState.disconnected.compareTo((Enum)connection) == 0) {
                    blackList.add(host);
                    continue;
                }
                whiteList.add(host);
                continue;
            }
            if (PROP_HOST_IN_MAINTENANCE.equals(name)) {
                Boolean maintenance = (Boolean)value;
                if (!maintenance.booleanValue()) {
                    whiteList.add(host);
                    continue;
                }
                blackList.add(host);
                continue;
            }
            if (!PROP_HOST_STANDBY.equals(name)) continue;
            String standby = (String)value;
            String none = HostSystem.StandbyMode.none.name();
            if (none.equals(standby)) {
                whiteList.add(host);
                continue;
            }
            blackList.add(host);
        }
        ArrayList<PropertyValue> output = new ArrayList<PropertyValue>();
        for (PropertyValue pv : input) {
            Object host = pv.resourceObject;
            if (blackList.contains(host) || !whiteList.contains(host)) continue;
            output.add(pv);
        }
        PropertyValue[] dummy = new PropertyValue[]{};
        PropertyValue[] retVal = output.toArray(dummy);
        return retVal;
    }

    private GroupInfo[] getClusterGroups(ManagedObjectReference clusterRef) throws Exception {
        GroupInfo[] clusterGroups = (GroupInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)clusterRef, (String)PROPERTY_CLUSTER_GROUPS);
        return clusterGroups != null ? clusterGroups : new GroupInfo[]{};
    }

    private GroupInfo[] filterGroupsByName(GroupInfo[] clusterGroups, GroupsFilterByNameSpec filterSpec, Boolean areGroupsUniqueByName) {
        if (filterSpec == null || ArrayUtil.isNullOrEmpty((Object[])filterSpec.names) || ArrayUtil.isNullOrEmpty((Object[])clusterGroups)) {
            return clusterGroups;
        }
        ArrayList<GroupInfo> resultGroups = new ArrayList<GroupInfo>();
        int numberOfGroupsSearched = filterSpec.names.length;
        for (GroupInfo group : clusterGroups) {
            for (String name : filterSpec.names) {
                if (!group.name.equals(name)) continue;
                resultGroups.add(group);
                if (areGroupsUniqueByName.booleanValue() && --numberOfGroupsSearched == 0) break;
            }
            if (areGroupsUniqueByName.booleanValue() && numberOfGroupsSearched == 0) break;
        }
        GroupInfo[] result = resultGroups.toArray(new GroupInfo[resultGroups.size()]);
        return result;
    }

    private void updateHostAvailabilityState(HostHaRuntimeInfo hostInfo, HostHaObject host) throws Exception {
        if (hostInfo == null) {
            _logger.error((Object)"hostInfo is null.");
            return;
        }
        if (host.getDasState() == null) {
            _logger.error((Object)"dasState is null.");
            return;
        }
        DasFdmAvailabilityState availabilityState = host.getHaState();
        if (availabilityState == DasFdmAvailabilityState.master) {
            hostInfo.masterName = (String)host.get("name");
        } else if (availabilityState == DasFdmAvailabilityState.connectedToMaster) {
            ++hostInfo.hostsConnectedCount;
        } else if (availabilityState == DasFdmAvailabilityState.networkPartitionedFromMaster) {
            ++hostInfo.networkPartitionedCount;
        } else if (availabilityState == DasFdmAvailabilityState.networkIsolated) {
            ++hostInfo.networkIsolatedCount;
        } else if (availabilityState == DasFdmAvailabilityState.fdmUnreachable) {
            ++hostInfo.agentUnreachableCount;
        } else if (availabilityState == DasFdmAvailabilityState.hostDown) {
            ++hostInfo.hostsUnreachableCount;
        } else if (availabilityState == DasFdmAvailabilityState.initializationError) {
            ++hostInfo.configErrorCount;
        } else if (availabilityState == DasFdmAvailabilityState.election || availabilityState == DasFdmAvailabilityState.uninitialized) {
            ++hostInfo.agentInitializingCount;
        }
    }

    private void updateDisconnectedFromVcCount(HostHaRuntimeInfo hostInfo, HostHaObject host) {
        if (hostInfo == null) {
            _logger.error((Object)"hostInfo is null.");
            return;
        }
        if (host.getConnectionState() == null) {
            _logger.error((Object)"connectionState is null.");
            return;
        }
        if (host.getConnectionState() == HostSystem.ConnectionState.disconnected) {
            ++hostInfo.hostsDisconnectedFromVcCount;
            if (host.getHaState() == DasFdmAvailabilityState.uninitializationError) {
                ++hostInfo.hostsDisconnectedWithUninitError;
            }
        }
    }

    private void updateStandbyModeCount(HostHaRuntimeInfo hostInfo, HostHaObject host) {
        if (hostInfo == null) {
            _logger.error((Object)"hostInfo is null.");
            return;
        }
        if (host.getStandbyMode() == null) {
            _logger.error((Object)"standbyMode is null.");
            return;
        }
        if (host.getStandbyMode() == HostSystem.StandbyMode.in) {
            ++hostInfo.hostsInStandByCount;
            if (host.getHaState() == DasFdmAvailabilityState.uninitializationError) {
                ++hostInfo.hostsInStandByWithUninitError;
            }
        }
    }

    private void updateInMaintenanceModeCount(HostHaRuntimeInfo hostInfo, HostHaObject host) {
        if (hostInfo == null) {
            _logger.error((Object)"hostInfo is null.");
            return;
        }
        if (host.isInMaitenanceMode() == null) {
            _logger.error((Object)"maintenanceMode is null.");
            return;
        }
        if (host.isInMaitenanceMode().booleanValue()) {
            ++hostInfo.hostsInMaitenanceModeCount;
            if (host.getHaState() == DasFdmAvailabilityState.uninitializationError) {
                ++hostInfo.hostsInMaintenanceWithUninitError;
            }
        }
    }

    private void udpateHostsNotConnectedCount(HostHaRuntimeInfo hostInfo, int numOfHostsInCluster) {
        if (numOfHostsInCluster > 0) {
            hostInfo.hostsNotConnectedCount = numOfHostsInCluster - (hostInfo.hostsConnectedCount + 1);
        }
    }

    private void updateVmDasCount(VmHaRuntimeInfo vmInfo, RuntimeInfo.DasProtectionState protectionState) throws Exception {
        if (vmInfo == null) {
            _logger.error((Object)"vmInfo is null.");
            return;
        }
        if (protectionState == null) {
            _logger.error((Object)"protectionState is null.");
            return;
        }
        if (protectionState.isDasProtected()) {
            ++vmInfo.protectedVmsCount;
        } else {
            ++vmInfo.notProtectedVmCount;
        }
    }

    private static List<HaConfigIssue> getConfigIssuesForEntity(ManagedObjectReference entity, PropertyValue[] properties) {
        String name = null;
        String hostState = null;
        Event[] issues = null;
        for (PropertyValue property : properties) {
            if (property.propertyName.equals("name")) {
                name = (String)property.value;
            }
            if (property.propertyName.equals("summary.runtime.dasHostState")) {
                hostState = ((DasFdmHostState)property.value).state;
            }
            if (!property.propertyName.equals(CONFIG_ISSUE_PROPERTY)) continue;
            issues = (Event[])property.value;
        }
        int issueCount = issues == null ? 0 : issues.length;
        ArrayList<HaConfigIssue> configIssues = new ArrayList<HaConfigIssue>(issueCount);
        if (issueCount > 0) {
            VcService service = VimSessionUtil.getService((String)entity.getServerGuid());
            for (Event issue : issues) {
                HaConfigIssue haConfigIssue = new HaConfigIssue();
                haConfigIssue.entity = entity;
                haConfigIssue.entityName = name;
                haConfigIssue.issueCategory = EventUtil.getEventCategory(issue, service);
                haConfigIssue.issue = issue;
                if (hostState != null) {
                    DasFdmAvailabilityState hostFdmState = Enum.valueOf(DasFdmAvailabilityState.class, hostState);
                    haConfigIssue.hostRole = hostFdmState == DasFdmAvailabilityState.master ? HaConfigIssue.HostRole.master : HaConfigIssue.HostRole.slave;
                }
                configIssues.add(haConfigIssue);
            }
        }
        return configIssues;
    }

    private static List<HaConfigIssue> getConfigIssuesForHosts(PropertyValue[] properties) {
        HashMap propertiesPerHost = new HashMap();
        for (PropertyValue property : properties) {
            if (propertiesPerHost.get(property.resourceObject) == null) {
                propertiesPerHost.put((ManagedObjectReference)property.resourceObject, new ArrayList());
            }
            ((List)propertiesPerHost.get(property.resourceObject)).add(property);
        }
        ArrayList<HaConfigIssue> configIssues = new ArrayList<HaConfigIssue>();
        for (Map.Entry entry : propertiesPerHost.entrySet()) {
            List propertyList = (List)entry.getValue();
            configIssues.addAll(ClusterServicePropertyProvider.getConfigIssuesForEntity((ManagedObjectReference)entry.getKey(), propertyList.toArray(new PropertyValue[propertyList.size()])));
        }
        return configIssues;
    }

    @type(value="Folder,Datacenter")
    public String getNewUniqueClusterName(ManagedObjectReference context) {
        ArrayList<String> existingNames = this.getAllDsClusterNames(context);
        String defaultName = Util.getLocalizedString("cluster.defaultName");
        String newUniqueDsClusterName = StringUtil.getIndexedString(existingNames, (String)defaultName, (String)" ");
        return newUniqueDsClusterName;
    }

    private ArrayList<String> getAllDsClusterNames(ManagedObjectReference context) {
        ArrayList existingNames = null;
        String defaultName = Util.getLocalizedString("cluster.defaultName");
        try {
            existingNames = ObjectNamesRetriever.getNamesOfAllObjectsWithinDatacenter((DataService)this._dataService, (ManagedObjectReference)context, (String)CLUSTER_TYPE, (String)defaultName);
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        return existingNames;
    }
}

