/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.util;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    private static final Log _logger = LogFactory.getLog(Util.class);
    public static String CLUSTER_SERVICE_STRINGS = "clusterservice";
    public static String CLUSTER_RECONFIGURE_TASK_NAME = "ReconfigureComputeResource_Task";

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)CLUSTER_SERVICE_STRINGS, (String)key, (ClassLoader)Util.class.getClassLoader());
    }

    public static ServiceInstanceContent getServiceInstanceContent(ManagedObjectReference moRef) throws Exception {
        if (moRef == null) {
            _logger.error((Object)"Null moRef encountered.");
            return null;
        }
        VcService service = VimSessionUtil.getService((String)moRef.getServerGuid());
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        return service.getServiceInstanceContent();
    }

    public static <T extends DataModel> T getDataModel(Class<T> modelClass, ManagedObjectReference mor, DataFetchCommand dataFetchCommand) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{modelClass, mor, dataFetchCommand});
        Collection dataModels = dataFetchCommand.execute(modelClass, new Object[]{mor});
        for (DataModel model : dataModels) {
            if (!mor.equals(model.provider)) continue;
            return (T)model;
        }
        return null;
    }
}

