/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.create;

import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.cluster.GroupInfo;
import com.vmware.vim.binding.vim.host.CpuPackage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.cluster.groups.GroupsFilterByNameSpec;
import com.vmware.vsphere.client.cluster.impl.ClusterServicePropertyProvider;
import com.vmware.vsphere.client.cluster.rules.RuleConflictInfo;
import com.vmware.vsphere.client.cluster.rules.RuleInfoEx;
import com.vmware.vsphere.client.cluster.rules.RuleMemberInfo;
import com.vmware.vsphere.client.cluster.rules.impl.ClusterRuleSpecValidator;
import com.vmware.vsphere.client.clusterui.model.create.CreateClusterConfig;
import com.vmware.vsphere.client.clusterui.model.create.EvcData;
import com.vmware.vsphere.client.clusterui.util.Util;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterPropertyProvider
implements PropertyProviderBean {
    private static final String NEW_UNIQUE_CLUSTER_NAME = "newUniqueClusterName";
    private static final Log _logger = LogFactory.getLog(ClusterPropertyProvider.class);
    private QueryExecutor _queryExecutor;
    private DataService _dataService;

    public ClusterPropertyProvider(DataService dataService, QueryExecutor queryExecutor) {
        this._dataService = dataService;
        this._queryExecutor = queryExecutor;
    }

    @type(value="Folder,Datacenter")
    public CreateClusterConfig getCreateClusterConfig(ManagedObjectReference mor) {
        CreateClusterConfig config = new CreateClusterConfig();
        config.uniqueName = this.getClusterUniqueName(mor);
        config.evcModes = this.getEvcModes(mor);
        return config;
    }

    @type(value="ClusterComputeResource")
    @PropertyProvider(value="ClusterComputeResource/rulesData")
    public RuleInfoEx[] getRulesData(ManagedObjectReference clusterRef) throws Exception {
        RuleInfoEx[] rules;
        ClusterRuleSpecValidator validator = new ClusterRuleSpecValidator(this._dataService, clusterRef, null);
        for (RuleInfoEx ruleInfoEx : rules = validator.getConflictsForExistingRules()) {
            ruleInfoEx.conflictingRules = ClusterPropertyProvider.copyRuleInfoExArray(ruleInfoEx.conflictingRules);
            ruleInfoEx.members = ClusterPropertyProvider.copyRuleMemberInfoArrayWithConflicts(ruleInfoEx.members);
        }
        return rules;
    }

    @type(value="ClusterComputeResource")
    @PropertyProvider(value="ClusterComputeResource/ruleGroupsData")
    public GroupInfo[] getRuleGroupsData(ManagedObjectReference clusterRef, GroupsFilterByNameSpec filterSpec) throws Exception {
        ClusterServicePropertyProvider clusterServicePropertyProvider = new ClusterServicePropertyProvider(this._dataService);
        return clusterServicePropertyProvider.getClusterGroups(clusterRef, filterSpec);
    }

    private static ArrayList<RuleMemberInfo> copyRuleMemberInfoArrayWithConflicts(ArrayList<RuleMemberInfo> ruleMembers) {
        ArrayList<RuleMemberInfo> ruleMembersCopy = new ArrayList<RuleMemberInfo>();
        for (RuleMemberInfo ruleMember : ruleMembers) {
            RuleMemberInfo copyOfRuleMember = RuleMemberInfo.createInstance(ruleMember.entity);
            copyOfRuleMember.rules = ClusterPropertyProvider.copyRuleInfoExArray(ruleMember.rules);
            copyOfRuleMember.conflicts = ClusterPropertyProvider.copyRuleConflictInfoArray(ruleMember.conflicts);
            ruleMembersCopy.add(copyOfRuleMember);
        }
        return ruleMembersCopy;
    }

    private static ArrayList<RuleInfoEx> copyRuleInfoExArray(ArrayList<RuleInfoEx> rules) {
        ArrayList<RuleInfoEx> rulesCopy = new ArrayList<RuleInfoEx>();
        for (RuleInfoEx ruleInfoEx : rules) {
            rulesCopy.add(RuleInfoEx.createFromRuleInfo(ruleInfoEx.rule));
        }
        return rulesCopy;
    }

    private static ArrayList<RuleConflictInfo> copyRuleConflictInfoArray(ArrayList<RuleConflictInfo> ruleConflicts) {
        ArrayList<RuleConflictInfo> ruleConflictsCopy = new ArrayList<RuleConflictInfo>();
        for (RuleConflictInfo ruleConflict : ruleConflicts) {
            RuleConflictInfo ruleConflictCopy = RuleConflictInfo.createInstance(ruleConflict.conflictType);
            ruleConflictCopy.rule1 = RuleInfoEx.createFromRuleInfo(ruleConflict.rule1.rule);
            ruleConflictCopy.rule2 = RuleInfoEx.createFromRuleInfo(ruleConflict.rule2.rule);
            ruleConflictCopy.members = ClusterPropertyProvider.copyRuleMemberInfoArray(ruleConflict.members);
            ruleConflictsCopy.add(ruleConflictCopy);
        }
        return ruleConflictsCopy;
    }

    private static RuleMemberInfo[] copyRuleMemberInfoArray(RuleMemberInfo[] ruleMembers) {
        ArrayList<RuleMemberInfo> ruleMembersCopy = new ArrayList<RuleMemberInfo>();
        for (RuleMemberInfo ruleMember : ruleMembers) {
            ruleMembersCopy.add(RuleMemberInfo.createInstance(ruleMember.entity));
        }
        return ruleMembersCopy.toArray(new RuleMemberInfo[ruleMembersCopy.size()]);
    }

    private String getClusterUniqueName(ManagedObjectReference mor) {
        try {
            return (String)this._queryExecutor.getProperty((Object)mor, NEW_UNIQUE_CLUSTER_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)"Can't return cluster unique name.", (Throwable)e);
            return "";
        }
    }

    private EVCMode[] getSupportedEvcModes(ManagedObjectReference mor) {
        VcService service = VimSessionUtil.getService((String)mor.getServerGuid());
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        ServiceInstance si = service.getServiceInstance();
        if (si == null) {
            _logger.error((Object)"Could not retrieve service instance");
            return null;
        }
        Capability caps = si.getCapability();
        if (caps == null) {
            _logger.error((Object)"Could not retrieve instance caps");
            return null;
        }
        return caps.supportedEVCMode;
    }

    private EvcData[] getEvcModes(ManagedObjectReference mor) {
        ArrayList<EvcData> amdEvcData = new ArrayList<EvcData>();
        ArrayList<EvcData> intelEvcData = new ArrayList<EvcData>();
        Object[] evcModes = this.getSupportedEvcModes(mor);
        if (ArrayUtil.isNullOrEmpty((Object[])evcModes)) {
            return new EvcData[0];
        }
        for (Object mode : evcModes) {
            EvcData evcData = this.createEvcData((EVCMode)mode);
            if (CpuPackage.Vendor.amd.toString().equals(((EVCMode)mode).vendor)) {
                amdEvcData.add(evcData);
                continue;
            }
            if (!CpuPackage.Vendor.intel.toString().equals(((EVCMode)mode).vendor)) continue;
            intelEvcData.add(evcData);
        }
        ArrayList<EvcData> result = new ArrayList<EvcData>();
        result.addAll(amdEvcData);
        result.addAll(intelEvcData);
        return result.toArray(new EvcData[result.size()]);
    }

    private EvcData createEvcData(EVCMode mode) {
        EvcData data2 = new EvcData();
        data2.key = mode.key;
        data2.description = mode.summary;
        data2.label = mode.label;
        if (CpuPackage.Vendor.amd.toString().equals(mode.vendor)) {
            data2.category = Util.getLocalizedString("evc.config.enableEvcAmdLabel", new String[0]);
        } else if (CpuPackage.Vendor.intel.toString().equals(mode.vendor)) {
            data2.category = Util.getLocalizedString("evc.config.enableEvcIntelLabel", new String[0]);
        }
        return data2;
    }
}

