/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.ha;

import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.cluster.DasVmSettings;
import com.vmware.vim.binding.vim.cluster.VmComponentProtectionSettings;
import com.vmware.vsphere.client.clusterui.ha.Constants;
import com.vmware.vsphere.client.clusterui.model.services.FailureConditionItem;
import com.vmware.vsphere.client.clusterui.util.Util;

public class FailureConditionItemFactory {
    public static FailureConditionItem createHostFailureItem(boolean haEnabled, String hostMonitoring, DasVmSettings.RestartPriority vmRestartPriority) {
        if (!haEnabled) {
            FailureConditionItem item = FailureConditionItemFactory.createItemForHaDisabled("ha.config.hostFailure");
            return item;
        }
        FailureConditionItem item = DasConfigInfo.ServiceState.disabled.toString().equals(hostMonitoring) ? FailureConditionItemFactory.createHostFailureItemForDisabledMonitoring("ha.config.hostFailure") : FailureConditionItemFactory.createHostFailureItemForEnabledMonitoring(vmRestartPriority);
        return item;
    }

    public static FailureConditionItem createGuestNotHeartbeatingItem(boolean haEnabled, String vmMonitoring) {
        if (!haEnabled) {
            FailureConditionItem item = FailureConditionItemFactory.createItemForHaDisabled("ha.config.guestNotHeartbeating");
            return item;
        }
        FailureConditionItem item = new FailureConditionItem();
        item.failure = Util.getLocalizedString("ha.config.guestNotHeartbeating", new String[0]);
        DasConfigInfo.VmMonitoringState vmMonitoringState = DasConfigInfo.VmMonitoringState.valueOf((String)vmMonitoring);
        switch (vmMonitoringState) {
            case vmMonitoringDisabled: {
                item.failureResponse = Util.getLocalizedString("ha.config.ignoreGuestHeartbeatsFailureResponse", new String[0]);
                item.details = Util.getLocalizedString("ha.config.ignoreGuestHeartbeatsDetails", new String[0]);
                item.failureResponseType = "responseDisabled";
                break;
            }
            case vmMonitoringOnly: {
                item.failureResponse = Util.getLocalizedString("ha.config.resetFailureResponse", new String[0]);
                item.details = Util.getLocalizedString("ha.config.vmMonitoringDetails", new String[0]);
                item.failureResponseType = "responseProtected";
                break;
            }
            case vmAndAppMonitoring: {
                item.failureResponse = Util.getLocalizedString("ha.config.resetFailureResponse", new String[0]);
                item.details = Util.getLocalizedString("ha.config.vmAndAppMonitoringDetails", new String[0]);
                item.failureResponseType = "responseProtected";
            }
        }
        return item;
    }

    public static FailureConditionItem createHostIsolationResponseItem(boolean haEnabled, String hostMonitoring, DasVmSettings.IsolationResponse isolationResponse) {
        if (!haEnabled) {
            FailureConditionItem item = FailureConditionItemFactory.createItemForHaDisabled("ha.config.networkIsolation");
            return item;
        }
        if (DasConfigInfo.ServiceState.disabled.name().equals(hostMonitoring)) {
            FailureConditionItem item = FailureConditionItemFactory.createHostFailureItemForDisabledMonitoring("ha.config.networkIsolation");
            return item;
        }
        FailureConditionItem item = new FailureConditionItem();
        item.failure = Util.getLocalizedString("ha.config.networkIsolation", new String[0]);
        switch (isolationResponse) {
            case none: {
                item.failureResponse = Util.getLocalizedString("ha.config.leavePoweredOnIsolationResponse", new String[0]);
                item.details = Util.getLocalizedString("ha.config.leavePoweredOnIsolationResponseDetails", new String[0]);
                item.failureResponseType = "responseDisabled";
                break;
            }
            case powerOff: {
                item.failureResponse = Util.getLocalizedString("ha.config.powerOffAndRestartIsolationResponse", new String[0]);
                item.details = Util.getLocalizedString("ha.config.powerOffAndRestartIsolationResponseDetails", new String[0]);
                item.failureResponseType = "responseProtected";
                break;
            }
            case shutdown: {
                item.failureResponse = Util.getLocalizedString("ha.config.shutdownAndRestartIsolationResponse", new String[0]);
                item.details = Util.getLocalizedString("ha.config.shutdownAndRestartIsolationResponseDetails", new String[0]);
                item.failureResponseType = "responseProtected";
            }
        }
        return item;
    }

    public static FailureConditionItem createDsWithPermanentDeviceLossItem(boolean haEnabled, boolean hostMonitorEnabled, boolean vmRestartPriorityDisabled, boolean vmComponentProtectingEnabled, VmComponentProtectionSettings.StorageVmReaction pdlProtectionLevel) {
        FailureConditionItem item = FailureConditionItemFactory.createDsWithPdlOrApdItem(true, haEnabled, hostMonitorEnabled, vmRestartPriorityDisabled, vmComponentProtectingEnabled, pdlProtectionLevel);
        return item;
    }

    public static FailureConditionItem createDsWithAllPathsDownItem(boolean haEnabled, boolean hostMonitorEnabled, boolean vmRestartPriorityDisabled, boolean vmComponentProtectingEnabled, VmComponentProtectionSettings.StorageVmReaction apdProtectionLevel) {
        FailureConditionItem item = FailureConditionItemFactory.createDsWithPdlOrApdItem(false, haEnabled, hostMonitorEnabled, vmRestartPriorityDisabled, vmComponentProtectingEnabled, apdProtectionLevel);
        return item;
    }

    private static FailureConditionItem createHostFailureItemForDisabledMonitoring(String failureType) {
        FailureConditionItem item = new FailureConditionItem();
        item.failure = Util.getLocalizedString(failureType, new String[0]);
        item.failureResponseType = "responseDisabled";
        item.failureResponse = Util.getLocalizedString("ha.config.disabledFailureResponse", new String[0]);
        item.details = Util.getLocalizedString("ha.config.hostMonitoringDisabledDetails", new String[0]);
        return item;
    }

    private static FailureConditionItem createHostFailureItemForEnabledMonitoring(DasVmSettings.RestartPriority vmRestartPriority) {
        FailureConditionItem item = new FailureConditionItem();
        item.failure = Util.getLocalizedString("ha.config.hostFailure", new String[0]);
        if (DasVmSettings.RestartPriority.disabled.equals((Object)vmRestartPriority)) {
            item.failureResponseType = "responseDisabled";
            item.failureResponse = Util.getLocalizedString("ha.config.doNotRestartFailureResponse", new String[0]);
            item.details = Util.getLocalizedString("ha.config.restartPriorityDisabledDetails", new String[0]);
        } else if (!DasVmSettings.RestartPriority.clusterRestartPriority.equals((Object)vmRestartPriority)) {
            item.failureResponseType = "responseProtected";
            item.failureResponse = Util.getLocalizedString("ha.config.restartFailureResponse", new String[0]);
            item.details = Util.getLocalizedString("ha.config.restartPriorityEnabledDetails", new String[0]);
        }
        return item;
    }

    private static FailureConditionItem createItemForHaDisabled(String failureTextKey) {
        FailureConditionItem item = new FailureConditionItem();
        item.failure = Util.getLocalizedString(failureTextKey, new String[0]);
        item.failureResponseType = "responseDisabled";
        item.failureResponse = Util.getLocalizedString("ha.config.disabledFailureResponse", new String[0]);
        item.details = Util.getLocalizedString("ha.config.haDisabledDetails", new String[0]);
        return item;
    }

    private static FailureConditionItem createDsWithPdlOrApdItem(boolean isPdlItem, boolean haEnabled, boolean hostMonitorEnabled, boolean vmRestartPriorityDisabled, boolean vmComponentProtectingEnabled, VmComponentProtectionSettings.StorageVmReaction storageVmReaction) {
        FailureConditionItem item = new FailureConditionItem();
        String string = item.failure = isPdlItem ? Util.getLocalizedString(Constants.DATASTORE_UNDER_PDL, new String[0]) : Util.getLocalizedString("ha.config.datastoreUnderApd", new String[0]);
        if (!haEnabled) {
            item.failureResponseType = "responseDisabled";
            item.failureResponse = Util.getLocalizedString("ha.config.disabledFailureResponse", new String[0]);
            item.details = Util.getLocalizedString("ha.config.haDisabledDetails", new String[0]);
            return item;
        }
        if (!hostMonitorEnabled && vmRestartPriorityDisabled) {
            item.failureResponse = Util.getLocalizedString("ha.config.disabledFailureResponse", new String[0]);
            item.failureResponseType = "responseDisabled";
            item.details = Util.getLocalizedString("ha.config.hostMonitoringAndRestartPriorityDisabledDetails", new String[0]);
            return item;
        }
        if (!hostMonitorEnabled) {
            item.failureResponseType = "responseDisabled";
            item.failureResponse = Util.getLocalizedString("ha.config.disabledFailureResponse", new String[0]);
            item.details = Util.getLocalizedString("ha.config.hostMonitoringDisabledDetails", new String[0]);
            return item;
        }
        if (vmRestartPriorityDisabled) {
            item.failureResponse = Util.getLocalizedString("ha.config.disabledFailureResponse", new String[0]);
            item.failureResponseType = "responseDisabled";
            item.details = Util.getLocalizedString("ha.config.restartPriorityDisabledDetails", new String[0]);
            return item;
        }
        if (!vmComponentProtectingEnabled) {
            item.failureResponse = Util.getLocalizedString("ha.config.disabledFailureResponse", new String[0]);
            item.failureResponseType = "responseDisabled";
            item.details = Util.getLocalizedString("ha.config.storageProtectionDisabledDetails", new String[0]);
            return item;
        }
        switch (storageVmReaction) {
            case disabled: {
                item.failureResponse = Util.getLocalizedString("ha.config.disabledFailureResponse", new String[0]);
                item.failureResponseType = "responseDisabled";
                String detailsKey = isPdlItem ? Constants.STORAGE_PROTECTION_FOR_PDL_DISABLED_DETAILS : "ha.config.storageProtectionForApdDisabledDetails";
                item.details = Util.getLocalizedString(detailsKey, new String[0]);
                break;
            }
            case warning: {
                item.failureResponse = Util.getLocalizedString("ha.config.warningFailureResponse", new String[0]);
                item.failureResponseType = "responseWarnOnly";
                String detailsKey = isPdlItem ? Constants.STORAGE_PROTECTION_FOR_PDL_WARNING_DETAILS : "ha.config.storageProtectionWarningDetailsForApd";
                item.details = Util.getLocalizedString(detailsKey, new String[0]);
                break;
            }
            case restartConservative: {
                if (isPdlItem) {
                    throw new IllegalArgumentException("Datastore with Permanent Device Lost failure response cannot be conservative");
                }
                item.failureResponse = Util.getLocalizedString("ha.config.powerOffAndRestartFailureResponse", new String[0]);
                item.failureResponseType = "responseProtected";
                item.details = Util.getLocalizedString("ha.config.storageProtectionConservativeDetails", new String[0]);
                break;
            }
            case restartAggressive: {
                item.failureResponse = Util.getLocalizedString("ha.config.powerOffAndRestartFailureResponse", new String[0]);
                item.failureResponseType = "responseProtected";
                item.details = Util.getLocalizedString("ha.config.storageProtectionAggressiveDetails", new String[0]);
            }
        }
        return item;
    }
}

