/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.cluster.DpmHostConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.cluster.ClusterComputeResourceSpec;
import com.vmware.vsphere.client.clusterui.ClusterValidationResult;
import com.vmware.vsphere.client.clusterui.RefreshClusterRecommendationsSpec;
import com.vmware.vsphere.client.clusterui.model.services.DrsConfigWarningsData;
import com.vmware.vsphere.client.clusterui.model.services.HostOptionListItem;
import com.vmware.vsphere.client.clusterui.model.services.HostOptionsHostData;
import com.vmware.vsphere.client.clusterui.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ClusterMutationProvider
implements MutationProvider {
    private static final int MAX_CLUSTER_NAME_LENGTH = 80;
    private final DataService _dataService;
    private final QueryBindingServiceFactory _queryBindingServiceFactory;
    private static final java.util.Comparator<HostOptionListItem> HOST_OPTION_LIST_ITEM_COMPARATOR = new java.util.Comparator<HostOptionListItem>(){

        @Override
        public int compare(HostOptionListItem hostOption1, HostOptionListItem hostOption2) {
            return hostOption1.name.compareTo(hostOption2.name);
        }
    };

    public ClusterMutationProvider(DataService dataService, QueryBindingServiceFactory queryBindingServiceFactory) {
        this._dataService = dataService;
        this._queryBindingServiceFactory = queryBindingServiceFactory;
    }

    public ValidationResult validate(ManagedObjectReference context, ClusterComputeResourceSpec spec) {
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)context, (String)"ClusterComputeResource")) {
            ValidationUtil.notNull((Object)spec.parent);
            ValidationUtil.notNull((Object)spec.name);
        }
        ClusterValidationResult result = new ClusterValidationResult();
        if (spec.name != null) {
            spec.name = spec.name.trim();
            result = ClusterMutationProvider.validateClusterNameLength(spec.name);
            if (result.isValid) {
                result = this.validateClusterNameUniqueness(spec.parent, spec.name);
            }
            if (!result.isValid) {
                return ClusterMutationProvider.getValidationResult(result);
            }
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)context, (String)"ClusterComputeResource") && spec.configSpecEx != null && spec.configSpecEx.getDrsConfig() != null) {
            if (!spec.configSpecEx.getDrsConfig().getEnabled().booleanValue()) {
                DrsConfigWarningsData warningsData = this.getDrsWarningsData(context);
                result = ClusterMutationProvider.validateClusterDrsOffWithVApps(warningsData);
                if (!result.isValid) {
                    return ClusterMutationProvider.getValidationResult(result);
                }
                result = ClusterMutationProvider.validateClusterDrsOffWithResourcePools(warningsData);
                if (!result.isValid) {
                    return ClusterMutationProvider.getValidationResult(result);
                }
            } else if (spec.configSpecEx.getDpmConfig() != null && spec.configSpecEx.getDpmConfig().getEnabled().booleanValue()) {
                DrsConfigWarningsData warningsData = this.getDrsWarningsData(context);
                result = ClusterMutationProvider.validateClusterDpmOnWithVsan(warningsData);
                if (!result.isValid) {
                    return ClusterMutationProvider.getValidationResult(result);
                }
                result = ClusterMutationProvider.validateClusterDpmOnWithStandbyHosts(warningsData);
                if (!result.isValid) {
                    return ClusterMutationProvider.getValidationResult(result);
                }
            }
        }
        return ClusterMutationProvider.getValidationResult(result);
    }

    public OperationResult apply(ManagedObjectReference clusterRef, RefreshClusterRecommendationsSpec _) {
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        result.effect = OperationEffect.newDelayedEffect();
        result.effect.affectedEntites = new Object[]{clusterRef};
        try {
            ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
            cluster.refreshRecommendation();
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static ValidationResult getValidationResult(ClusterValidationResult result) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.result = result;
        return validationResult;
    }

    private static ClusterValidationResult validateClusterDrsOffWithVApps(DrsConfigWarningsData warningsData) {
        ClusterValidationResult validationResult = new ClusterValidationResult();
        int vAppsCount = warningsData.allVAppsCount;
        if (vAppsCount > 0) {
            validationResult.isValid = false;
            validationResult.invalidPropertyName = "drsConfig.enabled";
            validationResult.validationMessage = Util.getLocalizedString("drs.config.editDrs.drsTurningOff.vAppError", new String[0]);
        }
        return validationResult;
    }

    private static ClusterValidationResult validateClusterDpmOnWithVsan(DrsConfigWarningsData warningsData) {
        ClusterValidationResult validationResult = new ClusterValidationResult();
        boolean vsanEnabled = warningsData.vsanEnabled;
        if (vsanEnabled) {
            validationResult.isValid = false;
            validationResult.invalidPropertyName = "dpmConfig.enabled";
            validationResult.validationMessage = Util.getLocalizedString("drs.config.dpmValidationError", new String[0]);
        }
        return validationResult;
    }

    private static ClusterValidationResult validateClusterDrsOffWithResourcePools(DrsConfigWarningsData warningsData) {
        ClusterValidationResult validationResult = new ClusterValidationResult();
        int resourcePoolsCount = warningsData.allResourcePoolsCount;
        if (resourcePoolsCount > 1) {
            validationResult.isValid = false;
            validationResult.errorCode = ClusterValidationResult.ClusterValidationErrorTypes.DRS_OFF_WITH_RESOURCE_POOLS;
            validationResult.invalidPropertyName = "drsConfig.enabled";
            validationResult.validationMessage = Util.getLocalizedString("drs.config.editDrs.drsTurningOffResPoolsConfirmation", new String[0]);
        }
        return validationResult;
    }

    private static ClusterValidationResult validateClusterDpmOnWithStandbyHosts(DrsConfigWarningsData warningsData) {
        ClusterValidationResult validationResult = new ClusterValidationResult();
        if (warningsData.hostOptionsData.dpmEnabled.booleanValue()) {
            return validationResult;
        }
        HostOptionListItem[] clusterHosts = ClusterMutationProvider.getHostOptions(warningsData.hostOptionsData.hosts, warningsData.hostOptionsData.dpmHostConfig);
        ArrayList<String> invalidHostnames = new ArrayList<String>();
        for (HostOptionListItem clusterHost : clusterHosts) {
            if (clusterHost.standbyExitSuccessfull || !clusterHost.dpmEnabled) continue;
            invalidHostnames.add(clusterHost.name);
        }
        if (invalidHostnames.size() > 0) {
            validationResult.isValid = false;
            validationResult.errorCode = ClusterValidationResult.ClusterValidationErrorTypes.DPM_ON_WITH_HOSTS_STANDBY;
            validationResult.invalidPropertyName = "dpmConfig.enabled";
            validationResult.validationMessage = Util.getLocalizedString("drs.config.editDrs.dpmTurningOnHostStandbyConfirmation", new String[0]);
            validationResult.validationData = invalidHostnames.toArray();
        }
        return validationResult;
    }

    private DrsConfigWarningsData getDrsWarningsData(ManagedObjectReference clusterRef) {
        QueryBindingService queryService = this._queryBindingServiceFactory.getQueryBindingService();
        return (DrsConfigWarningsData)queryService.prepare(DrsConfigWarningsData.class).fetch((Object)clusterRef);
    }

    private ClusterValidationResult validateClusterNameUniqueness(ManagedObjectReference contextObject, String clusterName) {
        Constraint relatedClusters;
        ClusterValidationResult validationResult = new ClusterValidationResult();
        if (ManagedObjectUtil.isHostFolder((ManagedObjectReference)contextObject)) {
            ManagedObjectReference hostFolder = contextObject;
            relatedClusters = QueryUtil.createConstraintForRelationship((Object)hostFolder, (String)"cluster", (String)"ClusterComputeResource");
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)contextObject, (String)"Datacenter")) {
            ManagedObjectReference datacenter = contextObject;
            Constraint hostFolderOfTheDatacenter = QueryUtil.createConstraintForRelationship((Object)datacenter, (String)"hostFolder", (String)"Folder");
            relatedClusters = QueryUtil.createRelationalConstraint((String)"cluster", (Constraint)hostFolderOfTheDatacenter, (Boolean)true, (String)"ClusterComputeResource");
        } else {
            throw new IllegalArgumentException(contextObject.getType() + " is not a valid cluster create target.");
        }
        PropertyConstraint withSameName = QueryUtil.createPropertyConstraint((String)"ClusterComputeResource", (String)"name", (Comparator)Comparator.EQUALS, (Object)clusterName);
        CompositeConstraint relatedClustersWithSameName = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relatedClusters, withSameName}, (Conjoiner)Conjoiner.AND);
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = "check-cluster-name-uniqueness";
        querySpec.resourceSpec = QueryUtil.createEmptyResourceSpec();
        querySpec.resourceSpec.constraint = relatedClustersWithSameName;
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        if (response.resultSet[0].totalMatchedObjectCount > 0) {
            validationResult.isValid = false;
            validationResult.invalidPropertyName = "name";
            validationResult.validationMessage = Util.getLocalizedString("error.duplicateClusterName", new String[0]);
        }
        return validationResult;
    }

    private static ClusterValidationResult validateClusterNameLength(String name) {
        ClusterValidationResult result = new ClusterValidationResult();
        if (name.length() > 80) {
            result.isValid = false;
            result.invalidPropertyName = "name";
            result.validationMessage = Util.getLocalizedString("error.clusterNameTooLong", new String[0]);
        } else if (name.length() == 0) {
            result.isValid = false;
            result.invalidPropertyName = "name";
            result.validationMessage = Util.getLocalizedString("error.clusterNameEmpty", new String[0]);
        }
        return result;
    }

    private static HostOptionListItem[] getHostOptions(HostOptionsHostData[] hosts, DpmHostConfigInfo[] dpmHostConfig) {
        int hostsCount;
        int n = hostsCount = hosts != null ? hosts.length : 0;
        if (hostsCount == 0) {
            return new HostOptionListItem[0];
        }
        ArrayList<HostOptionListItem> result = new ArrayList<HostOptionListItem>();
        HashMap<Integer, DpmHostConfigInfo> dpmHostConfigInfoMap = new HashMap<Integer, DpmHostConfigInfo>();
        if (dpmHostConfig != null) {
            for (DpmHostConfigInfo dpmHostConfigInfo : dpmHostConfig) {
                dpmHostConfigInfoMap.put(dpmHostConfigInfo.getKey().hashCode(), dpmHostConfigInfo);
            }
        }
        for (HostOptionsHostData hostOptionsHostData : hosts) {
            HostOptionListItem item = new HostOptionListItem();
            item.name = hostOptionsHostData.name;
            item.standbyExitSuccessfull = hostOptionsHostData.lastExitSucceeded != null && hostOptionsHostData.lastExitSucceeded != false;
            DpmHostConfigInfo hostInfo = (DpmHostConfigInfo)dpmHostConfigInfoMap.get(hostOptionsHostData.provider.hashCode());
            item.dpmEnabled = hostInfo == null || hostInfo.getEnabled() != false;
            result.add(item);
        }
        Collections.sort(result, HOST_OPTION_LIST_ITEM_COMPARATOR);
        return result.toArray(new HostOptionListItem[0]);
    }
}

