/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.security.AuthorizationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;

public final class CreateResourcePoolPropertyProvider {
    private static final String PARENT_PROP = "parent";
    private static final String HOST_CONN_STATE_PROP = "runtime/connectionState";
    private static final String DISABLED_METHODS_PROP = "disabledOperations";
    private static final String[] CREATE_RP_PRIVILEGES = new String[]{"Resource.CreatePool"};
    private static final String[] CREATE_RP_METHOD_NAME = new String[]{"CreateResourcePool"};
    private static final String CLUSTER_TYPE = ClusterComputeResource.class.getSimpleName();
    private static final String COMPUTE_RESOURCE_TYPE = ComputeResource.class.getSimpleName();
    private static final String HOST_TYPE = HostSystem.class.getSimpleName();
    private static final String RP_TYPE = ResourcePool.class.getSimpleName();
    private final QueryService _queryService;

    public CreateResourcePoolPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="HostSystem/isCreateRpActionAvailable")
    public Collection<Boolean> isCreateRpActionAvailableHost(Collection<ManagedObjectReference> objects) {
        if (objects == null || objects.size() != 1) {
            throw new IllegalArgumentException("isCreateRpActionAvailable property can be computed only for single object!");
        }
        ManagedObjectReference object = (ManagedObjectReference)CollectionUtils.get(objects, (int)0);
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", HOST_CONN_STATE_PROP, PARENT_PROP}).from(new String[]{HOST_TYPE}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)object).fetch();
        ArrayList<Boolean> result = new ArrayList<Boolean>(1);
        result.add(Boolean.FALSE);
        if (resultSet.getItems().size() == 0) {
            return result;
        }
        ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(0);
        ManagedObjectReference parent = (ManagedObjectReference)resourceItem.get(PARENT_PROP);
        if (CLUSTER_TYPE.equals(parent.getType()) || !HostSystem.ConnectionState.connected.equals(resourceItem.get(HOST_CONN_STATE_PROP))) {
            return result;
        }
        return Collections.singleton(this.canCreateResourcePoolOnComputeResource(parent));
    }

    @PropertyProvider(value="ClusterComputeResource/isCreateRpActionAvailable")
    public Collection<Boolean> isCreateRpActionAvailableCluster(Collection<ManagedObjectReference> objects) {
        if (objects == null || objects.size() != 1) {
            throw new IllegalArgumentException("isCreateRpActionAvailable property can be computed only for single object!");
        }
        ManagedObjectReference cluster = (ManagedObjectReference)CollectionUtils.get(objects, (int)0);
        return Collections.singleton(this.canCreateResourcePoolOnComputeResource(cluster));
    }

    private boolean canCreateResourcePoolOnComputeResource(ManagedObjectReference parent) {
        assert (CLUSTER_TYPE.equals(parent.getType()) || COMPUTE_RESOURCE_TYPE.equals(parent.getType()));
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", "grantedPrivileges", DISABLED_METHODS_PROP}).from(new String[]{RP_TYPE}).where(PARENT_PROP, PropertyPredicate.ComparisonOperator.EQUAL, (Object)parent).fetch();
        if (resultSet.getItems().size() == 0) {
            return false;
        }
        ResourceItem ri = (ResourceItem)resultSet.getItems().get(0);
        String[] grantedPriv = (String[])ri.get("grantedPrivileges");
        String[] disabledMethods = (String[])ri.get(DISABLED_METHODS_PROP);
        return AuthorizationUtil.isPrivilegeGranted((String[])CREATE_RP_PRIVILEGES, (String[])grantedPriv) && AuthorizationUtil.isOperationAllowed((String[])CREATE_RP_METHOD_NAME, (String[])disabledMethods);
    }
}

