/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.cluster.ActionHistory;
import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.DrsFaultListItem;
import com.vmware.vsphere.client.clusterui.model.monitor.FaultVmTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.HostMonitorTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.HostNameData;
import com.vmware.vsphere.client.clusterui.model.monitor.IdentifiableModel;
import com.vmware.vsphere.client.clusterui.model.monitor.MonitorTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.RecommendationListItemData;
import com.vmware.vsphere.client.clusterui.model.monitor.VmMonitorTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.history.DrsActionHistoryListItem;
import com.vmware.vsphere.client.clusterui.util.DrsActionHistoryUtil;
import com.vmware.vsphere.client.clusterui.util.DrsFaultsUtil;
import com.vmware.vsphere.client.clusterui.util.DrsRecommendationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DrsMonitorPropertyProvider {
    public static final String PROPERTY_RECOMMENDATION = "recommendation";
    public static final String PROPERTY_FAULT = "drsFault";
    public static final String PROPERTY_ACTION_HISTORY = "actionHistory";
    public static final String FAULT_FIELD_HOST = "host";
    public static final String FAULT_METHOD_HOST = "getHost";
    private QueryService _queryService;
    private QueryBindingService _queryBindingService;
    private ObjectReferenceService _objectReferenceService;

    public DrsMonitorPropertyProvider(QueryServiceFactory queryServiceFactory, QueryBindingServiceFactory queryBindingServiceFactory, ObjectReferenceService objectReferenceService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._objectReferenceService = objectReferenceService;
    }

    @PropertyProvider(value="ClusterComputeResource/computedDrsRecommendations")
    public List<RecommendationListItemData[]> getComputedDrsRecommendations(Collection<ManagedObjectReference> objects) throws Exception {
        ArrayList<RecommendationListItemData[]> result = new ArrayList<RecommendationListItemData[]>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_RECOMMENDATION}).from(new String[]{"ClusterComputeResource"}).where(LogicalOperator.AND, this.buildIdentityFilter(objects)).fetch();
        for (ResourceItem resultItem : resultSet.getItems()) {
            Recommendation[] recommendations = (Recommendation[])resultItem.get(PROPERTY_RECOMMENDATION);
            result.add(this.getRecommendationListData(recommendations));
        }
        return result;
    }

    @PropertyProvider(value="ClusterComputeResource/computedDrsFaults")
    public List<DrsFaultListItem[]> getComputedDrsFaults(Collection<ManagedObjectReference> objects) throws Exception {
        ArrayList<DrsFaultListItem[]> result = new ArrayList<DrsFaultListItem[]>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_FAULT}).from(new String[]{"ClusterComputeResource"}).where(LogicalOperator.AND, this.buildIdentityFilter(objects)).fetch();
        for (ResourceItem resultItem : resultSet.getItems()) {
            DrsFaults[] faults = (DrsFaults[])resultItem.get(PROPERTY_FAULT);
            result.add(this.getFaultListData(faults));
        }
        return result;
    }

    @PropertyProvider(value="ClusterComputeResource/computedActionHistory")
    public List<DrsActionHistoryListItem[]> getComputedActionHistory(Collection<ManagedObjectReference> objects) {
        ArrayList<DrsActionHistoryListItem[]> result = new ArrayList<DrsActionHistoryListItem[]>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{PROPERTY_ACTION_HISTORY}).from(new String[]{"ClusterComputeResource"}).where(LogicalOperator.AND, this.buildIdentityFilter(objects)).fetch();
        for (ResourceItem resultItem : resultSet.getItems()) {
            ActionHistory[] actionHistory = (ActionHistory[])resultItem.get(PROPERTY_ACTION_HISTORY);
            result.add(this.getActionHistoryListData(actionHistory));
        }
        return result;
    }

    private List<PropertyPredicate> buildIdentityFilter(Collection<? extends Object> objects) {
        ArrayList<PropertyPredicate> filter = new ArrayList<PropertyPredicate>();
        filter.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects));
        return filter;
    }

    private RecommendationListItemData[] getRecommendationListData(Recommendation[] recommendations) throws Exception {
        List<Object> result = new ArrayList();
        Object[] objRefs = DrsRecommendationUtil.extractTargetsFromRecommendations(recommendations);
        if (!ArrayUtil.isNullOrEmpty((Object[])objRefs)) {
            Map<String, VmMonitorTargetData> vmPropsByRef = this.getObjectProperties((ManagedObjectReference[])objRefs, "VirtualMachine", VmMonitorTargetData.class);
            Map<String, HostMonitorTargetData> hostPropsByRef = this.getObjectProperties((ManagedObjectReference[])objRefs, "HostSystem", HostMonitorTargetData.class);
            HashMap<String, MonitorTargetData> objPropsByRef = new HashMap<String, MonitorTargetData>();
            objPropsByRef.putAll(vmPropsByRef);
            objPropsByRef.putAll(hostPropsByRef);
            Map<String, Recommendation> recDict = DrsRecommendationUtil.buildRecommendationsIndex(recommendations);
            Map<String, Set<String>> nodeParents = DrsRecommendationUtil.getRecommendationsDependencies(recommendations);
            List<List<String>> graphGroups = DrsRecommendationUtil.buildRecommendationsGroups(recDict, nodeParents);
            result = DrsRecommendationUtil.makeDataGridData(graphGroups, recDict, nodeParents, objPropsByRef, this._objectReferenceService);
        }
        return result.toArray(new RecommendationListItemData[result.size()]);
    }

    private DrsActionHistoryListItem[] getActionHistoryListData(ActionHistory[] actionHistory) {
        List<Object> result = new ArrayList();
        if (!ArrayUtil.isNullOrEmpty((Object[])actionHistory)) {
            HashMap<ActionHistory, List<ManagedObjectReference>> objectsPerHistoryItem = new HashMap<ActionHistory, List<ManagedObjectReference>>();
            HashSet<ManagedObjectReference> allRelatedObjects = new HashSet<ManagedObjectReference>();
            for (ActionHistory actionHistoryItem : actionHistory) {
                List<ManagedObjectReference> actionObjects = DrsActionHistoryUtil.collectTargetsFromActionHistory(actionHistoryItem);
                objectsPerHistoryItem.put(actionHistoryItem, actionObjects);
                allRelatedObjects.addAll(actionObjects);
            }
            Map<Object, MonitorTargetData> vmsData = this.getDrsTargetDataForObjects(allRelatedObjects, "VirtualMachine", VmMonitorTargetData.class);
            Map<Object, MonitorTargetData> hostsData = this.getDrsTargetDataForObjects(allRelatedObjects, "HostSystem", HostMonitorTargetData.class);
            HashMap<Object, MonitorTargetData> objectDataByRef = new HashMap<Object, MonitorTargetData>();
            objectDataByRef.putAll(vmsData);
            objectDataByRef.putAll(hostsData);
            result = DrsActionHistoryUtil.makeGridData(actionHistory, objectsPerHistoryItem, objectDataByRef);
        }
        return result.toArray(new DrsActionHistoryListItem[result.size()]);
    }

    private <T extends MonitorTargetData> Map<Object, MonitorTargetData> getDrsTargetDataForObjects(Collection<ManagedObjectReference> objects, String objectType, Class<T> modelClass) {
        HashMap<Object, MonitorTargetData> result = new HashMap<Object, MonitorTargetData>();
        List<ManagedObjectReference> homogeneousObjects = this.filterObjectsByType(objectType, objects.toArray(new ManagedObjectReference[objects.size()]));
        if (homogeneousObjects.size() > 0) {
            Collection objectModels = this._queryBindingService.prepare(modelClass).fetch(homogeneousObjects);
            for (MonitorTargetData model : objectModels) {
                result.put(model.getProvider(), model);
            }
        }
        return result;
    }

    private <T extends MonitorTargetData> Map<String, T> getObjectProperties(ManagedObjectReference[] objRefs, String objectType, Class<T> modelClass) {
        Map<Object, Object> objPropsByRef;
        List<ManagedObjectReference> homogeneousObjects = this.filterObjectsByType(objectType, objRefs);
        if (homogeneousObjects.size() > 0) {
            Collection resultSet = this._queryBindingService.prepare(modelClass).fetch(homogeneousObjects);
            objPropsByRef = this.getTargetMapByResultSet(resultSet);
        } else {
            objPropsByRef = new HashMap();
        }
        return objPropsByRef;
    }

    private List<ManagedObjectReference> filterObjectsByType(String resourceType, ManagedObjectReference[] objects) {
        ArrayList<ManagedObjectReference> filteredObjects = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference object : objects) {
            if (!object.getType().equals(resourceType)) continue;
            filteredObjects.add(object);
        }
        return filteredObjects;
    }

    private <T extends IdentifiableModel> Map<String, T> getTargetMapByResultSet(Collection<T> resultSet) {
        HashMap<String, IdentifiableModel> propertiesByObject = new HashMap<String, IdentifiableModel>();
        for (IdentifiableModel resultItem : resultSet) {
            Object objRef = resultItem.getProvider();
            String objUid = this._objectReferenceService.getUid(objRef);
            propertiesByObject.put(objUid, resultItem);
        }
        return propertiesByObject;
    }

    private DrsFaultListItem[] getFaultListData(DrsFaults[] drsFaultsArray) throws Exception {
        List<Object> drsFaultItems = new ArrayList();
        HashMap<String, ManagedObjectReference> hostsByVmRef = new HashMap<String, ManagedObjectReference>();
        if (!ArrayUtil.isNullOrEmpty((Object[])drsFaultsArray)) {
            Map<Object, Object> hostNamesByRef;
            Set<ManagedObjectReference> vmRefs = DrsFaultsUtil.getVmReferences(drsFaultsArray);
            Map<String, FaultVmTargetData> vmData = this.getVmProperties(vmRefs);
            HashSet<ManagedObjectReference> hostRefs = new HashSet<ManagedObjectReference>();
            for (Map.Entry<String, FaultVmTargetData> vmEntry : vmData.entrySet()) {
                hostsByVmRef.put(vmEntry.getKey(), vmEntry.getValue().host);
                hostRefs.add(vmEntry.getValue().host);
            }
            DrsFaultsUtil.collectDrsFaultHosts(drsFaultsArray, hostRefs);
            if (hostRefs.size() > 0) {
                Collection resultSet = this._queryBindingService.prepare(HostNameData.class).fetch(hostRefs);
                hostNamesByRef = this.getTargetMapByResultSet(resultSet);
            } else {
                hostNamesByRef = new HashMap();
            }
            drsFaultItems = DrsFaultsUtil.makeGridData(drsFaultsArray, hostsByVmRef, hostNamesByRef, this._objectReferenceService, vmData);
        }
        return drsFaultItems.toArray(new DrsFaultListItem[drsFaultItems.size()]);
    }

    private Map<String, FaultVmTargetData> getVmProperties(Set<ManagedObjectReference> vmRefs) {
        Map<String, FaultVmTargetData> vmProperties;
        if (vmRefs.size() > 0) {
            Collection resultSet = this._queryBindingService.prepare(FaultVmTargetData.class).fetch(vmRefs);
            vmProperties = this.getTargetMapByResultSet(resultSet);
        } else {
            vmProperties = new HashMap<String, FaultVmTargetData>();
        }
        return vmProperties;
    }
}

