/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="ResourcePool")
public class ResourcePoolSummaryData
extends IdentifiableQueryBinding {
    @Property(value="ResourcePool/config")
    public ResourceConfigSpec configSpec;
    @Property(value="ResourcePool/summary/quickStats/staticCpuEntitlement")
    public int cpuWorstCaseAllocation;
    @Property(value="ResourcePool/summary/quickStats/staticCpuEntitlement")
    public int memoryWorstCaseAllocation;

    public String getCpuReservationFormatted() {
        return this.geReservationFormatted(this.configSpec.cpuAllocation.reservation, this.configSpec.cpuAllocation.expandableReservation, true);
    }

    public String getMemoryReservationFormatted() {
        return this.geReservationFormatted(this.configSpec.memoryAllocation.reservation, this.configSpec.memoryAllocation.expandableReservation, false);
    }

    public String getCpuLimitFormatted() {
        long limit = this.configSpec.cpuAllocation.limit;
        if (limit == -1L) {
            return ResourcePoolSummaryData.getLocalizedString("unlimited.reservation");
        }
        return this.getCpuAmountLocalized(limit);
    }

    public String getMemoryLimitFormatted() {
        long limit = this.configSpec.memoryAllocation.limit;
        if (limit == -1L) {
            return ResourcePoolSummaryData.getLocalizedString("unlimited.reservation");
        }
        return this.getMemoryAmountLocalized(limit);
    }

    public String getCpuWorstCaseAllocationFormatted() {
        return this.getCpuAmountLocalized(Long.valueOf(this.cpuWorstCaseAllocation));
    }

    public String getMemoryWorstCaseAllocationFormatted() {
        return this.getMemoryAmountLocalized(Long.valueOf(this.memoryWorstCaseAllocation));
    }

    private String getCpuAmountLocalized(Long amount) {
        return FormatUtil.getFrequencyFormatted((Number)amount, (int)2, (long)FormatUtil.MHz, (long)FormatUtil.MHz, (boolean)true);
    }

    private String getMemoryAmountLocalized(Long amount) {
        return FormatUtil.getDataSizeFormatted((Number)amount, (int)2, (long)0x100000L, (long)0x100000L, (boolean)true);
    }

    private String geReservationFormatted(Long reservation, Boolean expandable, boolean isCpuReservation) {
        String expandableType = ResourcePoolSummaryData.getLocalizedString(expandable != false ? "expandable.limit" : "unexpandable.limit");
        if (reservation == 0L) {
            return expandableType;
        }
        String reservationVal = isCpuReservation ? this.getCpuAmountLocalized(reservation) : this.getMemoryAmountLocalized(reservation);
        return ResourcePoolSummaryData.getLocalizedString("expandable.reservation.format", expandableType, reservationVal);
    }

    private static String getLocalizedString(String key) {
        return Util.getLocalizedString(key, new String[0]);
    }

    private static String getLocalizedString(String key, String ... params) {
        return Util.getLocalizedString(key, params);
    }
}

