/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.vim.binding.vim.cluster.DasAdmissionControlPolicy;
import com.vmware.vim.binding.vim.cluster.DasAdvancedRuntimeInfo;
import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.cluster.VmComponentProtectionSettings;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vsphere.client.clusterui.model.services.FailureConditionData;

public abstract class ClusterBaseHaData
extends IdentifiableQueryBinding {
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/enabled")
    public boolean haEnabled;
    @NestedQueryBinding
    public FailureConditionData failureConditionData;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/isolationResponse")
    public String isolationResponse;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/restartPriority")
    public String restartPriority;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/hBDatastoreCandidatePolicy")
    public String heartbeatDatastoreCandidatePolicy;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy")
    public DasAdmissionControlPolicy admissionControlPolicy;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlEnabled")
    public boolean admissionControlEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy/cpuFailoverResourcesPercent")
    public int cpuFailoverPercent;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy/memoryFailoverResourcesPercent")
    public int memoryFailoverPercent;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy/failoverLevel")
    public int failoverHostNum;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy/failoverHosts/length")
    public int dedicatedHostNum;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/option")
    public OptionValue[] advancedOptions;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/hostMonitoring")
    public String hostMonitoring;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/vmMonitoring")
    public String vmMonitoring;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/vmComponentProtectionSettings/vmTerminateDelayForAPDSec")
    public int vmTerminateDelayForAPDSec;
    @Property(value="ClusterComputeResource/dasAdvancedRuntimeInfo")
    public transient DasAdvancedRuntimeInfo dasAdvancedRuntimeInfo;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/vmComponentProtecting")
    public transient String vmComponentProtecting;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/vmComponentProtectionSettings/vmStorageProtectionForPDL")
    public transient String vmStorageProtectionForPDL;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/vmComponentProtectionSettings/vmStorageProtectionForAPD")
    public transient String vmStorageProtectionForAPD;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/defaultVmSettings/vmComponentProtectionSettings/vmReactionOnAPDCleared")
    public transient String vmReactionOnAPDCleared;

    public boolean isStoragePDLSupported() {
        if (this.dasAdvancedRuntimeInfo != null && this.dasAdvancedRuntimeInfo.getVmcpSupported() != null) {
            return this.dasAdvancedRuntimeInfo.getVmcpSupported().isStoragePDLSupported();
        }
        return false;
    }

    public boolean isStorageAPDSupported() {
        if (this.dasAdvancedRuntimeInfo != null && this.dasAdvancedRuntimeInfo.getVmcpSupported() != null) {
            return this.dasAdvancedRuntimeInfo.getVmcpSupported().isStorageAPDSupported();
        }
        return false;
    }

    public boolean isVmcpEnabled() {
        return this.vmComponentProtecting != null && DasConfigInfo.ServiceState.valueOf((String)this.vmComponentProtecting).equals((Object)DasConfigInfo.ServiceState.enabled);
    }

    public VmComponentProtectionSettings.StorageVmReaction getPdlResponse() {
        if (!this.isVmcpEnabled() || this.vmStorageProtectionForPDL == null) {
            return VmComponentProtectionSettings.StorageVmReaction.disabled;
        }
        return VmComponentProtectionSettings.StorageVmReaction.valueOf((String)this.vmStorageProtectionForPDL);
    }

    public VmComponentProtectionSettings.StorageVmReaction getApdResponse() {
        if (!this.isVmcpEnabled() || this.vmStorageProtectionForAPD == null) {
            return VmComponentProtectionSettings.StorageVmReaction.disabled;
        }
        return VmComponentProtectionSettings.StorageVmReaction.valueOf((String)this.vmStorageProtectionForAPD);
    }

    public VmComponentProtectionSettings.VmReactionOnAPDCleared getVmReactionOnAPDCleared() {
        if (this.vmReactionOnAPDCleared.equals(VmComponentProtectionSettings.VmReactionOnAPDCleared.reset.name())) {
            return VmComponentProtectionSettings.VmReactionOnAPDCleared.reset;
        }
        return VmComponentProtectionSettings.VmReactionOnAPDCleared.none;
    }
}

