/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.cluster.DasVmSettings;
import com.vmware.vim.binding.vim.cluster.VmComponentProtectionSettings;
import com.vmware.vim.binding.vim.cluster.VmToolsMonitoringSettings;
import com.vmware.vim.binding.vim.vm.RuntimeInfo;
import com.vmware.vsphere.client.clusterui.model.services.FailureConditionData;
import com.vmware.vsphere.client.clusterui.model.services.FailureConditionItem;

@QueryBinding(value="VirtualMachine")
public class VmFailureResponsesData {
    @Property(value="VirtualMachine/runtime/dasVmProtection")
    public RuntimeInfo.DasProtectionState dasVmProtection;
    @NestedQueryBinding
    @Relationship(value={"VirtualMachine/cluster"})
    public transient FailureConditionData failureConditionData;
    @Property(value="VirtualMachine/dasVmSettings")
    public transient DasVmSettings vmSettings;

    public FailureConditionItem[] getMergedItems() {
        FailureConditionItem[] listFailureItems;
        if (this.failureConditionData != null) {
            DasVmSettings mergedSettings = this.mergeItems(this.failureConditionData.defaultVmSettings, this.vmSettings);
            listFailureItems = this.failureConditionData.buildFailureConditionItems(mergedSettings);
        } else {
            listFailureItems = new FailureConditionItem[]{};
        }
        return listFailureItems;
    }

    public DasVmSettings mergeItems(DasVmSettings clusterSettings, DasVmSettings vmSettings) {
        DasVmSettings mergedVmSettings = null;
        if (vmSettings != null && clusterSettings != null) {
            VmComponentProtectionSettings mergedVmComponentProtection;
            mergedVmSettings = new DasVmSettings();
            if (vmSettings.getRestartPriority() != null && !this.isClusterDefaultRestartPriority(vmSettings.getRestartPriority()).booleanValue()) {
                mergedVmSettings.setRestartPriority(vmSettings.getRestartPriority());
            } else if (clusterSettings.getRestartPriority() != null) {
                mergedVmSettings.setRestartPriority(clusterSettings.getRestartPriority());
            }
            if (vmSettings.getIsolationResponse() != null && !this.isClusterDefaultIsolationResponse(vmSettings.getIsolationResponse()).booleanValue()) {
                mergedVmSettings.setIsolationResponse(vmSettings.getIsolationResponse());
            } else if (clusterSettings.getIsolationResponse() != null) {
                mergedVmSettings.setIsolationResponse(clusterSettings.getIsolationResponse());
            }
            if (vmSettings.getVmToolsMonitoringSettings() != null && !this.isClusterDefaultVmToolsMonitoring(vmSettings.getVmToolsMonitoringSettings()).booleanValue()) {
                mergedVmSettings.setVmToolsMonitoringSettings(vmSettings.getVmToolsMonitoringSettings());
            } else if (clusterSettings.getVmToolsMonitoringSettings() != null) {
                mergedVmSettings.setVmToolsMonitoringSettings(clusterSettings.getVmToolsMonitoringSettings());
            }
            VmComponentProtectionSettings perVmComponentProtection = vmSettings.getVmComponentProtectionSettings();
            VmComponentProtectionSettings defaultVmComponentProtection = clusterSettings.getVmComponentProtectionSettings();
            if (perVmComponentProtection != null) {
                mergedVmComponentProtection = new VmComponentProtectionSettings();
                if (perVmComponentProtection.getVmStorageProtectionForPDL() != null && !this.isClusterDefaultStorageProtection(perVmComponentProtection.getVmStorageProtectionForPDL()).booleanValue()) {
                    mergedVmComponentProtection.setVmStorageProtectionForPDL(perVmComponentProtection.getVmStorageProtectionForPDL());
                } else if (defaultVmComponentProtection != null) {
                    mergedVmComponentProtection.setVmStorageProtectionForPDL(defaultVmComponentProtection.getVmStorageProtectionForPDL());
                }
                if (perVmComponentProtection.getVmStorageProtectionForAPD() != null && !this.isClusterDefaultStorageProtection(perVmComponentProtection.getVmStorageProtectionForAPD()).booleanValue()) {
                    mergedVmComponentProtection.setVmStorageProtectionForAPD(perVmComponentProtection.getVmStorageProtectionForAPD());
                } else if (defaultVmComponentProtection != null) {
                    mergedVmComponentProtection.setVmStorageProtectionForAPD(defaultVmComponentProtection.getVmStorageProtectionForAPD());
                }
            } else {
                mergedVmComponentProtection = defaultVmComponentProtection;
            }
            mergedVmSettings.setVmComponentProtectionSettings(mergedVmComponentProtection);
        } else if (vmSettings != null) {
            mergedVmSettings = vmSettings;
        } else if (clusterSettings != null) {
            mergedVmSettings = clusterSettings;
        }
        return mergedVmSettings;
    }

    private Boolean isClusterDefaultRestartPriority(String restartPriority) {
        if (restartPriority != null && DasVmSettings.RestartPriority.clusterRestartPriority.toString().equals(restartPriority)) {
            return true;
        }
        return false;
    }

    private Boolean isClusterDefaultIsolationResponse(String isolationResponse) {
        if (isolationResponse != null && DasVmSettings.IsolationResponse.clusterIsolationResponse.toString().equals(isolationResponse)) {
            return true;
        }
        return false;
    }

    private Boolean isClusterDefaultStorageProtection(String storageProtection) {
        if (storageProtection != null && VmComponentProtectionSettings.StorageVmReaction.clusterDefault.toString().equals(storageProtection)) {
            return true;
        }
        return false;
    }

    private Boolean isClusterDefaultVmToolsMonitoring(VmToolsMonitoringSettings monitoringSettings) {
        if (monitoringSettings != null && Boolean.TRUE.equals(monitoringSettings.getClusterSettings())) {
            return true;
        }
        return false;
    }
}

