/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.DrsFaultDetailItem;
import com.vmware.vsphere.client.clusterui.model.monitor.DrsFaultListItem;
import com.vmware.vsphere.client.clusterui.model.monitor.FaultVmTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.TargetNameData;
import com.vmware.vsphere.client.clusterui.model.monitor.drs.faults.PreventedRecommendation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DrsFaultsUtil {
    public static final String DRSFAULT_POWERONVM = "powerOnVm";
    public static final String DRSFAULT_INCREASECAP = "increaseCapacity";
    public static final String DRSFAULT_ENTERSTANDBY = "enterStandby";
    public static final String DRSFAULT_INSUFFICIENT_RESOURCES = "unreservedCapacity";
    public static final String HOST_POWER_ON_ICON_CLASS = "vx-icon-hostPowerOn";
    public static final String CLUSTER_EDIT_ICON_CLASS = "vx-icon-cluster-edit";
    public static final String HOST_ENTER_STANDBY_MODE_ICON_CLASS = "vx-icon-hostShutDown";

    private DrsFaultsUtil() {
    }

    public static Set<ManagedObjectReference> getVmReferences(DrsFaults[] drsFaultsArray) {
        HashSet<ManagedObjectReference> vmRefs = new HashSet<ManagedObjectReference>();
        for (DrsFaults drsFault : drsFaultsArray) {
            if (drsFault == null) continue;
            for (DrsFaults.FaultsByVm vmFault : drsFault.getFaultsByVm()) {
                ManagedObjectReference vmRef = vmFault.getVm();
                if (vmRef == null) continue;
                vmRefs.add(vmRef);
            }
        }
        return vmRefs;
    }

    public static void collectDrsFaultHosts(DrsFaults[] drsFaultsArray, Set<ManagedObjectReference> hostRefs) {
        for (DrsFaults fault : drsFaultsArray) {
            if (fault == null) continue;
            for (DrsFaults.FaultsByVm vmFault : fault.faultsByVm) {
                if (vmFault == null || vmFault.vm == null) continue;
                for (Exception exception : vmFault.fault) {
                    ManagedObjectReference hostRef = DrsFaultsUtil.getHostProperty(exception);
                    if (hostRef == null) continue;
                    hostRefs.add(hostRef);
                }
            }
        }
    }

    public static List<DrsFaultListItem> makeGridData(DrsFaults[] drsFaults, Map<String, ManagedObjectReference> hostsByVmRef, Map<String, ? extends TargetNameData> hostNamesByRef, ObjectReferenceService objectReferenceService, Map<String, FaultVmTargetData> vmData) {
        ArrayList<DrsFaultListItem> drsFaultItems = new ArrayList<DrsFaultListItem>();
        for (DrsFaults fault : drsFaults) {
            String hostId;
            String vmId;
            ManagedObjectReference hostObject;
            DrsFaults.FaultsByVm firstFault;
            if (fault == null) continue;
            DrsFaultListItem faultListItem = new DrsFaultListItem();
            List<DrsFaultDetailItem> drsFaultDetailItems = DrsFaultsUtil.buildFaultDetailsList(fault, hostNamesByRef, objectReferenceService, vmData);
            faultListItem.setReason(fault.getReason());
            faultListItem.setDetails(drsFaultDetailItems);
            if (fault.faultsByVm != null && fault.faultsByVm.length > 0 && (firstFault = fault.faultsByVm[0]) != null && firstFault.vm != null && (hostObject = hostsByVmRef.get(vmId = objectReferenceService.getUid((Object)firstFault.vm))) != null && hostNamesByRef.containsKey(hostId = objectReferenceService.getUid((Object)hostObject))) {
                TargetNameData host = hostNamesByRef.get(hostId);
                faultListItem.setTarget(host);
            }
            drsFaultItems.add(faultListItem);
        }
        return drsFaultItems;
    }

    private static <T extends TargetNameData> TargetNameData getTargetData(ManagedObjectReference mor, Map<String, T> list, ObjectReferenceService objectReferenceService) {
        String id = objectReferenceService.getUid((Object)mor);
        TargetNameData target = null;
        if (list.containsKey(id)) {
            target = (TargetNameData)list.get(id);
        }
        return target;
    }

    private static List<DrsFaultDetailItem> buildFaultDetailsList(DrsFaults fault, Map<String, ? extends TargetNameData> hostNamesByRef, ObjectReferenceService objectReferenceService, Map<String, FaultVmTargetData> vmData) {
        ArrayList<DrsFaultDetailItem> faultDetailItems = new ArrayList<DrsFaultDetailItem>();
        for (DrsFaults.FaultsByVm vmFault : fault.faultsByVm) {
            if (ArrayUtil.isNullOrEmpty((Object[])vmFault.fault)) continue;
            DrsFaultDetailItem faultDetailItem = new DrsFaultDetailItem();
            faultDetailItem.setFaultDetailMessage(vmFault.getFault()[0].getMessage());
            boolean includeVmTarget = false;
            PreventedRecommendation preventedRecommendation = new PreventedRecommendation();
            if (fault.getReason().equals(DRSFAULT_POWERONVM)) {
                includeVmTarget = true;
                preventedRecommendation = DrsFaultsUtil.buildPreventedRecommendationWithTargetHost(vmFault.getFault()[0], hostNamesByRef, objectReferenceService);
            } else if (fault.getReason().equals(DRSFAULT_INCREASECAP)) {
                preventedRecommendation = DrsFaultsUtil.buildPreventedRecommendation(vmFault.getFault()[0], hostNamesByRef, objectReferenceService);
                faultDetailItem.setPreventedRecommendationIcon(HOST_POWER_ON_ICON_CLASS);
            } else if (fault.getReason().equals(DRSFAULT_ENTERSTANDBY)) {
                preventedRecommendation = DrsFaultsUtil.buildPreventedRecommendationWithTargetHost(vmFault.getFault()[0], hostNamesByRef, objectReferenceService);
                faultDetailItem.setPreventedRecommendationIcon(HOST_ENTER_STANDBY_MODE_ICON_CLASS);
            } else if (fault.getReason().equals(DRSFAULT_INSUFFICIENT_RESOURCES)) {
                faultDetailItem.setPreventedRecommendationIcon(CLUSTER_EDIT_ICON_CLASS);
            } else {
                includeVmTarget = true;
                preventedRecommendation = DrsFaultsUtil.buildPreventedRecommendation(vmFault.getFault()[0], hostNamesByRef, objectReferenceService);
            }
            if (preventedRecommendation != null) {
                String vmId;
                if (includeVmTarget && (vmId = objectReferenceService.getUid((Object)vmFault.getVm())) != null) {
                    faultDetailItem.setPreventedRecommendationIcon(vmData.get((Object)vmId).primaryIconId);
                    TargetNameData target = DrsFaultsUtil.getTargetData(vmFault.getVm(), vmData, objectReferenceService);
                    if (target != null) {
                        preventedRecommendation.setTargetVm(target);
                    }
                }
                faultDetailItem.setPreventedRecommendation(preventedRecommendation);
            }
            faultDetailItems.add(faultDetailItem);
        }
        return faultDetailItems;
    }

    private static PreventedRecommendation buildPreventedRecommendation(Exception vmFault, Map<String, ? extends TargetNameData> hostNamesByRef, ObjectReferenceService objectReferenceService) {
        TargetNameData target;
        PreventedRecommendation preventedRecommendation = new PreventedRecommendation();
        ManagedObjectReference hostRef = DrsFaultsUtil.getHostProperty(vmFault);
        if (hostRef != null && (target = DrsFaultsUtil.getTargetData(hostRef, hostNamesByRef, objectReferenceService)) != null) {
            preventedRecommendation.setTargetHost(target);
        }
        return preventedRecommendation;
    }

    private static PreventedRecommendation buildPreventedRecommendationWithTargetHost(Exception vmFault, Map<String, ? extends TargetNameData> hostNamesByRef, ObjectReferenceService objectReferenceService) {
        TargetNameData target;
        PreventedRecommendation preventedRecommendation = new PreventedRecommendation();
        ManagedObjectReference hostRef = DrsFaultsUtil.getHostProperty(vmFault);
        if (hostRef != null && (target = DrsFaultsUtil.getTargetData(hostRef, hostNamesByRef, objectReferenceService)) != null) {
            preventedRecommendation.setTargetHost(target);
        }
        return preventedRecommendation;
    }

    private static ManagedObjectReference getHostProperty(Exception methodFault) {
        ManagedObjectReference hostRef = null;
        try {
            Class<?> exceptionClass = methodFault.getClass();
            Field hostField = exceptionClass.getField("host");
            if (hostField.get(exceptionClass) instanceof ManagedObjectReference) {
                hostRef = (ManagedObjectReference)hostField.get(exceptionClass);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException noSuchFieldEx) {
            try {
                Class<?> faultClass = methodFault.getClass();
                Method faultMethod = faultClass.getMethod("getHost", new Class[0]);
                hostRef = (ManagedObjectReference)faultMethod.invoke((Object)methodFault, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return hostRef;
    }
}

