/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.vim.binding.vim.cluster.Action;
import com.vmware.vim.binding.vim.cluster.HostInfraUpdateHaModeAction;
import com.vmware.vim.binding.vim.cluster.HostPowerAction;
import com.vmware.vim.binding.vim.cluster.InitialPlacementAction;
import com.vmware.vim.binding.vim.cluster.MigrationAction;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vim.storageDrs.HbrDiskMigrationAction;
import com.vmware.vim.binding.vim.storageDrs.StorageMigrationAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.clusterui.model.monitor.MonitorTargetData;
import com.vmware.vsphere.client.clusterui.model.monitor.RecommendationListItemData;
import com.vmware.vsphere.client.clusterui.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DrsRecommendationUtil {
    public static final int MAX_STAR_RATING = 5;
    public static final String HOST_POWER_ON_ICON = "vx-icon-hostPowerOn";
    public static final String HOST_POWER_OFF_ICON = "vx-icon-hostShutDown";
    public static final String HOST_ENTER_MAINTENANCE_ICON = "vx-icon-hostEnterMaintenanceMode";
    public static final String HOST_ENTER_QUARANTINE_ICON = "vx-icon-hostEnterQuarantine";
    public static final String HOST_EXIT_QUARANTINE_ICON = "vx-icon-hostExitQuarantine";
    public static final String VIRTUAL_MACHINE_ICON = "vsphere-icon-vm";

    public static ManagedObjectReference[] extractTargetsFromRecommendations(Recommendation[] recommendations) {
        if (ArrayUtil.isNullOrEmpty((Object[])recommendations)) {
            return null;
        }
        HashSet<ManagedObjectReference> objRefsSet = new HashSet<ManagedObjectReference>();
        for (Recommendation rec : recommendations) {
            for (Action action : rec.action) {
                ManagedObjectReference[] objRefs = DrsRecommendationUtil.extractTargetsFromAction(action);
                objRefsSet.addAll(new ArrayList<ManagedObjectReference>(Arrays.asList(objRefs)));
            }
        }
        return objRefsSet.toArray(new ManagedObjectReference[objRefsSet.size()]);
    }

    public static ManagedObjectReference[] extractTargetsFromAction(Action action) {
        ArrayList<ManagedObjectReference> targetObjectRefs = new ArrayList<ManagedObjectReference>();
        if (action instanceof HbrDiskMigrationAction) {
            HbrDiskMigrationAction hbrMigrationAction = (HbrDiskMigrationAction)action;
            targetObjectRefs.add(hbrMigrationAction.source);
            targetObjectRefs.add(hbrMigrationAction.destination);
        } else {
            targetObjectRefs.add(action.target);
            if (action instanceof InitialPlacementAction) {
                InitialPlacementAction initialPlacementAction = (InitialPlacementAction)action;
                targetObjectRefs.add(initialPlacementAction.targetHost);
            } else if (action instanceof MigrationAction) {
                MigrationAction migrationAction = (MigrationAction)action;
                targetObjectRefs.add(migrationAction.drsMigration.source);
                targetObjectRefs.add(migrationAction.drsMigration.destination);
            } else if (action instanceof StorageMigrationAction) {
                StorageMigrationAction storageMigAction = (StorageMigrationAction)action;
                targetObjectRefs.add(storageMigAction.source);
                targetObjectRefs.add(storageMigAction.destination);
            }
        }
        return targetObjectRefs.toArray(new ManagedObjectReference[targetObjectRefs.size()]);
    }

    public static Map<String, Recommendation> buildRecommendationsIndex(Recommendation[] recommendations) {
        HashMap<String, Recommendation> recDict = new HashMap<String, Recommendation>();
        if (!ArrayUtil.isNullOrEmpty((Object[])recommendations)) {
            for (Recommendation rec : recommendations) {
                recDict.put(rec.key, rec);
            }
        }
        return recDict;
    }

    public static Map<String, Set<String>> getRecommendationsDependencies(Recommendation[] allRecs) {
        HashMap<String, Set<String>> dependencyMap = new HashMap<String, Set<String>>();
        for (Recommendation rec : allRecs) {
            HashSet<String> parentList = new HashSet<String>();
            dependencyMap.put(rec.key, parentList);
            block1: for (Recommendation possibleParent : allRecs) {
                if (possibleParent.key.equals(rec.key) || ArrayUtil.isNullOrEmpty((Object[])possibleParent.prerequisite)) continue;
                for (String childKey : possibleParent.prerequisite) {
                    if (!childKey.equals(rec.key)) continue;
                    parentList.add(possibleParent.key);
                    continue block1;
                }
            }
        }
        return dependencyMap;
    }

    public static List<List<String>> buildRecommendationsGroups(Map<String, Recommendation> recDict, Map<String, Set<String>> parentRecs) {
        List<Set<String>> graphs = DrsRecommendationUtil.makeGraphs(recDict, parentRecs);
        ArrayList<List<String>> recGroups = new ArrayList<List<String>>();
        for (Set<String> set : graphs) {
            recGroups.add(DrsRecommendationUtil.linearizeGraph(set, recDict, parentRecs));
        }
        for (List list : recGroups) {
            Collections.sort(list, new RecommendationsComparator(recDict));
        }
        Collections.sort(recGroups, new GroupComparator(recDict));
        return recGroups;
    }

    public static List<RecommendationListItemData> makeDataGridData(List<List<String>> graphGroups, Map<String, Recommendation> recDict, Map<String, Set<String>> nodeParents, Map<String, MonitorTargetData> objPropsByRef, ObjectReferenceService objectReferenceService) {
        ArrayList<RecommendationListItemData> data2 = new ArrayList<RecommendationListItemData>();
        for (List<String> graph : graphGroups) {
            for (String recKey : graph) {
                Recommendation rec = recDict.get(recKey);
                int cnt = 0;
                for (Action action : rec.action) {
                    ManagedObjectReference[] targetObjects = DrsRecommendationUtil.extractTargetsFromAction(action);
                    String formatRecString = DrsRecommendationUtil.getRecommendationText(action);
                    MonitorTargetData[] recTargets = DrsRecommendationUtil.buildRecommendationTargets(targetObjects, objPropsByRef, objectReferenceService);
                    RecommendationListItemData listItem = DrsRecommendationUtil.createRecommendationListItemData(rec, action, objPropsByRef, objectReferenceService);
                    listItem.isFirst = cnt == 0;
                    listItem.recommendationText = formatRecString;
                    listItem.targetObjects = recTargets;
                    if (listItem.isFirst) {
                        if (rec.getPrerequisite() != null) {
                            HashSet<String> prerequisiteRecommendations = new HashSet<String>();
                            DrsRecommendationUtil.addSubGraph(recDict, rec.getPrerequisite(), prerequisiteRecommendations);
                            listItem.prerequisiteRecommendations = prerequisiteRecommendations.toArray(new String[0]);
                        }
                        Set<String> dependantRecommendations = DrsRecommendationUtil.getDependantRecommendations(nodeParents, recKey);
                        listItem.dependantRecommendations = dependantRecommendations.toArray(new String[0]);
                    }
                    data2.add(listItem);
                    ++cnt;
                }
            }
        }
        return data2;
    }

    private static Set<String> getDependantRecommendations(Map<String, Set<String>> nodeParents, String recKey) {
        HashSet<String> dependantRecommendations = new HashSet<String>();
        Set<String> recommendationParents = nodeParents.get(recKey);
        if (recommendationParents != null) {
            dependantRecommendations.addAll(recommendationParents);
            for (String parentKey : recommendationParents) {
                dependantRecommendations.addAll(DrsRecommendationUtil.getDependantRecommendations(nodeParents, parentKey));
            }
        }
        return dependantRecommendations;
    }

    private static MonitorTargetData[] buildRecommendationTargets(ManagedObjectReference[] targetObjects, Map<String, MonitorTargetData> objPropsByRef, ObjectReferenceService objectReferenceService) {
        int objectLength = targetObjects.length;
        MonitorTargetData[] recTargets = new MonitorTargetData[objectLength];
        for (int i = 0; i < objectLength; ++i) {
            MonitorTargetData recTarget;
            ManagedObjectReference objRef = targetObjects[i];
            recTargets[i] = recTarget = objPropsByRef.get(objectReferenceService.getUid((Object)objRef));
        }
        return recTargets;
    }

    private static RecommendationListItemData createRecommendationListItemData(Recommendation recommendation, Action action, Map<String, MonitorTargetData> objPropsByRef, ObjectReferenceService objectReferenceService) {
        RecommendationListItemData item = new RecommendationListItemData();
        item.parentRecommendation = recommendation;
        item.action = action;
        item.image = DrsRecommendationUtil.getRecommendationImage(action, objPropsByRef, objectReferenceService);
        int rating = 5 - recommendation.rating + 1;
        item.priorityRating = Integer.toString(rating);
        return item;
    }

    private static String getRecommendationImage(Action action, Map<String, MonitorTargetData> objPropsByRef, ObjectReferenceService objectReferenceService) {
        if (action instanceof HostPowerAction) {
            HostPowerAction hostPowerAction = (HostPowerAction)action;
            if (hostPowerAction.operationType == HostPowerAction.OperationType.powerOn) {
                return HOST_POWER_ON_ICON;
            }
            return HOST_POWER_OFF_ICON;
        }
        if (action instanceof MigrationAction) {
            MigrationAction migrationAction = (MigrationAction)action;
            String vmId = objectReferenceService.getUid((Object)migrationAction.drsMigration.vm);
            MonitorTargetData objectDetailsMigration = objPropsByRef.get(vmId);
            return objectDetailsMigration.getPrimaryIconId();
        }
        if (action instanceof InitialPlacementAction) {
            InitialPlacementAction initialPlacementAction = (InitialPlacementAction)action;
            String targetUid = objectReferenceService.getUid((Object)initialPlacementAction.target);
            MonitorTargetData objectDetailsPlacement = objPropsByRef.get(targetUid);
            return objectDetailsPlacement.getPrimaryIconId();
        }
        if (action instanceof HostInfraUpdateHaModeAction) {
            HostInfraUpdateHaModeAction infraUpdateHaAction = (HostInfraUpdateHaModeAction)action;
            String opType = infraUpdateHaAction.operationType;
            switch (HostInfraUpdateHaModeAction.OperationType.valueOf((String)opType)) {
                case enterMaintenance: {
                    return HOST_ENTER_MAINTENANCE_ICON;
                }
                case exitQuarantine: {
                    return HOST_EXIT_QUARANTINE_ICON;
                }
                case enterQuarantine: {
                    return HOST_ENTER_QUARANTINE_ICON;
                }
            }
        }
        return VIRTUAL_MACHINE_ICON;
    }

    private static List<String> linearizeGraph(Set<String> graph, Map<String, Recommendation> allRecs, Map<String, Set<String>> dependencyMap) {
        HashMap dependencyMapClone = new HashMap();
        for (Map.Entry<String, Set<String>> entry : dependencyMap.entrySet()) {
            dependencyMapClone.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> parentlessRecs = new ArrayList<String>();
        for (String key : graph) {
            if (((Set)dependencyMapClone.get(key)).size() != 0) continue;
            parentlessRecs.add(key);
        }
        while (parentlessRecs.size() > 0) {
            String rec = (String)parentlessRecs.get(0);
            parentlessRecs.remove(0);
            result.add(rec);
            if (ArrayUtil.isNullOrEmpty((Object[])allRecs.get((Object)rec).prerequisite)) continue;
            for (String child : allRecs.get((Object)rec).prerequisite) {
                if (!dependencyMapClone.containsKey(child)) continue;
                Set parentSet = (Set)dependencyMapClone.get(child);
                parentSet.remove(rec);
                if (parentSet.size() != 0) continue;
                parentlessRecs.add(child);
            }
        }
        return result;
    }

    private static List<Set<String>> makeGraphs(Map<String, Recommendation> allRecs, Map<String, Set<String>> dependencyMap) {
        ArrayList<Set<String>> graphList = new ArrayList<Set<String>>();
        for (Map.Entry<String, Set<String>> rec : dependencyMap.entrySet()) {
            Set<String> parentsSet = rec.getValue();
            if (parentsSet.size() != 0) continue;
            Set<String> subGraph = new HashSet<String>();
            subGraph.add(rec.getKey());
            DrsRecommendationUtil.addSubGraph(allRecs, allRecs.get((Object)rec.getKey()).prerequisite, subGraph);
            boolean intersectionFound = true;
            while (intersectionFound) {
                intersectionFound = false;
                block2: for (int curGraph = 0; !intersectionFound && curGraph < graphList.size(); ++curGraph) {
                    Set graph = (Set)graphList.get(curGraph);
                    for (String key : subGraph) {
                        if (!graph.contains(key)) continue;
                        graph.addAll(subGraph);
                        graphList.remove(curGraph);
                        subGraph = graph;
                        intersectionFound = true;
                        continue block2;
                    }
                }
            }
            graphList.add(subGraph);
        }
        return graphList;
    }

    private static void addSubGraph(Map<String, Recommendation> allRecs, String[] children, Set<String> subGraph) {
        if (!ArrayUtil.isNullOrEmpty((Object[])children)) {
            for (String recKey : children) {
                if (!allRecs.containsKey(recKey)) continue;
                subGraph.add(recKey);
                DrsRecommendationUtil.addSubGraph(allRecs, allRecs.get((Object)recKey).prerequisite, subGraph);
            }
        }
    }

    private static String getRecommendationText(Action action) {
        if (action instanceof InitialPlacementAction) {
            return Util.getLocalizedString("RecommendationListItemData.initialPlacement", new String[0]);
        }
        if (action instanceof HostPowerAction) {
            HostPowerAction hostPowerAction = (HostPowerAction)action;
            if (hostPowerAction.operationType.equals((Object)HostPowerAction.OperationType.powerOff)) {
                return Util.getLocalizedString("RecommendationListItemData.hostPowerOff", new String[0]);
            }
            return Util.getLocalizedString("RecommendationListItemData.hostPowerOn", new String[0]);
        }
        if (action instanceof MigrationAction) {
            return Util.getLocalizedString("RecommendationListItemData.migration", new String[0]);
        }
        if (action instanceof HostInfraUpdateHaModeAction) {
            String strOp;
            HostInfraUpdateHaModeAction infraUpdateHaAction = (HostInfraUpdateHaModeAction)action;
            String opType = infraUpdateHaAction.operationType;
            switch (HostInfraUpdateHaModeAction.OperationType.valueOf((String)opType)) {
                case enterMaintenance: {
                    strOp = Util.getLocalizedString("RecommendationListItemData.infraHaUpdate.enter.maintenance", new String[0]);
                    break;
                }
                case exitQuarantine: {
                    strOp = Util.getLocalizedString("RecommendationListItemData.infraHaUpdate.exit.quarantine", new String[0]);
                    break;
                }
                case enterQuarantine: {
                    strOp = Util.getLocalizedString("RecommendationListItemData.infraHaUpdate.enter.quarantine", new String[0]);
                    break;
                }
                default: {
                    strOp = "";
                }
            }
            return strOp;
        }
        return "";
    }

    private static class GroupComparator
    implements Comparator<List<String>> {
        private final Map<String, Recommendation> recDict;

        public GroupComparator(Map<String, Recommendation> recDict) {
            this.recDict = recDict;
        }

        @Override
        public int compare(List<String> o1, List<String> o2) {
            Recommendation rec1 = this.recDict.get(o1.get(0));
            Recommendation rec2 = this.recDict.get(o2.get(0));
            return rec2.getRating() - rec1.getRating();
        }
    }

    private static class RecommendationsComparator
    implements Comparator<String> {
        private final Map<String, Recommendation> recDict;

        public RecommendationsComparator(Map<String, Recommendation> recDict) {
            this.recDict = recDict;
        }

        @Override
        public int compare(String o1, String o2) {
            Recommendation rec1 = this.recDict.get(o1);
            Recommendation rec2 = this.recDict.get(o2);
            return rec2.getRating() - rec1.getRating();
        }
    }
}

