/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.common;

import com.vmware.vim.vmomi.client.Client;
import com.vmware.vsphere.client.vcextension.common.VmomiClientFactory;
import org.apache.commons.lang.Validate;

public abstract class VcExtensionConnection {
    private final Client _client;
    private boolean _isClosed;

    public VcExtensionConnection(VmomiClientFactory.ClientSpec clientSpec) throws Exception {
        Validate.notNull((Object)clientSpec);
        this._client = VmomiClientFactory.getInstance().newClient(clientSpec);
    }

    public void close() {
        if (!this._isClosed) {
            this._client.shutdown();
            this._isClosed = true;
        }
    }

    public static void tryClose(VcExtensionConnection connection) {
        if (connection != null) {
            connection.close();
        }
    }

    protected Client getClient() {
        assert (this._client != null);
        if (this._isClosed) {
            throw new IllegalStateException("Connection has been closed");
        }
        return this._client;
    }
}

