/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile;

import com.vmware.vim.binding.vim.PasswordField;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.hostprofile.data.ExecuteResultWrapper;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostProfileUtils {
    private static final Log _logger = LogFactory.getLog(HostProfileUtils.class);
    private static final String RESOURCE_BUNDLE_NAME = "HostProfileService";
    private static final String ERROR_INVALID_VC = "error.invalidVc";
    private static final String ERROR_INVALID_VC_SERVICES = "error.invalidVcServices";
    public static final Version VERSION_5_1_0 = new Version("5.1.0");
    public static final Version VERSION_6_1_0 = new Version("6.1.0");
    public static final String PASSWORD_TYPE = "password";

    public static ProfileManager getProfileManager(String serverGuid) throws Exception {
        VcService vcService = HostProfileUtils.getVcService(serverGuid);
        ServiceInstanceContent serviceContent = vcService.getServiceInstanceContent();
        if (serviceContent == null) {
            _logger.error((Object)"Could not retrieve ServiceInstanceContent");
            throw new RuntimeException(HostProfileUtils.getLocalizedString(ERROR_INVALID_VC_SERVICES));
        }
        ProfileManager profileManager = (ProfileManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getHostProfileManager());
        return profileManager;
    }

    public static ComplianceManager getComplianceManager(String serverGuid) throws Exception {
        VcService vcService = HostProfileUtils.getVcService(serverGuid);
        ServiceInstanceContent serviceContent = vcService.getServiceInstanceContent();
        if (serviceContent == null) {
            _logger.error((Object)"Could not retrieve ServiceInstanceContent");
            throw new RuntimeException(HostProfileUtils.getLocalizedString(ERROR_INVALID_VC_SERVICES));
        }
        ComplianceManager complianceManager = (ComplianceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getComplianceManager());
        return complianceManager;
    }

    public static VcService getVcService(ManagedObjectReference reference) {
        return HostProfileUtils.getVcService(reference.getServerGuid(), null);
    }

    public static VcService getVcService(String serverGuid) {
        return HostProfileUtils.getVcService(serverGuid, null);
    }

    public static VcService getVcService(String serverGuid, HttpSession session) {
        VcService service = VimSessionUtil.getService((String)serverGuid, (HttpSession)session);
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            throw new RuntimeException(HostProfileUtils.getLocalizedString(ERROR_INVALID_VC));
        }
        return service;
    }

    public static String getResourceFWType(String clazz, Object value) {
        if (value instanceof PasswordField) {
            return PASSWORD_TYPE;
        }
        if (String.class.getName().equals(clazz)) {
            return "string";
        }
        if (Integer.class.getName().equals(clazz)) {
            return "int";
        }
        if (Boolean.class.getName().equals(clazz)) {
            return "boolean";
        }
        if (Long.class.getName().equals(clazz)) {
            return "long";
        }
        if (Float.class.getName().equals(clazz)) {
            return "float";
        }
        _logger.warn((Object)("Unknown resource type: " + clazz));
        return "string";
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)HostProfileUtils.class.getClassLoader());
    }

    public static String getLocalizedString(String key, String ... params) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (String[])params, (ClassLoader)HostProfileUtils.class.getClassLoader());
    }

    public static String getLocalizedMessage(LocalizableMessage localizableMessage) {
        String localizedMessage = null;
        if (localizableMessage != null) {
            localizedMessage = LocalizationUtil.getLocalizedMessage((String)localizableMessage.getKey(), (KeyAnyValue[])localizableMessage.getArg());
            if (localizedMessage == null) {
                localizedMessage = localizableMessage.getMessage();
                _logger.warn((Object)String.format("No localization found for key: %s", localizableMessage.getKey()));
            }
        } else {
            localizedMessage = "";
        }
        return localizedMessage;
    }

    public static <T extends ParameterMetadata> T getLocalizedParameterMetadata(VcService service, T metadata) {
        String localizedSummary;
        String localizedLabel;
        metadata.id.label = localizedLabel = LocalizationUtil.getLocalizedMessage((String)(metadata.id.messageCatalogKeyPrefix + ".label"), (KeyAnyValue[])metadata.id.messageArg);
        metadata.id.summary = localizedSummary = LocalizationUtil.getLocalizedMessage((String)(metadata.id.messageCatalogKeyPrefix + ".summary"), (KeyAnyValue[])metadata.id.messageArg);
        return metadata;
    }

    public static <T extends PolicyMetadata> T getLocalizedPolicyMetadata(VcService service, T metadata) {
        String localizedSummary;
        String localizedLabel;
        metadata.id.label = localizedLabel = LocalizationUtil.getLocalizedMessage((String)(metadata.id.messageCatalogKeyPrefix + ".label"), (KeyAnyValue[])metadata.id.messageArg);
        metadata.id.summary = localizedSummary = LocalizationUtil.getLocalizedMessage((String)(metadata.id.messageCatalogKeyPrefix + ".summary"), (KeyAnyValue[])metadata.id.messageArg);
        return metadata;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean hasNonEmptyValue(KeyAnyValue kav) {
        if (kav == null || kav.getValue() == null) {
            return false;
        }
        return !(kav.getValue() instanceof String) || !HostProfileUtils.isNullOrEmpty((String)kav.getValue());
    }

    public static ProfileManager.HostProfileMetadata getHostProfileMetadata(ManagedObjectReference hostProfileRef, ProfileManager.MetadataTypes ... metadataTypes) throws Exception {
        if (hostProfileRef == null) {
            return null;
        }
        return HostProfileUtils.getHostProfilesMetadata(new ManagedObjectReference[]{hostProfileRef}, metadataTypes).get(hostProfileRef);
    }

    public static Map<ManagedObjectReference, ProfileManager.HostProfileMetadata> getHostProfilesMetadata(ManagedObjectReference[] hostProfilesRefs, ProfileManager.MetadataTypes ... metadataTypes) throws Exception {
        if (metadataTypes == null || metadataTypes.length == 0) {
            throw new RuntimeException("metadataTypes can't be empty!");
        }
        HashMap<ManagedObjectReference, ProfileManager.HostProfileMetadata> result = new HashMap<ManagedObjectReference, ProfileManager.HostProfileMetadata>();
        if (hostProfilesRefs == null || hostProfilesRefs.length == 0) {
            return result;
        }
        String[] metadataStringTypes = new String[metadataTypes.length];
        for (int i = 0; i < metadataTypes.length; ++i) {
            metadataStringTypes[i] = metadataTypes[i].name();
        }
        List<ProfileManager.MetadataTypes> metadataTypesList = Arrays.asList(metadataTypes);
        Map<String, Collection<ManagedObjectReference>> hostProfilesRefsByVc = HostProfileUtils.groupEntitiesByVc(Arrays.asList(hostProfilesRefs));
        for (String vcServerGuid : hostProfilesRefsByVc.keySet()) {
            ManagedObjectReference vcRef = ManagedObjectUtil.getRootFolder((String)vcServerGuid);
            ProfileManager profileManager = HostProfileUtils.getProfileManager(vcServerGuid);
            ManagedObjectReference[] vcHostProfilesRefs = hostProfilesRefsByVc.get(vcServerGuid).toArray(new ManagedObjectReference[0]);
            ProfileManager.HostProfileMetadata[] vcHostProfilesMeta = null;
            if (HostProfileUtils.isVc65OrLater(vcRef)) {
                try {
                    vcHostProfilesMeta = profileManager.queryMetadata(vcHostProfilesRefs, metadataStringTypes);
                    for (int i = 0; i < vcHostProfilesRefs.length; ++i) {
                        result.put(vcHostProfilesRefs[i], vcHostProfilesMeta[i]);
                    }
                }
                catch (Exception e) {
                    _logger.error((Object)"profileManager.queryMetadata(...) throws error: ", (Throwable)e);
                }
            }
            if (vcHostProfilesMeta != null) continue;
            HostProfileUtils.extractHostProfileMetaData(result, metadataTypesList, profileManager, vcHostProfilesRefs);
        }
        return result;
    }

    private static void extractHostProfileMetaData(Map<ManagedObjectReference, ProfileManager.HostProfileMetadata> result, List<ProfileManager.MetadataTypes> metadataTypesList, ProfileManager profileManager, ManagedObjectReference[] vcHostProfilesRefs) {
        for (int i = 0; i < vcHostProfilesRefs.length; ++i) {
            ManagedObjectReference vcHostProfileRef = vcHostProfilesRefs[i];
            ProfileManager.HostProfileMetadata vcHostProfileMetadata = new ProfileManager.HostProfileMetadata();
            if (metadataTypesList.contains(ProfileManager.MetadataTypes.profile)) {
                vcHostProfileMetadata.profileMetadata = profileManager.queryProfileMetadata(null, vcHostProfileRef);
            }
            if (metadataTypesList.contains(ProfileManager.MetadataTypes.policy)) {
                vcHostProfileMetadata.policyMetadata = profileManager.queryPolicyMetadata(null, vcHostProfileRef);
            }
            if (metadataTypesList.contains(ProfileManager.MetadataTypes.category)) {
                vcHostProfileMetadata.profileCategoryMetadata = profileManager.queryProfileCategoryMetadata(null, vcHostProfileRef);
            }
            if (metadataTypesList.contains(ProfileManager.MetadataTypes.component)) {
                vcHostProfileMetadata.profileComponentMetadata = profileManager.queryProfileComponentMetadata(null, vcHostProfileRef);
            }
            result.put(vcHostProfileRef, vcHostProfileMetadata);
        }
    }

    public static Map<String, Collection<ManagedObjectReference>> groupEntitiesByVc(Collection<ManagedObjectReference> entities) {
        LinkedHashMap<String, Collection<ManagedObjectReference>> result = new LinkedHashMap<String, Collection<ManagedObjectReference>>();
        for (ManagedObjectReference entity : entities) {
            String serverGuid = entity.getServerGuid();
            LinkedList<ManagedObjectReference> vcEntities = (LinkedList<ManagedObjectReference>)result.get(serverGuid);
            if (vcEntities == null) {
                vcEntities = new LinkedList<ManagedObjectReference>();
                result.put(serverGuid, vcEntities);
            }
            vcEntities.add(entity);
        }
        return result;
    }

    public static boolean isPropertyRequested(String property, PropertySpec[] properties) {
        for (PropertySpec propertySpec : properties) {
            for (String prop : propertySpec.propertyNames) {
                if (!property.equals(prop)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isVc51OrLater(ManagedObjectReference vcEntity) throws Exception {
        return HostProfileUtils.isVcVersionGte(vcEntity, VERSION_5_1_0);
    }

    public static boolean isVc65OrLater(ManagedObjectReference vcEntity) throws Exception {
        return HostProfileUtils.isVcVersionGte(vcEntity, VERSION_6_1_0);
    }

    public static boolean isVcVersionGte(ManagedObjectReference vcEntity, Version targetVersion) throws Exception {
        VcService service = HostProfileUtils.getVcService(vcEntity);
        Version vcVersion = new Version(service.getServiceVersion());
        return vcVersion.compareTo(targetVersion) >= 0;
    }

    public static HostApplyConfigData createHostApplyConfigData(ProfileManager.ApplyHostConfigSpec applyHostConfigSpec) {
        LocalizableMessage[] messages = applyHostConfigSpec.taskDescription == null ? new LocalizableMessage[]{} : applyHostConfigSpec.taskDescription;
        String[] tasks = new String[messages.length];
        for (int i = 0; i < tasks.length; ++i) {
            LocalizableMessage message = messages[i];
            tasks[i] = LocalizationUtil.getLocalizedMessage((String)message.getKey(), (KeyAnyValue[])message.getArg());
        }
        HostApplyConfigData hostApplyConfig = new HostApplyConfigData();
        hostApplyConfig.remediationTasks = tasks;
        hostApplyConfig.remediationRequirements = applyHostConfigSpec.taskListRequirement == null ? new String[0] : applyHostConfigSpec.taskListRequirement;
        hostApplyConfig.executeResultWrapper = new ExecuteResultWrapper((ExecuteResult)applyHostConfigSpec);
        hostApplyConfig.hostRef = applyHostConfigSpec.getHost();
        hostApplyConfig.error = MixedUtil.getMethodFault((Throwable)applyHostConfigSpec.getFaultData());
        hostApplyConfig.executeResultErrors = HostProfileUtils.getExecuteErrorMessages(applyHostConfigSpec.getStatus(), applyHostConfigSpec.getError());
        return hostApplyConfig;
    }

    private static String[] getExecuteErrorMessages(String status, ExecuteResult.ExecuteError[] errors) {
        if (ExecuteResult.Status.success.toString().equals(status)) {
            return new String[0];
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (ExecuteResult.Status.needInput.toString().equals(status)) {
            errorMessages.add(HostProfileUtils.getLocalizedString("deferredSettings.executeErrorsNeedInput"));
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])errors)) {
            for (ExecuteResult.ExecuteError executeError : errors) {
                if (executeError == null || executeError.message == null) continue;
                String errorMessage = LocalizationUtil.getLocalizedMessage((String)executeError.message.getKey(), (KeyAnyValue[])executeError.message.getArg());
                errorMessages.add(errorMessage);
            }
        }
        return errorMessages.toArray(new String[errorMessages.size()]);
    }
}

