/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.dataprovider;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostSystemComplianceDataProvider
implements DataProvider {
    private static final String HOST_PROFILE_COMPLIANCE_STATUS = "hostProfileComplianceStatus";
    private static final String HOST_SYSTEM_TYPE = HostSystem.class.getSimpleName();
    private static final Log _logger = LogFactory.getLog(HostSystemComplianceDataProvider.class);
    private static final String PROPERTY_HOST_PROFILE_COMPLIANCE_STATUS = "HostSystem/hostProfileComplianceStatus";
    private static final ResultSet EMPTY_RESULT = new ResultSet(null, null, Integer.valueOf(0));
    private final HttpSession _httpSession;
    private final String _vcGuid;

    public HostSystemComplianceDataProvider(HttpSession httpSession, String vcGuid) {
        this._httpSession = httpSession;
        this._vcGuid = vcGuid;
    }

    public ResultSet executeQuery(Query query) {
        ManagedObjectReference[] hosts = null;
        List<String> complianceStatuses = new ArrayList<String>();
        ComplianceManager complianceManager = this.getComplianceManager();
        if (complianceManager == null) {
            return EMPTY_RESULT;
        }
        block8: for (PropertyPredicate propPredicate : query.getFilter().getCriteria()) {
            String predicateProperty;
            switch (predicateProperty = propPredicate.getProperty()) {
                case "HostSystem/hostProfileComplianceStatus": {
                    complianceStatuses = this.getComplianceStatusesFromPropetyPredicate(propPredicate);
                    continue block8;
                }
                case "@modelKey": {
                    hosts = this.getHostsFromPropetyPredicate(propPredicate);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown predicate property requested: " + predicateProperty);
        }
        List<ComplianceManager.EntityAndComplianceStatus> entitiesAndComplianceStatuses = this.getComplianceStatusResult(complianceManager, complianceStatuses, hosts);
        return this.buildResultSet(query, entitiesAndComplianceStatuses);
    }

    private ManagedObjectReference[] getHostsFromPropetyPredicate(PropertyPredicate propPredicate) {
        List<ManagedObjectReference> comparableValues = HostSystemComplianceDataProvider.readComparableValuesOfType(propPredicate, ManagedObjectReference.class);
        return comparableValues.toArray(new ManagedObjectReference[comparableValues.size()]);
    }

    private List<String> getComplianceStatusesFromPropetyPredicate(PropertyPredicate propPredicate) {
        return HostSystemComplianceDataProvider.readComparableValuesOfType(propPredicate, String.class);
    }

    private static <T> List<T> readComparableValuesOfType(PropertyPredicate predicate, Class<?> type2) {
        Object comparableValue = predicate.getComparableValue();
        PropertyPredicate.ComparisonOperator operator = predicate.getOperator();
        ArrayList<Object> comparableValues = new ArrayList<Object>();
        if (operator == PropertyPredicate.ComparisonOperator.EQUAL && type2.isAssignableFrom(comparableValue.getClass())) {
            comparableValues.add(comparableValue);
        } else if (operator == PropertyPredicate.ComparisonOperator.IN && comparableValue instanceof Collection) {
            Collection nestedValueCollection = (Collection)comparableValue;
            for (Object nestedValue : nestedValueCollection) {
                if (nestedValue == null || !type2.isAssignableFrom(nestedValue.getClass())) continue;
                comparableValues.add(nestedValue);
            }
        }
        return comparableValues;
    }

    private ResultSet buildResultSet(Query query, List<ComplianceManager.EntityAndComplianceStatus> entitiesAndComplianceStatuses) {
        if (entitiesAndComplianceStatuses.isEmpty()) {
            return EMPTY_RESULT;
        }
        List properties = query.getProperties();
        ArrayList<ResourceItem> resourceItems = new ArrayList<ResourceItem>();
        for (ComplianceManager.EntityAndComplianceStatus item : entitiesAndComplianceStatuses) {
            List<Object> resourceItemValues = this.createResourceItemValues(item, properties);
            ResourceItem resourceItem = new ResourceItem(resourceItemValues);
            resourceItems.add(resourceItem);
        }
        ResultSet result = new ResultSet(properties, resourceItems, query.getWithTotalCount() ? Integer.valueOf(entitiesAndComplianceStatuses.size()) : null);
        return result;
    }

    private List<Object> createResourceItemValues(ComplianceManager.EntityAndComplianceStatus item, List<String> properties) {
        ArrayList<Object> resourceItemValues = new ArrayList<Object>(properties.size());
        Iterator<String> i$ = properties.iterator();
        block10: while (i$.hasNext()) {
            String property;
            switch (property = i$.next()) {
                case "@type": {
                    resourceItemValues.add(item.entity.getType());
                    continue block10;
                }
                case "@modelKey": {
                    resourceItemValues.add(item.entity);
                    continue block10;
                }
                case "HostSystem/hostProfileComplianceStatus": {
                    resourceItemValues.add(item.complianceStatus);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unknown property requested: " + property);
        }
        return resourceItemValues;
    }

    public QuerySchema getSchema() {
        HashMap<String, QuerySchema.PropertyInfo> propertyInfoByName = new HashMap<String, QuerySchema.PropertyInfo>();
        propertyInfoByName.put(HOST_PROFILE_COMPLIANCE_STATUS, QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING));
        HashMap<String, QuerySchema.ModelInfo> models = new HashMap<String, QuerySchema.ModelInfo>();
        models.put(HOST_SYSTEM_TYPE, new QuerySchema.ModelInfo(propertyInfoByName));
        return QuerySchema.forModels(models);
    }

    private List<ComplianceManager.EntityAndComplianceStatus> getComplianceStatusResult(ComplianceManager complianceManager, List<String> complianceStatuses, ManagedObjectReference[] hosts) {
        ArrayList<ComplianceManager.EntityAndComplianceStatus> entityAndComplianceStatus = new ArrayList<ComplianceManager.EntityAndComplianceStatus>();
        if (complianceStatuses.isEmpty()) {
            this.extractComplianceResults(complianceManager, null, hosts, entityAndComplianceStatus);
        }
        for (String complianceStatus : complianceStatuses) {
            this.extractComplianceResults(complianceManager, complianceStatus, hosts, entityAndComplianceStatus);
        }
        return entityAndComplianceStatus;
    }

    private void extractComplianceResults(ComplianceManager complianceManager, String complianceStatus, ManagedObjectReference[] hosts, List<ComplianceManager.EntityAndComplianceStatus> entityAndComplianceStatus) {
        ComplianceManager.EntityAndComplianceStatus[] result = null;
        try {
            result = complianceManager.queryEntitiesByComplianceStatus(complianceStatus, hosts);
        }
        catch (Exception e) {
            _logger.error((Object)"Could not retrieve entities by compliance status: ", (Throwable)e);
        }
        if (result != null) {
            Collections.addAll(entityAndComplianceStatus, result);
        }
    }

    private ComplianceManager getComplianceManager() {
        VcService service = VimSessionUtil.getService((String)this._vcGuid, (HttpSession)this._httpSession);
        if (service == null) {
            _logger.error((Object)("Could not retrieve VcService: " + this._vcGuid));
            return null;
        }
        if (!VcServiceUtil.is2014VcOrLaterByVersion((String)service.getServiceVersion())) {
            _logger.debug((Object)("Skip the legacy VC: " + this._vcGuid));
            return null;
        }
        ServiceInstanceContent serviceContent = service.getServiceInstanceContent();
        if (serviceContent == null) {
            _logger.error((Object)("Could not retrieve ServiceInstanceContent: " + this._vcGuid));
            return null;
        }
        ComplianceManager complianceManager = null;
        try {
            complianceManager = (ComplianceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getComplianceManager());
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to get ComplianceManager object", (Throwable)e);
            return null;
        }
        return complianceManager;
    }
}

