/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.PasswordField;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vim.profile.ProfilePropertyPath;
import com.vmware.vim.binding.vim.profile.UserInputRequiredParameterMetadata;
import com.vmware.vim.binding.vim.profile.host.AnswerFile;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.PropertyValidationNode;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.ProfilePathUtil;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingTag;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingsSpec;
import com.vmware.vsphere.client.hostprofile.data.DeferredSettingsValidationResult;
import com.vmware.vsphere.client.hostprofile.data.ExecuteResultWrapper;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigData;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigSpecData;
import com.vmware.vsphere.client.hostprofile.data.HostCustomizationImportException;
import com.vmware.vsphere.client.hostprofile.data.HostCustomizationsValidationError;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.impl.PostProcessUtil;
import com.vmware.vsphere.client.hostprofile.impl.Unwrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeferredHostSettingsProviderAdapter
implements PropertyProviderAdapter,
MutationProvider {
    private static final String STAR_PREFIX = "* ";
    private static final String CSV_CUSTOMIZATION_FORMAT = "csv";
    private static final Log _logger = LogFactory.getLog(DeferredHostSettingsProviderAdapter.class);
    private static final String DEFERRED_HOST_SETTINGS_PROPERTY = "deferredHostSettings";
    private static final String DEFERRED_HOST_SETTINGS_PROPERTY_METADATA = "deferredHostSettings.@info";
    public static final String OBJECT = "object";
    public static final String REQUIRED = "required";
    public static final String PROPERTY_NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String VALUE = "value";
    private static final String VALIDATION_ROOT_KEY = "validationRoot";
    private ThreadPoolExecutor _threadPool;
    private QueryExecutor _queryExecutor;
    private TaskMonitor _taskMonitor;

    public DeferredHostSettingsProviderAdapter(DataServiceExtensionRegistry registry, QueryExecutor queryExecutor, ThreadPoolExecutor threadPool, TaskMonitor taskMonitor) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._queryExecutor = queryExecutor;
        this._threadPool = threadPool;
        this._taskMonitor = taskMonitor;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo hostProfileInfo = new TypeInfo();
        hostProfileInfo.type = HostProfile.class.getSimpleName();
        hostProfileInfo.properties = new String[]{DEFERRED_HOST_SETTINGS_PROPERTY, DEFERRED_HOST_SETTINGS_PROPERTY_METADATA};
        return new TypeInfo[]{hostProfileInfo};
    }

    private static DeferredHostSettingsSpec getDeferredHostSettingsSpecParameter(PropertySpec[] specs, String requestedProperty) {
        for (PropertySpec propertySpec : specs) {
            for (ParameterSpec parameterSpec : propertySpec.parameters) {
                Object parameter;
                String propertyName = parameterSpec.propertyName;
                if (!requestedProperty.equals(propertyName) || !((parameter = parameterSpec.parameter) instanceof DeferredHostSettingsSpec)) continue;
                return (DeferredHostSettingsSpec)((Object)parameter);
            }
        }
        return null;
    }

    private static PropertyValue buildPropertyValue(Object provider, String propertyName, Object propertyValue) {
        PropertyValue property = new PropertyValue();
        property.resourceObject = provider;
        property.propertyName = propertyName;
        property.value = propertyValue;
        return property;
    }

    private static ResultItem buildResultItem(ManagedObjectReference host, PropertyValue[] properties) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = host;
        resultItem.properties = properties;
        return resultItem;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objectsRefs = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        ResultSet result = new ResultSet();
        boolean isDeferredHostSettingsMetadataRequested = HostProfileUtils.isPropertyRequested(DEFERRED_HOST_SETTINGS_PROPERTY_METADATA, properties);
        boolean isDeferredHostSettingsRequested = HostProfileUtils.isPropertyRequested(DEFERRED_HOST_SETTINGS_PROPERTY, properties);
        if (isDeferredHostSettingsRequested || isDeferredHostSettingsMetadataRequested) {
            result = this.extractHostCustomizationsData(objectsRefs, properties);
        }
        return result;
    }

    private ResultSet extractHostCustomizationsData(Object[] objectsRefs, PropertySpec[] properties) {
        ManagedObjectReference[] profileRefs = DeferredHostSettingsProviderAdapter.getManagedObjectReferences(objectsRefs, HostProfile.class.getSimpleName());
        ArrayList<ResultItem> profileResults = new ArrayList<ResultItem>();
        ArrayList<Exception> faults = new ArrayList<Exception>();
        ResultSet result = new ResultSet();
        Map<Object, Object> hostProfilesMeta = new HashMap();
        DeferredHostSettingsSpec spec = DeferredHostSettingsProviderAdapter.getDeferredHostSettingsSpecParameter(properties, DEFERRED_HOST_SETTINGS_PROPERTY);
        if (spec != null && !ArrayUtil.isNullOrEmpty((Object[])spec.forceValidationOnHosts)) {
            try {
                hostProfilesMeta = spec.hostApplyProfileWrapper == null ? HostProfileUtils.getHostProfilesMetadata(profileRefs, ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy, ProfileManager.MetadataTypes.category, ProfileManager.MetadataTypes.component) : HostProfileUtils.getHostProfilesMetadata(profileRefs, ProfileManager.MetadataTypes.policy);
            }
            catch (Exception e) {
                _logger.error((Object)"Could not retrieve HostProfileMetadata for the target profiles", (Throwable)e);
                faults.add(new Exception(HostProfileUtils.getLocalizedString("error.readDeferredHostSettingsMetadata")));
                faults.add((Exception)MixedUtil.getMethodFault((Throwable)e));
                result.error = new CompositeException(faults);
                return result;
            }
        }
        for (ManagedObjectReference profileRef : profileRefs) {
            DynamicObject[] deferredSettings = null;
            TypeNodeDescriptor rootDescriptor = null;
            ProfileManager.HostProfileMetadata hostProfileMeta = (ProfileManager.HostProfileMetadata)hostProfilesMeta.get(profileRef);
            if (spec != null && !ArrayUtil.isNullOrEmpty((Object[])spec.forceValidationOnHosts)) {
                try {
                    VcService service = HostProfileUtils.getVcService(profileRef);
                    ProfileManager profileManager = HostProfileUtils.getProfileManager(profileRef.getServerGuid());
                    Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults = new ConcurrentHashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>();
                    Map<String, String> relevantProfilePaths = DeferredHostSettingsProviderAdapter.buildRelevantProfilePaths(profileRef, hostProfileMeta, spec.hostApplyProfileWrapper);
                    if (spec.formattedCustomizations != null) {
                        ProfileManager.CustomizationData customizationData = this.createCustomizationData(spec.formattedCustomizations);
                        cachedResults = this.importHostCustomizations(profileRef, spec.forceValidationOnHosts, profileManager, customizationData, faults);
                        deferredSettings = this.getDeferredHostSettingsFromImportResults(cachedResults, service, hostProfileMeta.policyMetadata, relevantProfilePaths, spec.forceValidationOnHosts, spec.currentHostCustomizations);
                    } else {
                        deferredSettings = this.getDeferredHostSettingsFromTheServer(profileRef, spec, service, hostProfileMeta.policyMetadata, relevantProfilePaths, cachedResults, faults);
                    }
                    rootDescriptor = DeferredHostSettingsProviderAdapter.getDeferredHostSettingsMetadata(service, hostProfileMeta.policyMetadata, spec.forceValidationOnHosts, relevantProfilePaths, cachedResults);
                }
                catch (Exception e) {
                    _logger.warn((Object)"Cannot retrieve deferred settings.", (Throwable)e);
                    faults.add((Exception)MixedUtil.getMethodFault((Throwable)e));
                }
            }
            PropertyValue propertyData = DeferredHostSettingsProviderAdapter.buildPropertyValue(profileRef, DEFERRED_HOST_SETTINGS_PROPERTY, deferredSettings);
            PropertyValue propertyMetadata = DeferredHostSettingsProviderAdapter.buildPropertyValue(profileRef, DEFERRED_HOST_SETTINGS_PROPERTY_METADATA, rootDescriptor);
            ResultItem profileResult = DeferredHostSettingsProviderAdapter.buildResultItem(profileRef, new PropertyValue[]{propertyData, propertyMetadata});
            profileResults.add(profileResult);
        }
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        result.items = profileResults.toArray(new ResultItem[profileResults.size()]);
        return result;
    }

    private DynamicObject[] getDeferredHostSettingsFromTheServer(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, VcService service, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults, List<Exception> faults) throws Exception {
        DynamicObject[] deferredSettings;
        if (this.isBulkAnswerFileEnabled(profileRef)) {
            deferredSettings = this.getDeferredHostSettingsInBatch(service, profileRef, spec, policiesMetadata, cachedResults, relevantProfilePaths, faults);
        } else {
            PropertyValue[] hostsName = this.getEntitiesName(spec.forceValidationOnHosts);
            deferredSettings = this.getDeferredHostSettings(service, profileRef, spec, policiesMetadata, hostsName, relevantProfilePaths, cachedResults, faults);
        }
        return deferredSettings;
    }

    private PropertyValue[] getEntitiesName(Object[] entities) throws Exception {
        if (entities == null || entities.length == 0) {
            return null;
        }
        try {
            return this._queryExecutor.getProperties(entities, new String[]{PROPERTY_NAME});
        }
        catch (Exception e) {
            _logger.error((Object)"The host name could not be retrieved", (Throwable)e);
            throw e;
        }
    }

    private static String getEntityName(PropertyValue[] names, ManagedObjectReference entity) {
        if (names == null || entity == null) {
            return null;
        }
        for (PropertyValue name : names) {
            if (!entity.equals(name.resourceObject) || !(name.value instanceof String)) continue;
            return (String)name.value;
        }
        return null;
    }

    private static DeferredPolicyOptionParameter[] extractDeferredHostSettingsFromServer(ManagedObjectReference hpRef, DeferredHostSettingsSpec spec, ProfileManager profileManager, ManagedObjectReference hostRef, PolicyMetadata[] policyMetadata) throws Exception {
        AnswerFile answerFile = null;
        HostApplyProfile applyProfile = DeferredHostSettingsProviderAdapter.getHostApplyProfile(hpRef, spec, policyMetadata);
        answerFile = applyProfile != null ? profileManager.retrieveAnswerFileForProfile(hostRef, applyProfile) : profileManager.retrieveAnswerFile(hostRef);
        DeferredPolicyOptionParameter[] deferredParameters = null;
        if (answerFile != null) {
            deferredParameters = answerFile.userInput;
        } else {
            _logger.warn((Object)("Execute result is null for host: " + hostRef));
        }
        if (deferredParameters == null) {
            deferredParameters = new DeferredPolicyOptionParameter[]{};
        }
        return deferredParameters;
    }

    private DynamicObject[] getDeferredHostSettings(final VcService service, final ManagedObjectReference hpRef, final DeferredHostSettingsSpec spec, final PolicyMetadata[] policiesMetadata, final PropertyValue[] hostsName, final Map<String, String> relevantProfilePaths, final Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults, List<Exception> faults) throws Exception {
        ArrayList<1> taskRequests = new ArrayList<1>(spec.forceValidationOnHosts.length);
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        final ProfileManager profileManager = HostProfileUtils.getProfileManager(hpRef.getServerGuid());
        for (final ManagedObjectReference hostRef : spec.forceValidationOnHosts) {
            Callable<Collection<DynamicObject>> callable = new Callable<Collection<DynamicObject>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Collection<DynamicObject> call() throws Exception {
                    try {
                        SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                        DeferredPolicyOptionParameter[] deferredSettings = DeferredHostSettingsProviderAdapter.extractDeferredHostSettingsFromServer(hpRef, spec, profileManager, hostRef, policiesMetadata);
                        Collection<Object> result = new ArrayList<DynamicObject>();
                        if (deferredSettings != null) {
                            cachedResults.put(hostRef, deferredSettings);
                            String hostName = DeferredHostSettingsProviderAdapter.getEntityName(hostsName, hostRef);
                            result = DeferredHostSettingsProviderAdapter.this.extractDeferredHostSettings(service, hostName, policiesMetadata, relevantProfilePaths, deferredSettings, null);
                        }
                        ArrayList<DynamicObject> arrayList = result;
                        return arrayList;
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                    }
                }
            };
            taskRequests.add(callable);
        }
        List deferredSettingsResult = this._threadPool.invokeAll(taskRequests, 1L, TimeUnit.HOURS);
        ArrayList resultList = new ArrayList(spec.forceValidationOnHosts.length);
        for (int i = 0; i < deferredSettingsResult.size(); ++i) {
            Future future = deferredSettingsResult.get(i);
            try {
                resultList.addAll((Collection)future.get());
                continue;
            }
            catch (ExecutionException e) {
                String hostName = DeferredHostSettingsProviderAdapter.getEntityName(hostsName, spec.forceValidationOnHosts[i]);
                _logger.warn((Object)("Cannot extract deferred host settings on " + hostName), (Throwable)e);
                MethodFault detailedException = MixedUtil.getMethodFault((Throwable)new Exception(hostName + " - " + e.getCause().getLocalizedMessage()));
                faults.add((Exception)detailedException);
            }
        }
        DynamicObject[] result = new DynamicObject[resultList.size()];
        result = resultList.toArray(result);
        return result;
    }

    private static String buildRowPrimaryKey(String object, String property, String policyId, String propertyPath) {
        String primaryKey = String.format("%s.%s.%s.%s", object, property, policyId, propertyPath);
        return primaryKey.replace(" ", "");
    }

    private Collection<DynamicObject> extractDeferredHostSettings(VcService service, String hostName, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, DeferredPolicyOptionParameter[] newDeferredSettings, DeferredPolicyOptionParameter[] oldDeferredSettings) {
        Map<String, Map<String, Object>> oldDeferredHostSettingsValuesMap = this.extractDeferredHostSettingValues(oldDeferredSettings);
        LinkedList<DynamicObject> resultList = new LinkedList<DynamicObject>();
        if (newDeferredSettings.length == 0) {
            DynamicObject deferredParam = new DynamicObject();
            deferredParam.properties = new NameValuePair[]{new NameValuePair(REQUIRED, (Object)""), new NameValuePair(OBJECT, (Object)hostName), new NameValuePair(PROPERTY_NAME, (Object)""), new NameValuePair(DESCRIPTION, (Object)""), new NameValuePair(VALUE, (Object)"")};
            DeferredHostSettingTag tag = new DeferredHostSettingTag();
            tag.deferredSettings = newDeferredSettings;
            deferredParam.key = DeferredHostSettingsProviderAdapter.buildRowPrimaryKey(hostName, "", "", "");
            deferredParam.tag = tag;
            resultList.add(deferredParam);
        }
        boolean executeResultPassed = false;
        for (DeferredPolicyOptionParameter param : newDeferredSettings) {
            String relevantProfilePath;
            PolicyMetadata metadata = DeferredHostSettingsProviderAdapter.getPolicyMetadata(policiesMetadata, param);
            if (metadata == null || (relevantProfilePath = DeferredHostSettingsProviderAdapter.extractRelevantPath(relevantProfilePaths, param.getInputPath().profilePath)) == null) continue;
            PolicyMetadata localizedPolicyMetadata = HostProfileUtils.getLocalizedPolicyMetadata(service, metadata);
            relevantProfilePath = String.format("%s > %s", relevantProfilePath, localizedPolicyMetadata.id.label);
            Map<String, Object> oldValuesMap = oldDeferredHostSettingsValuesMap.get(param.getInputPath().profilePath);
            for (KeyAnyValue keyValue : param.parameter) {
                ParameterMetadata userInputParameter = DeferredHostSettingsProviderAdapter.getParameterMetadata(metadata.possibleOption, keyValue.getKey());
                if (userInputParameter == null) continue;
                ParameterMetadata localizedParameterMetadata = HostProfileUtils.getLocalizedParameterMetadata(service, userInputParameter);
                DynamicObject deferredParam = new DynamicObject();
                String requiredColumnValue = userInputParameter.isOptional() ? HostProfileUtils.getLocalizedString("deferredSettings.column.valueNotRequired") : HostProfileUtils.getLocalizedString("deferredSettings.column.valueRequired");
                boolean isValueUpdated = false;
                Object propertyValue = DeferredHostSettingsProviderAdapter.toFlexObject(keyValue);
                if (oldDeferredSettings != null) {
                    isValueUpdated = oldValuesMap == null ? true : this.isDeferredSettingValueUpdated(oldValuesMap.get(keyValue.getKey()), propertyValue);
                }
                String propertyName = null;
                propertyName = isValueUpdated ? STAR_PREFIX + localizedParameterMetadata.id.label : localizedParameterMetadata.id.label;
                deferredParam.properties = new NameValuePair[]{new NameValuePair(REQUIRED, (Object)requiredColumnValue), new NameValuePair(OBJECT, (Object)hostName), new NameValuePair(PROPERTY_NAME, (Object)propertyName), new NameValuePair(DESCRIPTION, (Object)relevantProfilePath), new NameValuePair(VALUE, propertyValue)};
                deferredParam.key = DeferredHostSettingsProviderAdapter.buildRowPrimaryKey(hostName, keyValue.getKey(), param.getInputPath().policyId, param.getInputPath().profilePath);
                if (!executeResultPassed) {
                    DeferredHostSettingTag tag = new DeferredHostSettingTag();
                    tag.deferredSettings = newDeferredSettings;
                    deferredParam.tag = tag;
                    executeResultPassed = true;
                }
                resultList.add(deferredParam);
            }
        }
        return resultList;
    }

    private boolean isDeferredSettingValueUpdated(Object oldPropertyValue, Object newPropertyValue) {
        if (oldPropertyValue == null) {
            return newPropertyValue != null;
        }
        return !oldPropertyValue.equals(newPropertyValue);
    }

    private Map<String, Map<String, Object>> extractDeferredHostSettingValues(DeferredPolicyOptionParameter[] deferredSettings) {
        HashMap<String, Map<String, Object>> deferredParameters = new HashMap<String, Map<String, Object>>();
        if (deferredSettings == null || deferredSettings.length == 0) {
            return deferredParameters;
        }
        for (DeferredPolicyOptionParameter param : deferredSettings) {
            String profilePath = param.getInputPath().profilePath;
            HashMap<String, Object> parameterValuesByKey = (HashMap<String, Object>)deferredParameters.get(profilePath);
            if (parameterValuesByKey == null) {
                parameterValuesByKey = new HashMap<String, Object>();
                deferredParameters.put(profilePath, parameterValuesByKey);
            }
            for (KeyAnyValue keyValue : param.parameter) {
                parameterValuesByKey.put(keyValue.getKey(), DeferredHostSettingsProviderAdapter.toFlexObject(keyValue));
            }
        }
        return deferredParameters;
    }

    private static void fromFlexObject(KeyAnyValue keyValue, Object userValue) {
        if (userValue != null) {
            if (keyValue.getValue() instanceof PasswordField) {
                userValue = new PasswordField(userValue.toString());
            }
            keyValue.setValue(userValue);
        }
    }

    private static Object toFlexObject(KeyAnyValue keyValue) {
        Object returnValue = keyValue.getValue();
        if (returnValue instanceof PasswordField) {
            returnValue = ((PasswordField)returnValue).getValue();
        }
        return returnValue;
    }

    private static Map<String, String> buildRelevantProfilePaths(ManagedObjectReference profileRef, ProfileManager.HostProfileMetadata hostProfileMeta, ProfileWrapper profileWrapper) {
        if (profileWrapper == null) {
            try {
                profileWrapper = ProfilePathUtil.buildProfileWrapper(profileRef, hostProfileMeta.profileMetadata, hostProfileMeta.policyMetadata, hostProfileMeta.profileCategoryMetadata, hostProfileMeta.profileComponentMetadata);
            }
            catch (Throwable e) {
                _logger.warn((Object)"Profile wrapper cannot be built", e);
            }
        }
        ConcurrentHashMap<String, String> relevantProfilePaths = new ConcurrentHashMap<String, String>();
        ProfilePathUtil.extractProfileParamsPaths(profileWrapper, relevantProfilePaths);
        return relevantProfilePaths;
    }

    private static String extractRelevantPath(Map<String, String> relevantProfilePaths, String actualProfilePath) {
        String fullPath = actualProfilePath == null ? null : relevantProfilePaths.get(actualProfilePath);
        return fullPath;
    }

    private static PolicyMetadata getPolicyMetadata(PolicyMetadata[] policies, DeferredPolicyOptionParameter param) {
        for (PolicyMetadata policy : policies) {
            if (!policy.id.key.equals(param.getInputPath().policyId)) continue;
            return policy;
        }
        return null;
    }

    private static TypeNodeDescriptor getDeferredHostSettingsMetadata(VcService service, PolicyMetadata[] policiesMetadata, ManagedObjectReference[] hosts, Map<String, String> relevantProfilePaths, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults) {
        if (cachedResults.isEmpty()) {
            return null;
        }
        ArrayList<PropertyNodeDescriptor> resultList = new ArrayList<PropertyNodeDescriptor>();
        for (ManagedObjectReference host : hosts) {
            DeferredPolicyOptionParameter[] deferredSettings = cachedResults.get(host);
            if (deferredSettings == null) continue;
            DeferredHostSettingsProviderAdapter.extractDeferredSettingsMetadata(service, resultList, policiesMetadata, relevantProfilePaths, deferredSettings);
        }
        TypeNodeDescriptor arrayDescriptor = new TypeNodeDescriptor();
        arrayDescriptor.name = "array";
        arrayDescriptor.properties = resultList.toArray(new PropertyNodeDescriptor[0]);
        return arrayDescriptor;
    }

    private static void extractDeferredSettingsMetadata(VcService service, ArrayList<PropertyNodeDescriptor> resultList, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, DeferredPolicyOptionParameter[] params) {
        for (DeferredPolicyOptionParameter param : params) {
            PolicyMetadata policyMetadata = DeferredHostSettingsProviderAdapter.getPolicyMetadata(policiesMetadata, param);
            if (policyMetadata == null) {
                _logger.warn((Object)("Skip irelevant profile path with vCenter Server version: " + param.getInputPath().policyId));
                continue;
            }
            String relevantProfilePath = DeferredHostSettingsProviderAdapter.extractRelevantPath(relevantProfilePaths, param.getInputPath().profilePath);
            if (relevantProfilePath == null) {
                _logger.warn((Object)("Skip irelevant profile path with current profile instance: " + param.getInputPath().policyId));
                continue;
            }
            for (KeyAnyValue keyValue : param.parameter) {
                ParameterMetadata parameterMetadata = DeferredHostSettingsProviderAdapter.getParameterMetadata(policyMetadata.possibleOption, keyValue.getKey());
                if (parameterMetadata == null) {
                    _logger.warn((Object)("Cannot find a deferred parameter metadata for key: " + keyValue.getKey()));
                    continue;
                }
                ParameterMetadata localizedParameterMetadata = HostProfileUtils.getLocalizedParameterMetadata(service, parameterMetadata);
                String propertyDescription = localizedParameterMetadata.id.summary;
                String propertyType = HostProfileUtils.getResourceFWType(localizedParameterMetadata.getType().getName(), keyValue.getValue());
                TypeNodeDescriptor typeDescriptor = new TypeNodeDescriptor();
                typeDescriptor.properties = new PropertyNodeDescriptor[]{DeferredHostSettingsProviderAdapter.getPropertyRequiredMetadata(), DeferredHostSettingsProviderAdapter.getObjectMetadata(null), DeferredHostSettingsProviderAdapter.getPropertyNameMetadata(propertyDescription), DeferredHostSettingsProviderAdapter.getDescriptionMetadata(null), DeferredHostSettingsProviderAdapter.getValueMetadata(propertyDescription, propertyType, parameterMetadata.isOptional())};
                PropertyNodeDescriptor rowDescriptor = new PropertyNodeDescriptor();
                rowDescriptor.name = Integer.toString(resultList.size());
                rowDescriptor.valueType = typeDescriptor;
                resultList.add(rowDescriptor);
            }
        }
    }

    private static PropertyNodeDescriptor getObjectMetadata(String description) {
        PropertyNodeDescriptor pdObject = new PropertyNodeDescriptor();
        pdObject.name = OBJECT;
        pdObject.title = HostProfileUtils.getLocalizedString("deferredSettings.column.object");
        pdObject.description = description;
        pdObject.valueTypeName = "string";
        pdObject.immutable = true;
        return pdObject;
    }

    private static PropertyNodeDescriptor getPropertyNameMetadata(String description) {
        PropertyNodeDescriptor pdName = new PropertyNodeDescriptor();
        pdName.name = PROPERTY_NAME;
        pdName.title = HostProfileUtils.getLocalizedString("deferredSettings.column.propertyName");
        pdName.description = description;
        pdName.valueTypeName = "string";
        pdName.immutable = true;
        return pdName;
    }

    private static PropertyNodeDescriptor getPropertyRequiredMetadata() {
        PropertyNodeDescriptor pdName = new PropertyNodeDescriptor();
        pdName.name = REQUIRED;
        pdName.title = HostProfileUtils.getLocalizedString("deferredSettings.column.propertyRequired");
        pdName.valueTypeName = "string";
        pdName.immutable = true;
        return pdName;
    }

    private static PropertyNodeDescriptor getDescriptionMetadata(String description) {
        PropertyNodeDescriptor pdDesc = new PropertyNodeDescriptor();
        pdDesc.name = DESCRIPTION;
        pdDesc.title = HostProfileUtils.getLocalizedString("deferredSettings.column.propertyDescription");
        pdDesc.description = description;
        pdDesc.valueTypeName = "string";
        pdDesc.immutable = true;
        return pdDesc;
    }

    private static PropertyNodeDescriptor getValueMetadata(String description, String propertyType, boolean isOptional) {
        PropertyNodeDescriptor pdValue = new PropertyNodeDescriptor();
        pdValue.name = VALUE;
        pdValue.title = HostProfileUtils.getLocalizedString("deferredSettings.column.propertyValue");
        pdValue.description = description;
        pdValue.valueTypeName = propertyType;
        pdValue.isOptional = isOptional;
        if ("password".equals(propertyType)) {
            pdValue.tags = new HashMap();
            pdValue.tags.put("createPassword", "true");
        }
        return pdValue;
    }

    private static ParameterMetadata getParameterMetadata(PolicyOptionMetadata[] possibleOption, String key) {
        for (PolicyOptionMetadata policyMetadata : possibleOption) {
            if (!(policyMetadata instanceof UserInputRequiredParameterMetadata)) continue;
            UserInputRequiredParameterMetadata metadata = (UserInputRequiredParameterMetadata)policyMetadata;
            for (ParameterMetadata paramMetadata : metadata.userInputParameter) {
                if (!paramMetadata.id.key.equals(key)) continue;
                return paramMetadata;
            }
        }
        return null;
    }

    private static DeferredSettingsValidationResult runValidationOnServer(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, ManagedObjectReference hostRef, DeferredPolicyOptionParameter[] deferredSettings, Map<String, ExecuteResultWrapper> cachedResults, PolicyMetadata[] policyMetadata) throws Exception {
        DeferredSettingsValidationResult validationResult = null;
        if (!spec.executeProfile && HostProfileUtils.isVc51OrLater(profileRef)) {
            ProfileManager profileManager = HostProfileUtils.getProfileManager(profileRef.getServerGuid());
            HostApplyProfile applyProfile = DeferredHostSettingsProviderAdapter.getHostApplyProfile(profileRef, spec, policyMetadata);
            ProfileManager.AnswerFileOptionsCreateSpec answerFileSpec = new ProfileManager.AnswerFileOptionsCreateSpec();
            answerFileSpec.userInput = deferredSettings;
            answerFileSpec.validating = true;
            ProfileManager.AnswerFileValidationResult answerFileResult = profileManager.validateAnswerFile(hostRef, (ProfileManager.AnswerFileCreateSpec)answerFileSpec, applyProfile);
            if (answerFileResult != null) {
                validationResult = new DeferredSettingsValidationResult(answerFileResult);
            }
        } else {
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
            ExecuteResult executeResult = profile.execute(hostRef, deferredSettings);
            if (executeResult != null) {
                validationResult = new DeferredSettingsValidationResult(executeResult);
                ExecuteResultWrapper resultWrapper = new ExecuteResultWrapper(executeResult);
                cachedResults.put(ManagedObjectUtil.morefToString((ManagedObjectReference)hostRef), resultWrapper);
            }
        }
        return validationResult;
    }

    @MutationMapping(type="HostProfile", property="deferredHostSettings")
    public ValidationResult validateDeferredHostSettings(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, Object[] rows) throws Exception {
        try {
            ProfileManager.HostProfileMetadata hostProfileMeta = HostProfileUtils.getHostProfileMetadata(profileRef, ProfileManager.MetadataTypes.policy);
            boolean isBulkAnswerFileEnabled = this.isBulkAnswerFileEnabled(profileRef);
            if (!spec.executeProfile && isBulkAnswerFileEnabled) {
                return this.validateHostCustomizationsOnServerInBatch(profileRef, spec, rows, hostProfileMeta.policyMetadata);
            }
            boolean isParallelOperationsEnabled = this.isParallelOperationsEnabled(profileRef);
            if (spec.executeProfile && isParallelOperationsEnabled) {
                return this.validateHostApplyConfigData(spec, rows);
            }
            return this.validateHostCustomizationsOnServer(profileRef, spec, rows, hostProfileMeta.policyMetadata);
        }
        catch (Exception e) {
            ArrayList<Exception> errors = new ArrayList<Exception>();
            ValidationResult result = new ValidationResult();
            errors.add(new Exception(HostProfileUtils.getLocalizedString("error.validateHostCustomizations")));
            errors.add((Exception)MixedUtil.getMethodFault((Throwable)e));
            result.error = new CompositeException(errors);
            return result;
        }
    }

    private ValidationResult validateHostApplyConfigData(DeferredHostSettingsSpec spec, Object[] rows) throws Exception {
        ValidationResult result = new ValidationResult();
        DeferredSettingsValidationResult validationResult = null;
        ConcurrentHashMap<String, PropertyValidationNode> validationMessages = new ConcurrentHashMap<String, PropertyValidationNode>();
        if (spec.forceValidationOnHosts == null || spec.forceValidationOnHosts.length == 0) {
            return result;
        }
        ManagedObjectReference[] hosts = spec.forceValidationOnHosts;
        ProfileManager profileManager = this.getProfileManager(hosts);
        Map<ManagedObjectReference, String> hostEntityNameMap = this.createHostEntityNameMap(hosts);
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap = this.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
        HostApplyConfigSpecData applyConfigSpecData = this.createHostApplyConfigSpecData(profileManager, hosts, deferredPolicyOptionParameterMap);
        List<Exception> faults = applyConfigSpecData.faults;
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        Collection<ProfileManager.ApplyHostConfigSpec> applyHostConfigSpecs = applyConfigSpecData.hostApplyConfigMap.values();
        HashMap<String, HostApplyConfigData> cachedResults = new HashMap<String, HostApplyConfigData>();
        for (ProfileManager.ApplyHostConfigSpec applyHostConfigSpec : applyHostConfigSpecs) {
            validationResult = new DeferredSettingsValidationResult((ExecuteResult)applyHostConfigSpec);
            String hostName = hostEntityNameMap.get(applyHostConfigSpec.getHost());
            DeferredPolicyOptionParameter[] policyOptions = deferredPolicyOptionParameterMap.get(applyHostConfigSpec.getHost());
            DeferredHostSettingsProviderAdapter.processValidationResults(validationResult, validationMessages, hostName, policyOptions);
            HostApplyConfigData hostApplyConfig = HostProfileUtils.createHostApplyConfigData(applyHostConfigSpec);
            cachedResults.put(ManagedObjectUtil.morefToString((ManagedObjectReference)applyHostConfigSpec.getHost()), hostApplyConfig);
        }
        result.result = validationMessages.size() > 0 ? validationMessages.values().toArray(new PropertyValidationNode[0]) : cachedResults.values().toArray(new HostApplyConfigData[cachedResults.size()]);
        return result;
    }

    private ValidationResult validateHostCustomizationsOnServer(final ManagedObjectReference profileRef, final DeferredHostSettingsSpec spec, final Object[] rows, PolicyMetadata[] policyMetadata) throws Exception {
        ConcurrentHashMap cachedResults = new ConcurrentHashMap();
        ConcurrentHashMap validationMessages = new ConcurrentHashMap();
        Object[] hosts = spec.forceValidationOnHosts == null ? new ManagedObjectReference[]{} : spec.forceValidationOnHosts;
        PropertyValue[] hostsName = this.getEntitiesName(hosts);
        ArrayList errors = new ArrayList();
        ArrayList<2> validationTasks = new ArrayList<2>(hosts.length);
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        for (Object host : hosts) {
            final String hostName = DeferredHostSettingsProviderAdapter.getEntityName(hostsName, (ManagedObjectReference)host);
            Callable<Void> validationTask = new Callable<Void>((ManagedObjectReference)host, cachedResults, policyMetadata, validationMessages, errors){
                final /* synthetic */ ManagedObjectReference val$host;
                final /* synthetic */ Map val$cachedResults;
                final /* synthetic */ PolicyMetadata[] val$policyMetadata;
                final /* synthetic */ Map val$validationMessages;
                final /* synthetic */ List val$errors;
                {
                    this.val$host = managedObjectReference2;
                    this.val$cachedResults = map;
                    this.val$policyMetadata = policyMetadataArray;
                    this.val$validationMessages = map2;
                    this.val$errors = list;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Object[] deferredSettings = DeferredHostSettingsProviderAdapter.convertDeferredSettings(rows, hostName);
                    if (ArrayUtil.isNullOrEmpty((Object[])deferredSettings) && !spec.executeProfile) {
                        return null;
                    }
                    SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                    try {
                        DeferredSettingsValidationResult validationResult = DeferredHostSettingsProviderAdapter.runValidationOnServer(profileRef, spec, this.val$host, (DeferredPolicyOptionParameter[])deferredSettings, this.val$cachedResults, this.val$policyMetadata);
                        DeferredHostSettingsProviderAdapter.processValidationResults(validationResult, this.val$validationMessages, hostName, (DeferredPolicyOptionParameter[])deferredSettings);
                    }
                    catch (Exception e) {
                        _logger.warn((Object)("Could not validate host: " + this.val$host), (Throwable)e);
                        DeferredHostSettingsProviderAdapter.addValidationMessage(this.val$validationMessages, DeferredHostSettingsProviderAdapter.VALIDATION_ROOT_KEY, null, DeferredHostSettingsProviderAdapter.getContextValidationMessage(hostName, e.getLocalizedMessage()));
                        this.val$errors.add(e);
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                    }
                    return null;
                }
            };
            validationTasks.add(validationTask);
        }
        try {
            this._threadPool.invokeAll(validationTasks, 1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (validationMessages.size() > 1) {
            validationMessages.remove(VALIDATION_ROOT_KEY);
        }
        ValidationResult result = new ValidationResult();
        if (!errors.isEmpty()) {
            result.error = new CompositeException(errors);
        }
        result.result = validationMessages.size() > 0 ? validationMessages.values().toArray(new PropertyValidationNode[0]) : cachedResults;
        return result;
    }

    private static void addValidationMessage(Map<String, PropertyValidationNode> validationMessages, String validationPath, String primaryKey, String validationMessage) {
        PropertyValidationNode validationNode = validationMessages.get(validationPath);
        if (validationNode == null) {
            validationNode = new PropertyValidationNode();
            if (primaryKey != null) {
                validationNode.propertyName = VALUE;
                validationNode.key = primaryKey;
            }
            validationNode.validationMessages = new String[]{validationMessage};
            validationMessages.put(validationPath, validationNode);
        } else {
            String[] errors = new String[validationNode.validationMessages.length + 1];
            System.arraycopy(validationNode.validationMessages, 0, errors, 0, validationNode.validationMessages.length);
            errors[errors.length - 1] = validationMessage;
        }
    }

    private static String getContextValidationMessage(String hostName, String message) {
        String result = HostProfileUtils.getLocalizedString("error.validateDeferredSettings", hostName, message);
        return result;
    }

    private static void processValidationResults(DeferredSettingsValidationResult validationResult, Map<String, PropertyValidationNode> validationMessages, String hostName, DeferredPolicyOptionParameter[] deferredHostSettings) {
        if (validationResult == null || ExecuteResult.Status.success.toString().equals(validationResult.status)) {
            return;
        }
        if (ExecuteResult.Status.needInput.toString().equals(validationResult.status)) {
            String errorMessage = HostProfileUtils.getLocalizedString("deferredSettings.errors.generalError");
            DeferredHostSettingsProviderAdapter.addValidationMessage(validationMessages, VALIDATION_ROOT_KEY, null, DeferredHostSettingsProviderAdapter.getContextValidationMessage(hostName, errorMessage));
            return;
        }
        if (validationResult.errors == null) {
            return;
        }
        for (DeferredSettingsValidationResult.ValidationError error : validationResult.errors) {
            ProfilePropertyPath errorPath = error.path;
            String property = null;
            String policyId = null;
            if (errorPath != null) {
                DeferredPolicyOptionParameter failedParameter = DeferredHostSettingsProviderAdapter.findFailedParameter(errorPath, deferredHostSettings);
                policyId = errorPath.policyId;
                if (failedParameter != null && failedParameter.parameter.length > 0) {
                    property = errorPath.parameterId != null ? errorPath.parameterId : failedParameter.parameter[0].getKey();
                }
            }
            LocalizableMessage localizableMessage = error.message;
            String errorMessage = LocalizationUtil.getLocalizedMessage((String)localizableMessage.getKey(), (KeyAnyValue[])localizableMessage.getArg());
            if (property == null || policyId == null) {
                _logger.warn((Object)("Could not find failed property for policy: " + (errorPath != null ? errorPath.policyId : null)));
                DeferredHostSettingsProviderAdapter.addValidationMessage(validationMessages, VALIDATION_ROOT_KEY, null, DeferredHostSettingsProviderAdapter.getContextValidationMessage(hostName, errorMessage));
                continue;
            }
            String primaryKey = DeferredHostSettingsProviderAdapter.buildRowPrimaryKey(hostName, property, policyId, errorPath.profilePath);
            String fullPropertyPath = String.format("[%s].%s", primaryKey, VALUE);
            DeferredHostSettingsProviderAdapter.addValidationMessage(validationMessages, fullPropertyPath, primaryKey, errorMessage);
        }
    }

    private static DeferredPolicyOptionParameter findFailedParameter(ProfilePropertyPath errorPath, DeferredPolicyOptionParameter[] deferredHostSettings) {
        if (errorPath == null) {
            return null;
        }
        for (DeferredPolicyOptionParameter hostSetting : deferredHostSettings) {
            if (!hostSetting.inputPath.policyId.equals(errorPath.policyId)) continue;
            return hostSetting;
        }
        return null;
    }

    private static DeferredPolicyOptionParameter[] convertDeferredSettings(Object[] rowsData, String hostName) {
        DeferredPolicyOptionParameter[] results = null;
        if (rowsData == null) {
            return results;
        }
        block0: for (Object rowObject : rowsData) {
            if (!(rowObject instanceof DynamicObject)) {
                _logger.warn((Object)("Unknown row object: " + rowObject));
                continue;
            }
            DynamicObject row = (DynamicObject)rowObject;
            for (NameValuePair valuePair : row.properties) {
                if (!OBJECT.equals(valuePair.name) || !hostName.equals(valuePair.value) || !(row.tag instanceof DeferredHostSettingTag)) continue;
                results = ((DeferredHostSettingTag)((Object)row.tag)).deferredSettings;
                break block0;
            }
        }
        if (results == null) {
            return null;
        }
        for (DeferredPolicyOptionParameter deferredParameter : results) {
            for (KeyAnyValue valuePair : deferredParameter.parameter) {
                Object userValue = DeferredHostSettingsProviderAdapter.findPropertyValue(rowsData, hostName, valuePair.getKey(), deferredParameter.getInputPath().policyId, deferredParameter.getInputPath().profilePath);
                DeferredHostSettingsProviderAdapter.fromFlexObject(valuePair, userValue);
            }
        }
        return results;
    }

    private static Object findPropertyValue(Object[] rows, String object, String propertyName, String policyId, String propertyPath) {
        String uniqueRowIdentifier = DeferredHostSettingsProviderAdapter.buildRowPrimaryKey(object, propertyName, policyId, propertyPath);
        for (Object rowObject : rows) {
            if (!(rowObject instanceof DynamicObject)) {
                _logger.warn((Object)("Unknown row object: " + rowObject));
                continue;
            }
            DynamicObject row = (DynamicObject)rowObject;
            if (!uniqueRowIdentifier.equals(row.key)) continue;
            for (NameValuePair valuePair : row.properties) {
                if (!VALUE.equals(valuePair.name)) continue;
                return valuePair.value;
            }
        }
        _logger.warn((Object)String.format("Cannot find host setting value for a %s.%s", object, propertyName));
        return null;
    }

    @MutationMapping(type="HostProfile", property="deferredHostSettings")
    public OperationResult[] applyDeferredHostSettings(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, Object[] rows) {
        ProfileManager profileManager;
        try {
            profileManager = HostProfileUtils.getProfileManager(profileRef.getServerGuid());
        }
        catch (Exception e) {
            _logger.error((Object)"Could not retrieve ProfileManager. Exception: ", (Throwable)e);
            OperationResult operation = new OperationResult();
            operation.error = MixedUtil.getMethodFault((Throwable)e);
            return new OperationResult[]{operation};
        }
        try {
            if (this.isBulkAnswerFileEnabled(profileRef)) {
                return this.applyHostCustomizationsInBatch(profileManager, rows, spec);
            }
            return this.applyHostCustomizations(profileManager, rows, spec);
        }
        catch (Exception e) {
            _logger.error((Object)"Update host customizations not started: ", (Throwable)e);
            OperationResult operation = new OperationResult();
            operation.error = new CompositeException(new Exception[]{new Exception(HostProfileUtils.getLocalizedString("error.updateHostCustomizationsNotStarted")), MixedUtil.getMethodFault((Throwable)e)});
            return new OperationResult[]{operation};
        }
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] profiles, DeferredHostSettingsSpec spec) throws Exception {
        ManagedObjectReference profileRef = profiles[0];
        OperationResult[] operationResults = this.applyDeferredHostSettings(profileRef, spec, spec.currentHostCustomizations);
        if (operationResults == null || operationResults.length != 1) {
            return operationResults;
        }
        OperationResult operationResult = operationResults[0];
        if (operationResult.error != null || operationResult.task == null) {
            return operationResults;
        }
        TaskInfo taskInfo = this._taskMonitor.monitorTask((ManagedObjectReference)operationResult.task);
        if (taskInfo == null || !(taskInfo.result instanceof ProfileManager.AnswerFileValidationResultMap[])) {
            return operationResults;
        }
        ValidationResult validationResult = this.extractValidationResult((ProfileManager.AnswerFileValidationResultMap[])taskInfo.result, spec.currentHostCustomizations, spec.forceValidationOnHosts);
        if (validationResult != null && (validationResult.result instanceof PropertyValidationNode[] || validationResult.error != null)) {
            OperationResult validationFailedResult = new OperationResult();
            validationFailedResult.error = new HostCustomizationsValidationError(Util.getLocalizedString("error.deferredSettingsValidationFailed"));
            validationFailedResult.result = validationResult;
            return new OperationResult[]{validationFailedResult};
        }
        return operationResults;
    }

    private ValidationResult extractValidationResult(ProfileManager.AnswerFileValidationResultMap[] answerFileValidationResult, Object[] currentHostCustomizations, ManagedObjectReference[] hosts) throws Exception {
        Map<ManagedObjectReference, String> hostEntityNameMap = this.createHostEntityNameMap(hosts);
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap = this.createDeferredPolicyOptionParameterMap(currentHostCustomizations, hostEntityNameMap);
        return this.createValidationResult(deferredPolicyOptionParameterMap, hostEntityNameMap, answerFileValidationResult);
    }

    private ValidationResult createValidationResult(Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap, Map<ManagedObjectReference, String> hostEntityNameMap, ProfileManager.AnswerFileValidationResultMap[] results) {
        HashMap<String, PropertyValidationNode> validationMessages = new HashMap<String, PropertyValidationNode>();
        ArrayList<MethodFault> errors = new ArrayList<MethodFault>();
        for (ProfileManager.AnswerFileValidationResultMap answerFileValidationResult : results) {
            if (answerFileValidationResult == null) continue;
            if (answerFileValidationResult.fault != null) {
                errors.add(MixedUtil.getMethodFault((Throwable)answerFileValidationResult.fault));
                continue;
            }
            if (answerFileValidationResult.getValidationResult() == null) continue;
            String hostName = hostEntityNameMap.get(answerFileValidationResult.getHost());
            DeferredSettingsValidationResult validationResult = new DeferredSettingsValidationResult(answerFileValidationResult.getValidationResult());
            DeferredPolicyOptionParameter[] policyOptions = deferredPolicyOptionParameterMap.get(answerFileValidationResult.getHost());
            DeferredHostSettingsProviderAdapter.processValidationResults(validationResult, validationMessages, hostName, policyOptions);
        }
        ValidationResult result = new ValidationResult();
        if (!errors.isEmpty()) {
            result.error = new CompositeException(errors);
        }
        result.result = validationMessages.size() > 0 ? validationMessages.values().toArray(new PropertyValidationNode[0]) : new HashMap();
        return result;
    }

    private OperationResult[] applyHostCustomizations(ProfileManager profileManager, Object[] rows, DeferredHostSettingsSpec spec) throws Exception {
        ArrayList<OperationResult> results = new ArrayList<OperationResult>();
        if (!ArrayUtil.isNullOrEmpty((Object[])spec.forceValidationOnHosts)) {
            Collection<OperationResult> validatingHostsResult = this.applyDeferredSettings(rows, profileManager, spec.forceValidationOnHosts, true);
            results.addAll(validatingHostsResult);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])spec.skipValidationOnHosts)) {
            Collection<OperationResult> skipValidationHostsResult = this.applyDeferredSettings(rows, profileManager, spec.skipValidationOnHosts, false);
            results.addAll(skipValidationHostsResult);
        }
        return results.toArray(new OperationResult[results.size()]);
    }

    private Collection<OperationResult> applyDeferredSettings(Object[] rows, ProfileManager profileManager, ManagedObjectReference[] hosts, Boolean validating) throws Exception {
        ArrayList<OperationResult> results = new ArrayList<OperationResult>(hosts.length);
        PropertyValue[] hostsName = this.getEntitiesName(hosts);
        for (ManagedObjectReference host : hosts) {
            OperationResult hostResult = new OperationResult();
            hostResult.entity = host;
            try {
                ProfileManager.AnswerFileOptionsCreateSpec createSpec = new ProfileManager.AnswerFileOptionsCreateSpec();
                createSpec.userInput = DeferredHostSettingsProviderAdapter.convertDeferredSettings(rows, DeferredHostSettingsProviderAdapter.getEntityName(hostsName, host));
                if (!ArrayUtil.isNullOrEmpty((Object[])createSpec.userInput)) {
                    createSpec.validating = validating;
                    hostResult.task = profileManager.updateAnswerFile(host, (ProfileManager.AnswerFileCreateSpec)createSpec);
                }
            }
            catch (Exception e) {
                _logger.warn((Object)"Exception occurred during persistence of deferred host settings ", (Throwable)e);
                hostResult.error = MixedUtil.getMethodFault((Throwable)e);
            }
            results.add(hostResult);
        }
        return results;
    }

    private ValidationResult validateHostCustomizationsOnServerInBatch(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, Object[] rows, PolicyMetadata[] policyMetadata) throws Exception {
        ProfileManager profileManager = null;
        HostApplyProfile applyProfile = null;
        profileManager = HostProfileUtils.getProfileManager(profileRef.getServerGuid());
        applyProfile = DeferredHostSettingsProviderAdapter.getHostApplyProfile(profileRef, spec, policyMetadata);
        ManagedObjectReference[] hosts = spec.forceValidationOnHosts == null ? new ManagedObjectReference[]{} : spec.forceValidationOnHosts;
        Map<ManagedObjectReference, String> hostEntityNameMap = this.createHostEntityNameMap(hosts);
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionParameterMap = this.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
        Object[] arraySpec = this.createHostToConfigSpecMap(deferredPolicyOptionParameterMap, true);
        if (ArrayUtil.isNullOrEmpty((Object[])arraySpec)) {
            return new ValidationResult();
        }
        ProfileManager.AnswerFileValidationResultMap[] results = profileManager.validateHostCustomizations((ProfileManager.HostToConfigSpecMap[])arraySpec, applyProfile);
        return this.createValidationResult(deferredPolicyOptionParameterMap, hostEntityNameMap, results);
    }

    private static HostApplyProfile getHostApplyProfile(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, PolicyMetadata[] policyMetadata) throws Exception {
        HostApplyProfile applyProfile = null;
        if (spec.isNewlyAssociatedProfile) {
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
            applyProfile = ((HostProfile.ConfigInfo)profile.getConfig()).applyProfile;
        }
        if (spec.hostApplyProfileWrapper != null) {
            applyProfile = Unwrapper.unwrap(spec.hostApplyProfileWrapper);
            PostProcessUtil.postProcessProfile(applyProfile, policyMetadata);
        }
        return applyProfile;
    }

    private DynamicObject[] getDeferredHostSettingsInBatch(VcService service, ManagedObjectReference hpRef, DeferredHostSettingsSpec spec, PolicyMetadata[] policiesMetadata, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults, Map<String, String> relevantProfilePaths, List<Exception> faults) throws Exception {
        ProfileManager profileManager;
        HostApplyProfile applyProfile = null;
        try {
            profileManager = HostProfileUtils.getProfileManager(hpRef.getServerGuid());
            applyProfile = DeferredHostSettingsProviderAdapter.getHostApplyProfile(hpRef, spec, policiesMetadata);
        }
        catch (Exception e) {
            _logger.error((Object)"Can not get host customizations of the hosts.", (Throwable)e);
            faults.add(new Exception(HostProfileUtils.getLocalizedString("error.getHostCustomizations")));
            throw e;
        }
        ProfileManager.StructuredCustomizations[] customizations = null;
        customizations = applyProfile != null ? profileManager.retrieveHostCustomizationsForProfile(spec.forceValidationOnHosts, applyProfile) : profileManager.retrieveHostCustomizations(spec.forceValidationOnHosts);
        this.fillDeferredPolicyOptionParametersMap(cachedResults, customizations, faults);
        ArrayList<DynamicObject> resultList = this.extractHostSettings(service, policiesMetadata, relevantProfilePaths, cachedResults, spec.forceValidationOnHosts);
        DynamicObject[] result = new DynamicObject[resultList.size()];
        result = resultList.toArray(result);
        return result;
    }

    private void fillDeferredPolicyOptionParametersMap(Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults, ProfileManager.StructuredCustomizations[] customizations, List<Exception> faults) {
        if (ArrayUtil.isNullOrEmpty((Object[])customizations)) {
            return;
        }
        for (ProfileManager.StructuredCustomizations customization : customizations) {
            Exception fault;
            AnswerFile answerFile = customization.getCustomizations();
            if (answerFile != null && answerFile.userInput != null) {
                cachedResults.put(customization.getEntity(), answerFile.userInput);
                continue;
            }
            if (!(customization instanceof ProfileManager.RetrieveCustomizationsResult) || (fault = ((ProfileManager.RetrieveCustomizationsResult)customization).getFault()) == null) continue;
            _logger.error((Object)"Retrieved host customizations contains error: ", (Throwable)fault);
            faults.add(fault);
        }
    }

    private ArrayList<DynamicObject> extractHostSettings(VcService service, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults, ManagedObjectReference[] hosts) throws Exception {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        Map<ManagedObjectReference, String> hostEntityNameMap = this.createHostEntityNameMap(hosts);
        for (ManagedObjectReference host : hosts) {
            DeferredPolicyOptionParameter[] deferredParameters = cachedResults.get(host);
            String hostName = hostEntityNameMap.get(host);
            if (deferredParameters != null) {
                Collection<DynamicObject> result = this.extractDeferredHostSettings(service, hostName, policiesMetadata, relevantProfilePaths, deferredParameters, null);
                resultList.addAll(result);
                continue;
            }
            _logger.warn((Object)("Execute result is null for host: " + hostName));
        }
        return resultList;
    }

    private Map<ManagedObjectReference, String> createHostEntityNameMap(ManagedObjectReference[] hosts) throws Exception {
        HashMap<ManagedObjectReference, String> map = new HashMap<ManagedObjectReference, String>();
        if (ArrayUtil.isNullOrEmpty((Object[])hosts)) {
            return map;
        }
        PropertyValue[] hostNames = this.getEntitiesName(hosts);
        if (hostNames == null) {
            return map;
        }
        for (PropertyValue name : hostNames) {
            map.put((ManagedObjectReference)name.resourceObject, (String)name.value);
        }
        return map;
    }

    private Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> createDeferredPolicyOptionParameterMap(Object[] rows, Map<ManagedObjectReference, String> hostNames) {
        HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptions = new HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>();
        for (Map.Entry<ManagedObjectReference, String> entity : hostNames.entrySet()) {
            DeferredPolicyOptionParameter[] deferredSettings = DeferredHostSettingsProviderAdapter.convertDeferredSettings(rows, entity.getValue());
            if (deferredSettings == null) continue;
            deferredPolicyOptions.put(entity.getKey(), deferredSettings);
        }
        return deferredPolicyOptions;
    }

    private ProfileManager.HostToConfigSpecMap[] createHostToConfigSpecMap(Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptionsMap, Boolean validating) {
        ArrayList<ProfileManager.HostToConfigSpecMap> specs = new ArrayList<ProfileManager.HostToConfigSpecMap>();
        for (Map.Entry<ManagedObjectReference, DeferredPolicyOptionParameter[]> entity : deferredPolicyOptionsMap.entrySet()) {
            ProfileManager.AnswerFileOptionsCreateSpec answerFileSpec = new ProfileManager.AnswerFileOptionsCreateSpec();
            answerFileSpec.userInput = entity.getValue();
            if (ArrayUtil.isNullOrEmpty((Object[])answerFileSpec.userInput)) continue;
            answerFileSpec.validating = validating;
            ProfileManager.HostToConfigSpecMap hostSpec = new ProfileManager.HostToConfigSpecMap();
            hostSpec.setHost(entity.getKey());
            hostSpec.setConfigSpec((ProfileManager.AnswerFileCreateSpec)answerFileSpec);
            specs.add(hostSpec);
        }
        return specs.toArray(new ProfileManager.HostToConfigSpecMap[0]);
    }

    private OperationResult[] applyHostCustomizationsInBatch(ProfileManager profileManager, Object[] rows, DeferredHostSettingsSpec spec) throws Exception {
        ProfileManager.HostToConfigSpecMap[] validatingHostToConfigSpecs = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])spec.forceValidationOnHosts)) {
            Map<ManagedObjectReference, String> hostEntityNameMap = this.createHostEntityNameMap(spec.forceValidationOnHosts);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptions = this.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
            validatingHostToConfigSpecs = this.createHostToConfigSpecMap(deferredPolicyOptions, true);
        }
        ProfileManager.HostToConfigSpecMap[] skipValidatingHostToConfigSpecs = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])spec.skipValidationOnHosts)) {
            Map<ManagedObjectReference, String> hostEntityNameMap = this.createHostEntityNameMap(spec.skipValidationOnHosts);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> deferredPolicyOptions = this.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
            skipValidatingHostToConfigSpecs = this.createHostToConfigSpecMap(deferredPolicyOptions, false);
        }
        ProfileManager.HostToConfigSpecMap[] allHostToConfigSpecs = null;
        if (validatingHostToConfigSpecs != null && skipValidatingHostToConfigSpecs != null) {
            ArrayList allList = new ArrayList(validatingHostToConfigSpecs.length + skipValidatingHostToConfigSpecs.length);
            Collections.addAll(allList, validatingHostToConfigSpecs);
            Collections.addAll(allList, skipValidatingHostToConfigSpecs);
            allHostToConfigSpecs = allList.toArray(new ProfileManager.HostToConfigSpecMap[allList.size()]);
        }
        if (allHostToConfigSpecs == null && !ArrayUtil.isNullOrEmpty(validatingHostToConfigSpecs)) {
            allHostToConfigSpecs = validatingHostToConfigSpecs;
        }
        if (allHostToConfigSpecs == null && !ArrayUtil.isNullOrEmpty(skipValidatingHostToConfigSpecs)) {
            allHostToConfigSpecs = skipValidatingHostToConfigSpecs;
        }
        if (ArrayUtil.isNullOrEmpty(allHostToConfigSpecs)) {
            return new OperationResult[0];
        }
        OperationResult operationResult = new OperationResult();
        try {
            operationResult.task = profileManager.updateHostCustomizations(allHostToConfigSpecs);
        }
        catch (Exception e) {
            _logger.warn((Object)"Exception occurred during update of customization settings.", (Throwable)e);
            operationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return new OperationResult[]{operationResult};
    }

    private Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> importHostCustomizations(ManagedObjectReference hpRef, ManagedObjectReference[] entities, ProfileManager profileManager, ProfileManager.CustomizationData customizationData, List<Exception> faults) throws Exception {
        HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults = new HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>();
        ManagedObjectReference taskRef = null;
        try {
            taskRef = profileManager.importCustomizations(customizationData, Boolean.valueOf(false), Boolean.valueOf(false), hpRef, entities);
        }
        catch (Exception e) {
            _logger.error((Object)"Import of the host customizations failed.", (Throwable)e);
            Exception exception = new Exception(HostProfileUtils.getLocalizedString("error.importCustomizations.method"));
            faults.add(exception);
            return cachedResults;
        }
        TaskInfo taskInfo = null;
        taskInfo = this._taskMonitor.monitorTask(taskRef);
        if (taskInfo.error != null) {
            Exception exception = new Exception(HostProfileUtils.getLocalizedString("error.importCustomizations.operation"));
            faults.add(exception);
            MethodFault fault = MixedUtil.getMethodFault((Throwable)taskInfo.error);
            _logger.error((Object)"Import host customizations task failed.", fault.getCause());
            faults.add((Exception)fault);
            return cachedResults;
        }
        ProfileManager.ImportCustomizationsResult importResult = (ProfileManager.ImportCustomizationsResult)taskInfo.result;
        if (importResult != null && !ArrayUtil.isNullOrEmpty((Object[])importResult.entityResults)) {
            for (ProfileManager.ImportCustomizationsResult.EntityCustomizationsResult entity : importResult.entityResults) {
                AnswerFile answerFile = entity.customizations;
                if (answerFile == null) continue;
                cachedResults.put(entity.entity, answerFile.userInput);
            }
        }
        if (importResult != null && importResult.importIssues != null) {
            this.addImportIssues(importResult, faults);
        }
        return cachedResults;
    }

    private void addImportIssues(ProfileManager.ImportCustomizationsResult importResult, List<Exception> importFaults) {
        HostCustomizationImportException importException = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])importResult.importIssues.errors)) {
            importException = new HostCustomizationImportException();
            importException.errorMessages = importResult.importIssues.errors;
            importFaults.add(importException);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])importResult.importIssues.warnings)) {
            if (importException == null) {
                importException = new HostCustomizationImportException();
                importException.warningMessages = importResult.importIssues.warnings;
                importFaults.add(importException);
            } else {
                importException.warningMessages = importResult.importIssues.warnings;
            }
        }
    }

    private ProfileManager.CustomizationData createCustomizationData(String formattedCustomizations) {
        ProfileManager.CustomizationData customizationData = new ProfileManager.CustomizationData();
        customizationData.setCustomizationsFormat(CSV_CUSTOMIZATION_FORMAT);
        ProfileManager.FormattedCustomizations customizations = new ProfileManager.FormattedCustomizations();
        customizations.format = CSV_CUSTOMIZATION_FORMAT;
        customizations.formattedCustomizations = formattedCustomizations;
        customizationData.setEntityCustomizations(new ProfileManager.EntityCustomizations[]{customizations});
        return customizationData;
    }

    private DynamicObject[] getDeferredHostSettingsFromImportResults(Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> importResults, VcService service, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, ManagedObjectReference[] hosts, Object[] hostCustomizationsBeforeImport) throws Exception {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        Map<ManagedObjectReference, String> hostEntityNameMap = this.createHostEntityNameMap(hosts);
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> beforeImportCustomizationsMap = null;
        for (ManagedObjectReference host : hosts) {
            Collection<DynamicObject> result;
            String hostName = hostEntityNameMap.get(host);
            DeferredPolicyOptionParameter[] deferredParameters = importResults.get(host);
            if (beforeImportCustomizationsMap == null) {
                beforeImportCustomizationsMap = this.createDeferredPolicyOptionParameterMap(hostCustomizationsBeforeImport, hostEntityNameMap);
            }
            DeferredPolicyOptionParameter[] currentDeferredParameters = (DeferredPolicyOptionParameter[])beforeImportCustomizationsMap.get(host);
            if (deferredParameters != null) {
                result = this.extractDeferredHostSettings(service, hostName, policiesMetadata, relevantProfilePaths, deferredParameters, currentDeferredParameters);
                resultList.addAll(result);
                continue;
            }
            _logger.warn((Object)("Can not extract imported deferred host settings on " + hostName));
            if (currentDeferredParameters == null) continue;
            result = this.extractDeferredHostSettings(service, hostName, policiesMetadata, relevantProfilePaths, currentDeferredParameters, null);
            importResults.put(host, currentDeferredParameters);
            resultList.addAll(result);
        }
        return resultList.toArray(new DynamicObject[resultList.size()]);
    }

    private boolean isBulkAnswerFileEnabled(ManagedObjectReference entity) throws Exception {
        try {
            return (Boolean)this._queryExecutor.getProperty((Object)entity, "isBulkAnswerFileEnabled");
        }
        catch (Exception e) {
            _logger.error((Object)"Can't retrieve 'isBulkAnswerFileEnabled' property", (Throwable)e);
            throw e;
        }
    }

    private boolean isParallelOperationsEnabled(ManagedObjectReference entity) throws Exception {
        try {
            return (Boolean)this._queryExecutor.getProperty((Object)entity, "isParallelOperationsEnabled");
        }
        catch (Exception e) {
            _logger.error((Object)"Can't retrieve 'isParallelOperationsEnabled' property", (Throwable)e);
            throw e;
        }
    }

    public HostApplyConfigSpecData readHostApplyConfigSpecs(ManagedObjectReference[] hosts, Object[] rows) {
        HostApplyConfigSpecData applyConfigSpecs = new HostApplyConfigSpecData();
        applyConfigSpecs.faults = new ArrayList<Exception>();
        applyConfigSpecs.hostApplyConfigMap = new HashMap<ManagedObjectReference, ProfileManager.ApplyHostConfigSpec>();
        try {
            ProfileManager profileManger = this.getProfileManager(hosts);
            Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap = this.getDeferredPolicyOptionParameterMap(profileManger, hosts, rows, applyConfigSpecs.faults);
            if (applyConfigSpecs.faults.size() > 0) {
                _logger.error((Object)"Can't read host apply config specs, the return host customizations have errors.");
                return applyConfigSpecs;
            }
            return this.createHostApplyConfigSpecData(profileManger, hosts, userInputMap);
        }
        catch (Exception e) {
            applyConfigSpecs.faults.add((Exception)MixedUtil.getMethodFault((Throwable)e));
            return applyConfigSpecs;
        }
    }

    private Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> getDeferredPolicyOptionParameterMap(ProfileManager profileManger, ManagedObjectReference[] hosts, Object[] rows, List<Exception> faults) throws Exception {
        HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap;
        if (rows != null) {
            Map<ManagedObjectReference, String> hostEntityNameMap = this.createHostEntityNameMap(hosts);
            userInputMap = this.createDeferredPolicyOptionParameterMap(rows, hostEntityNameMap);
        } else {
            ProfileManager.StructuredCustomizations[] customizations = profileManger.retrieveHostCustomizations(hosts);
            userInputMap = new HashMap();
            this.fillDeferredPolicyOptionParametersMap(userInputMap, customizations, faults);
        }
        return userInputMap;
    }

    private ProfileManager getProfileManager(ManagedObjectReference[] hosts) throws Exception {
        ProfileManager profileManager = null;
        for (ManagedObjectReference host : hosts) {
            try {
                profileManager = HostProfileUtils.getProfileManager(host.getServerGuid());
                break;
            }
            catch (Exception e) {
                _logger.warn((Object)"Can't get profile manager", (Throwable)e);
            }
        }
        if (profileManager == null) {
            String errMsg = HostProfileUtils.getLocalizedString("error.readHostConfigurations");
            throw new Exception(errMsg);
        }
        return profileManager;
    }

    private HostApplyConfigSpecData createHostApplyConfigSpecData(ProfileManager profileManager, ManagedObjectReference[] hosts, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap) {
        ProfileManager.ApplyHostConfigSpec[] applyHostConfigSpecs;
        HostApplyConfigSpecData applyConfigSpecs = new HostApplyConfigSpecData();
        applyConfigSpecs.faults = new ArrayList<Exception>();
        applyConfigSpecs.hostApplyConfigMap = new HashMap<ManagedObjectReference, ProfileManager.ApplyHostConfigSpec>();
        for (ProfileManager.ApplyHostConfigSpec applyHostConfigSpec : applyHostConfigSpecs = this.generateHostApplyConfigSpecs(profileManager, hosts, userInputMap, applyConfigSpecs.faults)) {
            applyConfigSpecs.hostApplyConfigMap.put(applyHostConfigSpec.getHost(), applyHostConfigSpec);
        }
        return applyConfigSpecs;
    }

    private ProfileManager.ApplyHostConfigSpec[] generateHostApplyConfigSpecs(ProfileManager profileManager, ManagedObjectReference[] hosts, Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap, List<Exception> faults) {
        MethodFault methodFault;
        Object[] applyHostConfigSpecs = new ProfileManager.ApplyHostConfigSpec[]{};
        if (ArrayUtil.isNullOrEmpty((Object[])hosts)) {
            return applyHostConfigSpecs;
        }
        ProfileManager.StructuredCustomizations[] hostCustomizationSpecs = new ProfileManager.StructuredCustomizations[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            ManagedObjectReference hostRef = hosts[i];
            ProfileManager.StructuredCustomizations hostCustomizationSpec = new ProfileManager.StructuredCustomizations();
            hostCustomizationSpec.setEntity(hostRef);
            this.addCustomizations(userInputMap, hostRef, hostCustomizationSpec);
            hostCustomizationSpecs[i] = hostCustomizationSpec;
        }
        try {
            ManagedObjectReference preCheckRemediateTask = profileManager.generateHostConfigTaskSpec(hostCustomizationSpecs);
            TaskInfo taskInfo = this._taskMonitor.monitorTask(preCheckRemediateTask);
            if (taskInfo.error != null) {
                _logger.error((Object)"Pre-check remediate task finished with error.", (Throwable)taskInfo.error);
                MethodFault methodFault2 = MixedUtil.getMethodFault((Throwable)taskInfo.error);
                faults.add((Exception)methodFault2);
            }
            applyHostConfigSpecs = (ProfileManager.ApplyHostConfigSpec[])taskInfo.result;
        }
        catch (Exception e) {
            _logger.error((Object)"Can't generate generateHostConfigTaskSpec", (Throwable)e);
            methodFault = MixedUtil.getMethodFault((Throwable)e);
            faults.add((Exception)methodFault);
            return applyHostConfigSpecs;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])applyHostConfigSpecs)) {
            _logger.error((Object)"Return generateHostConfigTaskSpec result is empty");
            String errMsg = HostProfileUtils.getLocalizedString("deferredSettings.errorReadHostApplyConfig");
            methodFault = MixedUtil.getMethodFault((Throwable)new Exception(errMsg));
            faults.add((Exception)methodFault);
        }
        return applyHostConfigSpecs;
    }

    private void addCustomizations(Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap, ManagedObjectReference hostRef, ProfileManager.StructuredCustomizations hostCustomizationSpec) {
        if (userInputMap == null) {
            return;
        }
        Object[] deferredParams = userInputMap.get(hostRef);
        if (!ArrayUtil.isNullOrEmpty((Object[])deferredParams)) {
            AnswerFile customizations = new AnswerFile();
            customizations.setUserInput((DeferredPolicyOptionParameter[])deferredParams);
            customizations.setCreatedTime(Calendar.getInstance());
            customizations.setModifiedTime(Calendar.getInstance());
            hostCustomizationSpec.setCustomizations(customizations);
        }
    }

    private static ManagedObjectReference[] getManagedObjectReferences(Object[] objects, String simpleClassName) {
        ArrayList<ManagedObjectReference> entityList = new ArrayList<ManagedObjectReference>();
        for (Object object : objects) {
            if (!(object instanceof ManagedObjectReference)) continue;
            ManagedObjectReference reference = (ManagedObjectReference)object;
            if (simpleClassName != null && !simpleClassName.equals(reference.getType())) continue;
            entityList.add(reference);
        }
        return entityList.toArray(new ManagedObjectReference[entityList.size()]);
    }
}

