/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vsphere.client.hostprofile.impl.MissingTypeData;
import com.vmware.vsphere.client.hostprofile.impl.ProcessUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MissingTypeUtil {
    private static final String ARRAY_OF_STRING_TYPE = "ArrayOfString";
    private static final String ANY_TYPE_TYPE = "anyType";
    private static final Log _logger = LogFactory.getLog(MissingTypeUtil.class);

    public static List<MissingTypeData> extractMissingTypeData(PolicyMetadata meta, Policy policy) {
        ArrayList<MissingTypeData> result = new ArrayList<MissingTypeData>();
        if (!ProcessUtil.hasValidPossibleOption(meta) || !ProcessUtil.hasValidOptionParam(policy)) {
            return result;
        }
        PolicyOptionMetadata activePolicyMeta = ProcessUtil.getActivePolicyOptionMeta(policy, meta);
        List<ParameterMetadata> missingTypeMeta = MissingTypeUtil.extractMissingTypeParams(activePolicyMeta);
        List<KeyAnyValue> missingTypePolicyParams = MissingTypeUtil.extractParamsMatchingMeta(missingTypeMeta, policy);
        for (KeyAnyValue param : missingTypePolicyParams) {
            MissingTypeData mtd = new MissingTypeData();
            mtd.policyId = policy.id;
            mtd.policyOptionId = activePolicyMeta.id.key;
            mtd.paramId = param.getKey();
            mtd.valueType = MissingTypeUtil.getPolicyParamValueType(param);
            result.add(mtd);
        }
        return result;
    }

    public static void restoreMissingTypes(Object profileObj, MissingTypeData[] missingTypeData) {
        if (!(profileObj instanceof ApplyProfile)) {
            return;
        }
        ApplyProfile result = (ApplyProfile)profileObj;
        if (result == null || result.policy == null || missingTypeData == null) {
            return;
        }
        for (MissingTypeData mtd : missingTypeData) {
            for (Policy policy : result.policy) {
                KeyAnyValue param = MissingTypeUtil.getMatchingParam(mtd, policy);
                if (param == null) continue;
                param.setValue(MissingTypeUtil.convertValue(param.getValue(), mtd.valueType));
            }
        }
    }

    private static List<KeyAnyValue> extractParamsMatchingMeta(List<ParameterMetadata> paramsMeta, Policy policy) {
        assert (paramsMeta != null);
        assert (ProcessUtil.hasValidOptionParam(policy));
        ArrayList<KeyAnyValue> result = new ArrayList<KeyAnyValue>();
        for (ParameterMetadata paramMeta : paramsMeta) {
            if (!ProcessUtil.isValidParam(paramMeta)) continue;
            for (KeyAnyValue param : policy.policyOption.parameter) {
                if (!ProcessUtil.isValidKeyAnyValue(param) || !MissingTypeUtil.hasEqualKey(paramMeta, param.getKey())) continue;
                result.add(param);
            }
        }
        return result;
    }

    private static List<ParameterMetadata> extractMissingTypeParams(PolicyOptionMetadata pom) {
        ArrayList<ParameterMetadata> result = new ArrayList<ParameterMetadata>();
        for (ParameterMetadata parMeta : pom.parameter) {
            if (!ProcessUtil.isValidParam(parMeta) || !MissingTypeUtil.isMissingTypeParam(parMeta)) continue;
            result.add(parMeta);
        }
        return result;
    }

    private static String getPolicyParamValueType(KeyAnyValue param) {
        assert (ProcessUtil.isValidKeyAnyValue(param));
        Class<?> clazz = param.getValue().getClass();
        Object value = param.getValue();
        if (value instanceof String[]) {
            return ARRAY_OF_STRING_TYPE;
        }
        return clazz.getCanonicalName();
    }

    private static boolean isMissingTypeParam(ParameterMetadata paramMeta) {
        assert (ProcessUtil.isValidParam(paramMeta));
        return ANY_TYPE_TYPE.equalsIgnoreCase(paramMeta.type.toString());
    }

    private static boolean hasEqualKey(ParameterMetadata paramMeta, String key) {
        if (!ProcessUtil.isValidKeyParam(paramMeta) || key == null) {
            return false;
        }
        return paramMeta.id.key.equalsIgnoreCase(key);
    }

    private static Object convertValue(Object value, String valueType) {
        if (value == null || valueType == null) {
            return null;
        }
        if (MissingTypeUtil.isLong(valueType)) {
            try {
                return Long.parseLong(value.toString());
            }
            catch (Exception exc) {
                _logger.error((Object)("Long.parseLong failed for " + value), (Throwable)exc);
                return value;
            }
        }
        return value;
    }

    private static boolean isLong(String valueType) {
        assert (valueType != null);
        return Long.TYPE.getCanonicalName().equalsIgnoreCase(valueType) || Long.class.getCanonicalName().equalsIgnoreCase(valueType);
    }

    private static KeyAnyValue getMatchingParam(MissingTypeData mtd, Policy policy) {
        if (!ProcessUtil.hasValidOptionId(policy)) {
            return null;
        }
        if (!policy.id.equalsIgnoreCase(mtd.policyId) || !policy.policyOption.id.equalsIgnoreCase(mtd.policyOptionId)) {
            return null;
        }
        for (KeyAnyValue param : policy.policyOption.parameter) {
            if (!ProcessUtil.isValidKeyAnyValue(param) || !param.getKey().equalsIgnoreCase(mtd.paramId)) continue;
            return param;
        }
        return null;
    }
}

