/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.StringUtil;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProfileNameUtil {
    public static final String EMPTY_NAME = "";
    public static final Pattern REGEX_POLICY = Pattern.compile("(?<=\\{\\s{0,2048}policy\\[')[^\\]\\[}{]+(?='\\].policyOption.parameter\\['[^\\]\\[}{]+'\\]\\s{0,2048}})");
    public static final Pattern REGEX_POLICY_OPTION = Pattern.compile("(?<=\\{\\s{0,2048}policy\\['[^\\]\\[}{]{0,2048}\\].policyOption.parameter\\[')[^\\]\\[}{]+(?='\\]\\s{0,2048}})");
    public static final Pattern REGEX_PROPERTY_PATH = Pattern.compile("(?<=\\{\\s{0,2048})[\\w-_.]+(?=\\s{0,2048}})");

    private ProfileNameUtil() {
    }

    public static String tryToGetNameFromPolicyOption(ApplyProfile ap, String profileLabel) {
        String name;
        if (ap == null) {
            return EMPTY_NAME;
        }
        try {
            name = ProfileNameUtil.getNameFromPolicyOption(ap, profileLabel);
        }
        catch (Exception t) {
            name = EMPTY_NAME;
        }
        if (ProfileNameUtil.isNullOrEmpty(name)) {
            return ProfileNameUtil.getDefaultName(ap);
        }
        return name;
    }

    private static String getNameFromPolicyOption(ApplyProfile ap, String profileLabel) throws Exception {
        if (ProfileNameUtil.isNullOrEmpty(profileLabel)) {
            return EMPTY_NAME;
        }
        String result = EMPTY_NAME;
        String[] nameSplit = profileLabel.split(":");
        for (int splitCount = 0; splitCount < nameSplit.length; ++splitCount) {
            result = result + ProfileNameUtil.tryToGetNameFromPolicyOptionParameter(ap, nameSplit[splitCount]) + " : ";
        }
        result = result.substring(0, result.lastIndexOf(" : "));
        result = ProfileNameUtil.unescapeSpecialCharacters(result);
        return result;
    }

    private static String unescapeSpecialCharacters(String input) {
        String result = input;
        if (!StringUtil.isNullOrEmpty((String)result)) {
            result = result.replace("%25", "%");
            result = result.replace("%2f", "/");
            result = result.replace("%2F", "/");
            result = result.replace("%5c", "\\");
            result = result.replace("%5C", "\\");
        }
        return result;
    }

    private static String tryToGetNameFromPolicyOptionParameter(ApplyProfile profile, String label) throws Exception {
        if (!label.contains("{")) {
            return label;
        }
        String defaultName = ProfileNameUtil.trimPlaceholders(label);
        String policyId = ProfileNameUtil.getMatch(REGEX_POLICY, label);
        String paramId = ProfileNameUtil.getMatch(REGEX_POLICY_OPTION, label);
        if (ProfileNameUtil.isNullOrEmpty(policyId) || ProfileNameUtil.isNullOrEmpty(paramId)) {
            return ProfileNameUtil.getProfileNameFromPropertyPath(profile, label);
        }
        Policy policy = ProfileNameUtil.getPolicyById(profile, policyId);
        if (policy == null) {
            return ProfileNameUtil.trimPlaceholders(label);
        }
        KeyAnyValue kv = ProfileNameUtil.getPolicyOptionParameterById(policy, paramId);
        String result = ProfileNameUtil.processPolicyOptionParameter(kv);
        if (StringUtil.isNullOrEmpty((String)result)) {
            result = defaultName;
        }
        return result;
    }

    private static String processPolicyOptionParameter(KeyAnyValue kv) {
        if (kv == null || kv.getValue() == null) {
            return EMPTY_NAME;
        }
        if (String[].class.isAssignableFrom(kv.getValue().getClass())) {
            String[] strArray;
            StringBuilder val = new StringBuilder();
            for (String v : strArray = (String[])kv.getValue()) {
                val.append(v + ",");
            }
            String result = val.toString();
            result = result.substring(0, result.lastIndexOf(44));
            return result;
        }
        return kv.getValue().toString();
    }

    private static Policy getPolicyById(ApplyProfile ap, String policyId) {
        for (Policy p : ap.policy) {
            if (!p.id.equalsIgnoreCase(policyId)) continue;
            return p;
        }
        return null;
    }

    private static KeyAnyValue getPolicyOptionParameterById(Policy policy, String paramId) {
        if (policy == null || policy.policyOption == null || policy.policyOption.parameter == null) {
            return null;
        }
        for (KeyAnyValue kv : policy.policyOption.parameter) {
            if (!kv.getKey().equalsIgnoreCase(paramId)) continue;
            return kv;
        }
        return null;
    }

    private static String getMatch(Pattern pattern, String label) {
        Matcher policyIdMatch = pattern.matcher(label);
        if (policyIdMatch.find()) {
            return policyIdMatch.group(0);
        }
        return EMPTY_NAME;
    }

    private static String getProfileNameFromPropertyPath(ApplyProfile profile, String label) throws Exception {
        String propertyPath = ProfileNameUtil.getMatch(REGEX_PROPERTY_PATH, label);
        if (ProfileNameUtil.isNullOrEmpty(propertyPath)) {
            return EMPTY_NAME;
        }
        String[] propertyNames = propertyPath.split("\\.");
        Object propVal = profile;
        for (String propName : propertyNames) {
            propVal = ProfileNameUtil.getPropertyValue(propVal, propName);
        }
        if (propVal != null) {
            return propVal.toString();
        }
        return EMPTY_NAME;
    }

    private static Object getPropertyValue(Object obj, String propName) throws Exception {
        if (obj == null || ProfileNameUtil.isNullOrEmpty(propName)) {
            return null;
        }
        Field propInfo = null;
        for (Field f : obj.getClass().getFields()) {
            if (!f.getName().equalsIgnoreCase(propName)) continue;
            propInfo = f;
            break;
        }
        if (propInfo != null) {
            return propInfo.get(obj);
        }
        return null;
    }

    private static String getDefaultName(ApplyProfile ap) {
        return ap.getClass() == ApplyProfile.class ? ap.profileTypeName : ap.getClass().getName();
    }

    static String trimPlaceholders(String label) {
        if (ProfileNameUtil.isNullOrEmpty(label)) {
            return EMPTY_NAME;
        }
        int startIndex = label.indexOf(123);
        int endIndex = label.lastIndexOf(125);
        if (startIndex == -1 || endIndex == -1) {
            return label.trim();
        }
        String result = label.substring(0, startIndex) + label.substring(endIndex + 1);
        return result.trim();
    }

    public static boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() == 0;
    }
}

