/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ApplyProfileProperty;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.hostprofile.impl.MetadataAdapter;
import com.vmware.vsphere.client.hostprofile.impl.PostProcessUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProcessUtil;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilePostProcessor {
    private static final Log _logger = LogFactory.getLog(ProfilePostProcessor.class);
    private MetadataAdapter _adapter;

    public ProfilePostProcessor(PolicyMetadata[] policyMeta) {
        this._adapter = new MetadataAdapter(policyMeta);
    }

    public void process(HostApplyProfile ap) throws Exception {
        this.processApplyProfile((ApplyProfile)ap);
    }

    private void processApplyProfile(ApplyProfile profile) throws Exception {
        Field[] profileFields;
        if (profile == null) {
            return;
        }
        Class<?> hostApplyProfileClass = profile.getClass();
        for (Field field : profileFields = hostApplyProfileClass.getFields()) {
            if (!ProcessUtil.isTraversableField(field).booleanValue()) continue;
            Class<?> fieldType = field.getType();
            Object fieldVallue = field.get(profile);
            if (Policy[].class.isAssignableFrom(fieldType)) {
                this.processPolicies((Policy[])fieldVallue);
                continue;
            }
            if (ApplyProfile.class.isAssignableFrom(fieldType)) {
                this.processApplyProfile((ApplyProfile)fieldVallue);
                continue;
            }
            if (ApplyProfile[].class.isAssignableFrom(fieldType)) {
                if (fieldVallue == null) continue;
                this.processApplyProfileArray((ApplyProfile[])fieldVallue);
                continue;
            }
            if (!ApplyProfileProperty[].class.isAssignableFrom(fieldType)) continue;
            this.processProperty((ApplyProfileProperty[])fieldVallue);
        }
    }

    private void processPolicies(Policy[] policies) {
        if (policies == null) {
            return;
        }
        block0: for (Policy policy : policies) {
            PolicyOptionMetadata poMeta;
            PolicyMetadata meta;
            if (!ProcessUtil.hasValidOptionParam(policy) || !ProcessUtil.hasValidPossibleOption(meta = this._adapter.getPolicyMeta(policy)) || !ProcessUtil.hasValidParam(poMeta = ProcessUtil.getActivePolicyOptionMeta(policy, meta))) continue;
            for (ParameterMetadata parMeta : poMeta.parameter) {
                if (!ProcessUtil.isValidParam(parMeta)) continue;
                if (ProcessUtil.isComplexTypeParamMeta(parMeta)) {
                    policy.policyOption.parameter = PostProcessUtil.convertToSingleParam(policy.policyOption.parameter, parMeta);
                    continue block0;
                }
                Class<?> parType = ProfilePostProcessor.tryToGetParameterType(parMeta);
                if (parType == null) continue;
                if (parType.equals(String[].class)) {
                    PostProcessUtil.convertStringArray(policy, parMeta);
                    continue;
                }
                if (!parType.equals(Long.class)) continue;
                PostProcessUtil.convertLongValues(policy, parMeta);
            }
        }
    }

    private static Class<?> tryToGetParameterType(ParameterMetadata parMeta) {
        if (parMeta == null || parMeta.type == null || StringUtil.isNullOrEmpty((String)parMeta.type.getName())) {
            return null;
        }
        try {
            return Class.forName(parMeta.type.getName());
        }
        catch (Exception e) {
            _logger.error((Object)"tryToGetParameterType failed", (Throwable)e);
            return null;
        }
    }

    private void processProperty(ApplyProfileProperty[] properties) throws Exception {
        if (properties == null) {
            return;
        }
        for (ApplyProfileProperty property : properties) {
            if (property.profile == null) continue;
            for (ApplyProfile profile : property.profile) {
                this.processApplyProfile(profile);
            }
        }
    }

    private void processApplyProfileArray(ApplyProfile[] profiles) throws Exception {
        if (profiles == null) {
            return;
        }
        for (ApplyProfile profile : profiles) {
            this.processApplyProfile(profile);
        }
    }
}

