/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import java.util.ArrayList;
import java.util.List;

public class ProfileWrapperUtil {
    public static void patchHostApplyProfileWrapperToBeMerged(ProfileWrapper rootProfileWrapper, boolean select) {
        if (rootProfileWrapper == null) {
            return;
        }
        List<ProfileWrapper> rootMostToBeMergedProfileWrappers = ProfileWrapperUtil.findRootMostToBeMergedProfileWrappers(rootProfileWrapper);
        for (ProfileWrapper profileWrapper : rootMostToBeMergedProfileWrappers) {
            ProfileWrapperUtil.setToBeMergedRecursive(profileWrapper, select, true);
        }
    }

    private static List<ProfileWrapper> findRootMostToBeMergedProfileWrappers(ProfileWrapper rootProfileWrapper) {
        ArrayList<ProfileWrapper> result = new ArrayList<ProfileWrapper>();
        ArrayList<Object> profileWrapperQueue = new ArrayList<Object>();
        profileWrapperQueue.add((Object)rootProfileWrapper);
        while (profileWrapperQueue.size() > 0) {
            Object head = profileWrapperQueue.remove(0);
            if (!(head instanceof ProfileWrapper)) continue;
            ProfileWrapper pwHead = (ProfileWrapper)((Object)head);
            if (pwHead.obj instanceof ApplyProfile && Boolean.TRUE.equals(((ApplyProfile)pwHead.obj).toBeMerged)) {
                result.add(pwHead);
                continue;
            }
            if (pwHead.children == null) continue;
            profileWrapperQueue.addAll(pwHead.children);
        }
        return result;
    }

    private static void setToBeMergedRecursive(ProfileWrapper rootProfileWrapper, boolean selected, boolean skipRoot) {
        ArrayList<Object> profileWrapperQueue = new ArrayList<Object>();
        profileWrapperQueue.add((Object)rootProfileWrapper);
        while (profileWrapperQueue.size() > 0) {
            Object head = profileWrapperQueue.remove(0);
            if (!(head instanceof ProfileWrapper)) continue;
            ProfileWrapper pwHead = (ProfileWrapper)((Object)head);
            if ((pwHead != rootProfileWrapper || !skipRoot) && pwHead.obj instanceof ApplyProfile) {
                ((ApplyProfile)pwHead.obj).toBeMerged = selected;
            }
            if (pwHead.children == null) continue;
            profileWrapperQueue.addAll(pwHead.children);
        }
    }
}

