/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.google.common.base.Function;
import com.vmware.vsphere.telemetry.cmc.ContainsErrorInfo;
import java.io.File;

public final class CollectedFile
extends ContainsErrorInfo {
    private final File _file;
    private final Function<CollectedFile, Void> _disposeAction;

    private CollectedFile(File file, Exception collectorError, boolean fatalError, Function<CollectedFile, Void> disposeAction) {
        super(collectorError, fatalError);
        this._file = file;
        this._disposeAction = disposeAction;
    }

    public File getFile() {
        return this._file;
    }

    public void dispose() {
        if (this._disposeAction != null) {
            this._disposeAction.apply((Object)this);
        }
    }

    private static final class DeleteDisposer
    implements Function<CollectedFile, Void> {
        private DeleteDisposer() {
        }

        public Void apply(CollectedFile input) {
            if (input.getFile() != null) {
                input.getFile().delete();
            }
            return null;
        }
    }

    public static final class Builder
    extends ContainsErrorInfo.Builder<Builder> {
        private File _file;
        private Function<CollectedFile, Void> _disposeAction;

        public Builder(File file) {
            this._file = file;
        }

        public Builder() {
            this(null);
        }

        public Builder setFile(File file) {
            this._file = file;
            return this;
        }

        public Builder onDisposeDelete() {
            this._disposeAction = new DeleteDisposer();
            return this;
        }

        public CollectedFile build() {
            return new CollectedFile(this._file, this._error, this._fatal, this._disposeAction);
        }
    }
}

