/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.vmware.ph.CollectionConfiguration;
import com.vmware.ph.ConfigirationException;
import com.vmware.ph.ScheduleConfiguration;
import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.DsSessionSimulatorImpl;
import com.vmware.ph.ceip.authentication.InitializationException;
import com.vmware.ph.ceip.authentication.SessionSimulationException;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.sso.client.exception.SsoRuntimeException;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.ceip.util.Utils;
import com.vmware.vsphere.telemetry.cmc.CollectorOutcome;
import com.vmware.vsphere.telemetry.cmc.PhUsageDataCollector;
import com.vmware.vsphere.telemetry.cmc.PlatformClientFactory;
import com.vmware.vsphere.telemetry.cmc.schedule.ScheduleCalculator;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectorAction
implements Callable<CollectorOutcome> {
    private static final String ERROR_SOURCE_DS = "Data";
    private static final String ERROR_SOURCE_SSO = "SSO";
    private static final String ERROR_REASON_INIT = "configuration initialization";
    private static final String ERROR_REASON_LOGIN = "acquire token";
    private static final String ERROR_REASON_PEER_SERVICE = "call to peer service";
    private static final String ERROR_REASON_CREATE_SESSION = "session creation";
    private static final Logger logger = LoggerFactory.getLogger(CollectorAction.class);
    private final DataService _dataService;
    private final PhUsageDataCollector _collector;
    private final CeipConfigProvider _ceipConfigProvider;
    private final DsSessionSimulator _sessionSimulator;
    private final SolutionUserAuthenticationConfig _authConfig;
    private final CollectionCoordinator _collectionCoordinator;

    public CollectorAction(PlatformClientFactory platformClientFactory, DataService dataService, PhUsageDataCollector collector, CeipConfigProvider ceipConfigProvider, DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig authConfig) {
        this(new CollectionCoordinator(platformClientFactory), dataService, collector, ceipConfigProvider, sessionSimulator, authConfig);
    }

    CollectorAction(CollectionCoordinator collectionCoordinator, DataService dataService, PhUsageDataCollector collector, CeipConfigProvider ceipConfigProvider, DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig authConfig) {
        this._collectionCoordinator = collectionCoordinator;
        this._dataService = dataService;
        this._collector = collector;
        this._ceipConfigProvider = ceipConfigProvider;
        this._sessionSimulator = sessionSimulator;
        this._authConfig = authConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectorOutcome call() {
        logger.debug("Starting the collection action.");
        HttpServletRequest request = null;
        try {
            request = this._sessionSimulator.simulate(this._authConfig, "collector_action_solution_user_actor_simulation");
            this._collectionCoordinator.recordFirstBootTime(System.currentTimeMillis());
            VcService targetVc = this.findTargetVcService();
            logger.info("VcService successfully found. Proceeding with data collection.");
            CollectorOutcome collectorOutcome = this.runCollectorIfScheduled(targetVc);
            return collectorOutcome;
        }
        catch (InitializationException e) {
            this.logPeerServiceError(ERROR_SOURCE_DS, ERROR_REASON_INIT, (Exception)((Object)e));
            CollectorOutcome collectorOutcome = CollectorOutcome.LOCAL_ERROR;
            return collectorOutcome;
        }
        catch (DsSessionSimulatorImpl.ServiceInitializationException e) {
            this.logPeerServiceError(ERROR_SOURCE_DS, ERROR_REASON_PEER_SERVICE, (Exception)((Object)e));
            CollectorOutcome collectorOutcome = CollectorOutcome.LOCAL_ERROR;
            return collectorOutcome;
        }
        catch (SsoRuntimeException e) {
            this.logPeerServiceError(ERROR_SOURCE_SSO, ERROR_REASON_LOGIN, (Exception)((Object)e));
            CollectorOutcome collectorOutcome = CollectorOutcome.LOCAL_ERROR;
            return collectorOutcome;
        }
        catch (SessionSimulationException e) {
            this.logPeerServiceError(ERROR_SOURCE_DS, ERROR_REASON_CREATE_SESSION, (Exception)((Object)e));
            CollectorOutcome collectorOutcome = CollectorOutcome.LOCAL_ERROR;
            return collectorOutcome;
        }
        finally {
            logger.debug("Destroying session.");
            this._sessionSimulator.close(request);
        }
    }

    private CollectorOutcome runCollectorIfScheduled(VcService targetVc) {
        boolean collectorEnabled = this._ceipConfigProvider.isCeipEnabled();
        if (!collectorEnabled) {
            logger.info("Skipping collection because usage data collector is not enabled.");
            return CollectorOutcome.PASSED;
        }
        logger.info("CEIP status: enabled. Will check if it is time to collect.");
        try {
            CollectorOutcome outcome;
            boolean timeToFire = this._collectionCoordinator.isItTimeToFire();
            if (timeToFire) {
                logger.info("It is time to run the data collection.");
                outcome = this._collector.collect(this._dataService, targetVc);
                this._collectionCoordinator.setLastCollectionTime(System.currentTimeMillis());
            } else {
                logger.info("Data collector doesn't yet need to run.");
                outcome = CollectorOutcome.PASSED;
            }
            return outcome;
        }
        catch (ConfigirationException e) {
            logger.warn("Error reading schedule configuration: " + e.getMessage(), (Throwable)e);
            return CollectorOutcome.LOCAL_ERROR;
        }
        catch (NoPermission e) {
            logger.error("Collector solution user lacks the required permissions to set default vCenter configuration.", (Throwable)e);
            return CollectorOutcome.LOCAL_ERROR;
        }
    }

    private VcService findTargetVcService() {
        logger.info("findTargetVcService taking it from VimSessionUtil.getLinkedVcGroupRegistry()");
        LinkedVcGroupRegistry vcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        return Utils.getVcService((LinkedVcGroupRegistry)vcGroupRegistry);
    }

    private void logPeerServiceError(String sourceService, String reason, Exception e) {
        logger.error("{} Service error while running usage data collector: {} failed.", new Object[]{sourceService, reason, e});
    }

    static class CollectionCoordinator {
        private final PlatformClientFactory _platformClientFactory;
        private final ScheduleCalculator _scheduleCalc;
        private final SimpleDateFormat _formatter;

        public CollectionCoordinator(PlatformClientFactory platformClientFactory) {
            this(platformClientFactory, new ScheduleCalculator());
        }

        CollectionCoordinator(PlatformClientFactory platformClientFactory, ScheduleCalculator scheduleCalc) {
            this._platformClientFactory = platformClientFactory;
            this._scheduleCalc = scheduleCalc;
            this._formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this._formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void recordFirstBootTime(long firstBootTime) {
            CollectionConfiguration collectionConfiguration = this._platformClientFactory.createCollectionConfiguration();
            try {
                if (collectionConfiguration.getLastCollectionTime() == 0L) {
                    collectionConfiguration.setLastCollectionTime(firstBootTime);
                }
            }
            catch (Exception e) {
                logger.error("Error reading/writing lastCollectionTime during startup.", (Throwable)e);
            }
        }

        public boolean isItTimeToFire() {
            ScheduleConfiguration scheduleConfig = this._platformClientFactory.createScheduleConfiguration();
            CollectionConfiguration collectionConfiguration = this._platformClientFactory.createCollectionConfiguration();
            String schedule = this.retrieveValidSchedule(scheduleConfig);
            long lastCollectionTime = collectionConfiguration.getLastCollectionTime();
            long now = System.currentTimeMillis();
            boolean timeToFire = this._scheduleCalc.isItTimeToFire(lastCollectionTime, now, schedule);
            logger.info("Collector configuration: timeToFime = " + timeToFire + " ; schedule =  " + schedule + " ; lastCollectionTime = " + this.toUtcTimeString(lastCollectionTime) + " ; now = " + this.toUtcTimeString(now));
            return timeToFire;
        }

        public void setLastCollectionTime(long currentTimeMillis) {
            CollectionConfiguration collectionConfiguration = this._platformClientFactory.createCollectionConfiguration();
            collectionConfiguration.setLastCollectionTime(currentTimeMillis);
        }

        private String retrieveValidSchedule(ScheduleConfiguration scheduleConfig) throws ConfigirationException {
            boolean scheduleIsValid;
            String schedule = scheduleConfig.getSchedule();
            boolean bl = scheduleIsValid = !StringUtils.isEmpty((String)schedule) && this._scheduleCalc.validateScheduleAndBuildCallendar(schedule, false) != null;
            if (!scheduleIsValid) {
                String newSchedule = this._scheduleCalc.generateRandomSchedule();
                scheduleConfig.setSchedule(newSchedule);
                logger.info("The data collection was enabled but the configured schedule `{}' was not valud. Created new schedule: {}", (Object)schedule, (Object)newSchedule);
                schedule = newSchedule;
            }
            return schedule;
        }

        private String toUtcTimeString(long time) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(time);
            return this._formatter.format(c.getTime());
        }
    }
}

