/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.vmware.ph.exceptions.Bug;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vsphere.telemetry.cmc.CollectorOutcome;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectorLoop {
    private static final long DEFAULT__INITIAL_BACKOFF_TIME = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    private static final long SETTINGS_CHECK_SECONDS = 60L;
    private static final long SCHEDULE_CHECK_TIME_SECONDS = TimeUnit.SECONDS.convert(60L, TimeUnit.MINUTES);
    private static final long BACKOFF_TIME_SECONDS = TimeUnit.SECONDS.convert(1L, TimeUnit.DAYS);
    private static final String OPTION_SCHEDULE_CHECK_INTERVAL = "usageDataCollector.scheduleCheckInterval.seconds";
    private static final String OPTION_BACKOFF_TIME = "usageDataCollector.backOffTimeOnUnexpectedError.seconds";
    private static final String INITIAL_BACKOFF_TIME = "usageDataCollector.initial_backoff_time.seconds";
    private static final Logger logger = LoggerFactory.getLogger(CollectorLoop.class);
    private final AtomicBoolean _mustStop = new AtomicBoolean(false);
    private final AtomicBoolean _isRunning = new AtomicBoolean(false);
    private final ConfigurationService _configurationService;
    private final Callable<CollectorOutcome> _collectorAction;
    private Thread _collectorThread = null;
    private long _scheduleCheckTimeSeconds = SCHEDULE_CHECK_TIME_SECONDS;
    private long _backoffTimeSeconds = BACKOFF_TIME_SECONDS;

    public CollectorLoop(ConfigurationService configurationService, Callable<CollectorOutcome> collectorAction) {
        this._configurationService = configurationService;
        this._collectorAction = collectorAction;
    }

    public void setBackoffTimeSeconds(long backoffTime) {
        this._backoffTimeSeconds = backoffTime;
    }

    public long getBackoffTimeSeconds() {
        return this._backoffTimeSeconds;
    }

    public void setScheduleCheckTimeSeconds(long scheduleCheckTime) {
        this._scheduleCheckTimeSeconds = scheduleCheckTime;
    }

    public long getScheduleCheckTimeSeconds() {
        return this._scheduleCheckTimeSeconds;
    }

    public synchronized void start() {
        if (this._isRunning.get()) {
            throw new IllegalStateException();
        }
        this._collectorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                CollectorLoop.this._isRunning.set(true);
                CollectorLoop.this.runLoop();
            }
        }, "usage-data-collector-thread");
        this._collectorThread.setDaemon(true);
        this._collectorThread.start();
    }

    public synchronized void stop() throws InterruptedException {
        if (this._collectorThread != null) {
            this._collectorThread.interrupt();
            this._collectorThread.join();
            this._collectorThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runLoop() {
        try {
            this.initialBackOff();
            while (!this._mustStop.get()) {
                outcome = CollectorOutcome.LOCAL_ERROR;
                try {
                    outcome = this._collectorAction.call();
                    ** GOTO lbl17
                }
                catch (Bug e) {
                    CollectorLoop.logger.error("BUG: An internal error has occurred: {}. Terminating the collector loop.", (Object)e.getMessage(), (Object)e);
                    this._mustStop.set(true);
                    this._isRunning.set(false);
                    return;
                }
                catch (RuntimeException e) {
                    try {
                        CollectorLoop.logger.warn("Unexpected runtime error escaping the collector loop. The current loop execution will not complete successfully. The loop is not terminated and the next collection attempt will be executed on schedule. For more details on the current error, see the underlying exception: {}: {}", new Object[]{e.getClass().getName(), e.getMessage(), e});
                        outcome = CollectorOutcome.LOCAL_ERROR;
lbl17:
                        // 2 sources

                        this.sleep(outcome);
                    }
                    catch (InterruptedException e) {
                        CollectorLoop.logger.debug("This thread received the interrupt signal (either due to stop() or container shutting down.) The caller needs us to stop.");
                        this._mustStop.set(true);
                        return;
                    }
                    catch (Exception e) {
                        CollectorLoop.logger.error("Collector terminated unexpectedly due to {}: {}", new Object[]{e.getClass().getName(), e.getMessage(), e});
                        return;
                    }
                    catch (Throwable var3_6) {
                        throw var3_6;
                        return;
                    }
                }
            }
        }
        finally {
            this._isRunning.set(false);
        }
    }

    private void initialBackOff() throws InterruptedException {
        String initialBackoffTimeStr = this._configurationService.getProperty(INITIAL_BACKOFF_TIME);
        long timeout = NumberUtils.toLong((String)initialBackoffTimeStr, (long)DEFAULT__INITIAL_BACKOFF_TIME);
        Thread.sleep(timeout);
    }

    private void sleep(CollectorOutcome outcome) throws InterruptedException {
        long toSleep;
        long totalSeconds = this.calcSleepInterval(outcome);
        for (long timeSleptSeconds = 0L; timeSleptSeconds < totalSeconds && !this._mustStop.get(); timeSleptSeconds += toSleep) {
            toSleep = Math.min(totalSeconds - timeSleptSeconds, 60L);
            this.sleep(toSleep);
            totalSeconds = this.calcSleepInterval(outcome);
        }
    }

    private long calcSleepInterval(CollectorOutcome outcome) {
        long seconds;
        switch (outcome) {
            case PASSED: {
                seconds = this.getConfiguredTimeValue(OPTION_SCHEDULE_CHECK_INTERVAL, this._scheduleCheckTimeSeconds);
                break;
            }
            default: {
                seconds = this.getConfiguredTimeValue(OPTION_BACKOFF_TIME, this._backoffTimeSeconds);
            }
        }
        return seconds;
    }

    private void sleep(long sleepIntervalSeconds) throws InterruptedException {
        logger.trace("Sleeping for " + sleepIntervalSeconds + " seconds ...");
        Thread.sleep(sleepIntervalSeconds * 1000L);
    }

    private long getConfiguredTimeValue(String configKey, long defaultValue) {
        long time;
        String configuredTimeoutStr = this._configurationService.getProperty(configKey);
        if (!StringUtil.isNullOrEmpty((String)configuredTimeoutStr)) {
            try {
                time = Long.parseLong(configuredTimeoutStr);
                if (time <= 0L) {
                    time = defaultValue;
                }
            }
            catch (NumberFormatException e) {
                logger.warn(String.format("Invalid non-numeric value for '%s' ignored (number conversion error: %s)", configKey, e.getMessage()));
                logger.debug("", (Throwable)e);
                time = defaultValue;
            }
        } else {
            time = defaultValue;
        }
        return time;
    }
}

