/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.vmware.ph.CollectionConfiguration;
import com.vmware.ph.ScheduleConfiguration;
import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import com.vmware.ph.client.api.PhClient;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.ph.client.common.extensions.ps.AutodiscoveredProxySettingsProvider;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vsphere.telemetry.cmc.PhEnvironmentProvider;
import com.vmware.vsphere.telemetry.cmc.PlatformAuditStrategy;
import com.vmware.vsphere.telemetry.cmc.PlatformClientFactory;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public final class DefaultPlatformClientFactory
implements PlatformClientFactory {
    private static final URI CONNECTION_TEST_URI = URI.create("https://vcsa.vmware.com/ph/api/v1/server_time");
    private static final int FRESH_PERIOD_ONE_HOUR_AS_MILLI_SECONDS = (int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private final ConfigurationService _configurationService;
    private final PersistenceService _persistenceService;
    private final PhEnvironmentProvider _environmentProvider;
    private final DsSessionSimulator _sessionSimulator;
    private final SolutionUserAuthenticationConfig _authConfig;
    static final CeipConfigProvider alwaysTrueCeipConfigProvider = new CeipConfigProvider(){

        public boolean isCeipEnabled() {
            return true;
        }
    };

    public DefaultPlatformClientFactory(ConfigurationService configurationService, PersistenceService persistenceService, PhEnvironmentProvider environmentProvider, DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig authConfig) {
        this._configurationService = configurationService;
        this._persistenceService = persistenceService;
        this._environmentProvider = environmentProvider;
        this._sessionSimulator = sessionSimulator;
        this._authConfig = authConfig;
    }

    @Override
    public PhClient createPhClient(Collector collector) {
        PhClientBuilder builder = PhClientBuilder.create((PhClientBuilder.Environment)this._environmentProvider.getEnvironment(), (Collector)collector);
        builder.setProxyProvider((ProxySettingsProvider)new AutodiscoveredProxySettingsProvider((long)FRESH_PERIOD_ONE_HOUR_AS_MILLI_SECONDS, CONNECTION_TEST_URI));
        new PlatformAuditStrategy().setAuditFileConfig(builder);
        builder.setCeipConfigProvider(alwaysTrueCeipConfigProvider);
        PhClient client = builder.build();
        return client;
    }

    @Override
    public ScheduleConfiguration createScheduleConfiguration() {
        return new ScheduleConfiguration(this._sessionSimulator, this._authConfig);
    }

    @Override
    public CollectionConfiguration createCollectionConfiguration() {
        return new CollectionConfiguration(this._configurationService, this._persistenceService);
    }
}

