/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vsphere.telemetry.cmc.ManifestContentProvider;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class LocalFileSystemManifestContentProvider
implements ManifestContentProvider {
    static final String PROP_MANIFEST_LOCATION = "cmc.manifest_location";
    private final ConfigurationService configurationService;

    public LocalFileSystemManifestContentProvider(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public boolean isEnabled() {
        String manifestLocation = this.configurationService.getProperty(PROP_MANIFEST_LOCATION);
        return StringUtils.isNotBlank((String)manifestLocation);
    }

    @Override
    public String getManifestContent() throws IOException {
        if (!this.isEnabled()) {
            throw new RuntimeException(LocalFileSystemManifestContentProvider.class.getName() + " is not enabled, e.g. " + PROP_MANIFEST_LOCATION + " property does not have assigned value.");
        }
        String manifestLocation = this.configurationService.getProperty(PROP_MANIFEST_LOCATION);
        return this.getManifestContentFromFile(manifestLocation);
    }

    private String getManifestContentFromFile(String manifestLocation) throws IOException {
        File manifestFile = new File(manifestLocation);
        if (!manifestFile.exists()) {
            throw new IOException("The specified manifest location '" + manifestLocation + "' through the property " + PROP_MANIFEST_LOCATION + " does not exist.");
        }
        if (!manifestFile.isFile()) {
            throw new IOException("The specified manifest location '" + manifestLocation + "' through the property " + PROP_MANIFEST_LOCATION + " is directory, it should be file.");
        }
        return FileUtils.readFileToString((File)manifestFile);
    }
}

