/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.CdfSequenceSerializerFactory;
import com.vmware.ph.client.api.commondataformat.serialization.rdf.RdfCdfSequenceSerializer;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vsphere.telemetry.cmc.PayloadUploader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class LocalFileSystemPayloadUploader
implements PayloadUploader {
    static final String PROP_TARGET_PAYLOAD_LOCATION = "cmc.target_payload_location";
    private final ConfigurationService configurationService;
    private final ExecutorService executorService;

    public LocalFileSystemPayloadUploader(ConfigurationService configurationService, ExecutorService executorService) {
        this.configurationService = configurationService;
        this.executorService = executorService;
    }

    @Override
    public boolean isEnabled() {
        String value = this.configurationService.getProperty(PROP_TARGET_PAYLOAD_LOCATION);
        return StringUtils.isNotBlank((String)value);
    }

    @Override
    public Future<?> upload(final Payload payload, PayloadEnvelope envelope, String uploadId) {
        if (!this.isEnabled()) {
            throw new RuntimeException(LocalFileSystemPayloadUploader.class + " is not configured properly, it is not able to process specified payload.");
        }
        final File outputDirectory = new File(this.configurationService.getProperty(PROP_TARGET_PAYLOAD_LOCATION));
        return this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileOutputStream fileStream = null;
                RdfCdfSequenceSerializer serializer = null;
                try {
                    FileUtils.forceMkdir((File)outputDirectory);
                    int fileCount = outputDirectory.list().length;
                    File filename = new File(outputDirectory, String.format("payload%04d.cdf", fileCount));
                    fileStream = new FileOutputStream(filename);
                    try {
                        serializer = CdfSequenceSerializerFactory.createRdfCdfSequenceSerializer((OutputStream)fileStream);
                        for (Resource res : payload.getResources()) {
                            serializer.write((CdfAble)res);
                        }
                    }
                    finally {
                        if (serializer != null) {
                            serializer.close();
                        }
                        ((OutputStream)fileStream).close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("An exception occurred while trying to save payload on the local file system.", e);
                }
            }
        });
    }
}

