/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.vmware.ph.exceptions.Bug;
import com.vmware.vsphere.telemetry.cmc.InvalidManifestException;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ManifestUtils {
    private static final String FEATURE_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_EXTERNAL_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String FEATURE_NO_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";

    public static Element findRequiredElement(Document manifest, String elementName) {
        Element element = ManifestUtils.findOptionalElement(manifest, elementName);
        if (element == null) {
            throw new InvalidManifestException("Collection manifest is missing required element: " + elementName);
        }
        return element;
    }

    public static Element findOptionalElement(Document manifest, String elementName) {
        NodeList elements = manifest.getElementsByTagNameNS("", elementName);
        if (elements.getLength() < 1 || elements.item(0).getNodeType() != 1) {
            return null;
        }
        return (Element)elements.item(0);
    }

    public static Document parseManifestToDoc(String manifest) {
        StringReader manifestReader = new StringReader(manifest);
        try {
            DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
            xmlFactory.setNamespaceAware(true);
            xmlFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            xmlFactory.setFeature(FEATURE_GENERAL_ENTITIES, false);
            xmlFactory.setFeature(FEATURE_EXTERNAL_ENTITIES, false);
            xmlFactory.setFeature(FEATURE_NO_DOCTYPE, true);
            DocumentBuilder docBuilder = xmlFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(manifestReader));
            return doc;
        }
        catch (SAXException e) {
            throw new InvalidManifestException("Failed to parse collection manifest as XML: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new Bug("Internal error: I/O error reading from in-memory string.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new Bug("Failed to create XML parser with hardcoded configuration.", (Throwable)e);
        }
    }
}

