/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.vmware.ph.client.api.PhClient;
import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.ph.client.api.exceptions.PhClientConnectionException;
import com.vmware.ph.client.api.exceptions.PhClientException;
import com.vmware.ph.exceptions.collector.InvalidCollectorException;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CdfCollector;
import com.vmware.vsphere.telemetry.cmc.CollectedFile;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.CollectorOutcome;
import com.vmware.vsphere.telemetry.cmc.ContainsErrorInfo;
import com.vmware.vsphere.telemetry.cmc.ContextFactory;
import com.vmware.vsphere.telemetry.cmc.FileCollector;
import com.vmware.vsphere.telemetry.cmc.InvalidManifestException;
import com.vmware.vsphere.telemetry.cmc.ManifestContentProvider;
import com.vmware.vsphere.telemetry.cmc.ManifestUtils;
import com.vmware.vsphere.telemetry.cmc.PayloadUploader;
import com.vmware.vsphere.telemetry.cmc.PlatformClientFactory;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PhUsageDataCollector {
    static final String PROP_COLLECTOR_ID = "cmc.collector_id";
    static final String DEFAULT_COLLECTOR_ID = "vSphere.6_5";
    private static final String RAN_PAYLOAD_COUNT = "payload_count";
    private static final String RAN_PAGE_SIZE = "page_size";
    private static final String RT_COLLECTION_SUMMARY = "collection_summary";
    private static final String RT_COLLECTION = "collection";
    private static final String CT_STRUCTURED_DATA = "structured_data";
    private static final String CT_FILE_BASED = "file_based";
    private static final String RAN_COLLECTION_TYPE = "collection_type";
    private static final String RAN_SUCCESSFUL_ATTEMPTS = "successful_attempts";
    private static final String RAN_UPLOAD_ATTEMPTS = "upload_attempts";
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private static final String MANIFEST_PAGE_SIZE_ATTRIBUTE = "recommendedPageSize";
    private static final Logger logger = LoggerFactory.getLogger(PhUsageDataCollector.class);
    private final PlatformClientFactory clientFactory;
    private final CdfCollector cdfCollector;
    private final FileCollector fileCollector;
    private final ContextFactory contextFactory;
    private final ConfigurationService configurationService;
    private final ManifestContentProvider localFsManifestProvider;
    private final PayloadUploader localFsPayloadUploader;

    public PhUsageDataCollector(PlatformClientFactory clientFactory, CdfCollector cdfCollector, FileCollector fileCollector, ContextFactory contextFactory, ConfigurationService configurationService, ManifestContentProvider localFsManifestProvider, PayloadUploader localFsPayloadUploader) {
        this.clientFactory = clientFactory;
        this.cdfCollector = cdfCollector;
        this.fileCollector = fileCollector;
        this.contextFactory = contextFactory;
        this.configurationService = configurationService;
        this.localFsManifestProvider = localFsManifestProvider;
        this.localFsPayloadUploader = localFsPayloadUploader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectorOutcome collect(DataService dataService, VcService vcService) {
        CollectionInfo collectionInfo;
        String collectorId = this.getCollectorId();
        String collectorInstanceId = "ph-" + vcService.getServiceGuid();
        Collector collector = new Collector(collectorId, collectorInstanceId);
        PhClient phClient = this.clientFactory.createPhClient(collector);
        try {
            collectionInfo = this.setupCollectionInfo(phClient, vcService, collector);
        }
        catch (PhClientConnectionException e) {
            logger.error("Error while retrieving collection manifest: {}", (Object)e.getMessage(), (Object)e);
            return CollectorOutcome.REMOTE_ERROR;
        }
        catch (InvalidCollectorException e) {
            logger.error("The configured collectotr id `{}' is invalid or disabled at server side. Skipping collection.", (Object)collectorId, (Object)e);
            return CollectorOutcome.LOCAL_ERROR;
        }
        try {
            if (!StringUtils.isEmpty((String)collectionInfo.manifest)) {
                logger.info("started collection process");
                CollectorOutcome e = this.collectAndUpload(collectionInfo, dataService, vcService);
                return e;
            }
            logger.info("Retrieved empty manifest from the collection platform. Collector is disabled server-side.");
            CollectorOutcome e = CollectorOutcome.PASSED;
            return e;
        }
        catch (InvalidManifestException e) {
            logger.error("The server-provided manifest could not be parsed: {}", (Object)e.getMessage(), (Object)e);
            CollectorOutcome collectorOutcome = CollectorOutcome.REMOTE_ERROR;
            return collectorOutcome;
        }
        catch (InterruptedException e) {
            logger.error("Upload interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            CollectorOutcome collectorOutcome = CollectorOutcome.LOCAL_ERROR;
            return collectorOutcome;
        }
        finally {
            phClient.close();
        }
    }

    private CollectorOutcome collectAndUpload(CollectionInfo collectionInfo, DataService dataService, VcService vcService) throws InterruptedException {
        Context context = this.createMappingContext(collectionInfo, vcService);
        Document manifestDoc = ManifestUtils.parseManifestToDoc(collectionInfo.manifest);
        CollectionStatistics structuredDataStatistics = new CollectionStatistics();
        this.processStructuredDataCollectors(collectionInfo, manifestDoc, dataService, vcService, context, structuredDataStatistics);
        this.logCollectionStatistics(structuredDataStatistics, CT_STRUCTURED_DATA);
        CollectionStatistics fileBasedStatistics = new CollectionStatistics();
        this.processFileBasedCollectors(collectionInfo, manifestDoc, dataService, vcService, context, fileBasedStatistics);
        this.logCollectionStatistics(fileBasedStatistics, CT_FILE_BASED);
        int fatalErrorCount = structuredDataStatistics.fatalErrorCount + fileBasedStatistics.fatalErrorCount;
        return fatalErrorCount > 0 ? CollectorOutcome.LOCAL_ERROR : CollectorOutcome.PASSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStructuredDataCollectors(CollectionInfo collectionInfo, Document manifestDoc, DataService dataService, VcService vcService, Context context, CollectionStatistics statistics) throws InterruptedException {
        logger.info("started processing structured data collectors, collection id {}.", (Object)collectionInfo.collectionId);
        int accumulationSize = this.getPageSizeFromManifest(manifestDoc);
        logger.info("Page size: {}", (Object)accumulationSize);
        Iterable<CollectedPayload> payloads = this.cdfCollector.collect(manifestDoc, dataService, vcService, context, accumulationSize);
        PayloadBuilder uploadBuilder = new PayloadBuilder();
        Iterator<CollectedPayload> collectedPayloadIter = payloads.iterator();
        CollectedPayload collectedPayload = null;
        int accumulatedResource = 0;
        try {
            while (collectedPayloadIter.hasNext()) {
                collectedPayload = collectedPayloadIter.next();
                ++statistics.payloadCount;
                this.updateErrorStatistic(statistics, collectedPayload);
                Payload payload = collectedPayload.getPayload();
                PayloadUtil.merge(uploadBuilder, payload);
                if ((accumulatedResource += this.resourceCount(payload)) < accumulationSize) continue;
                this.upload(collectionInfo, statistics, uploadBuilder.build(), null);
                accumulatedResource = 0;
                uploadBuilder = new PayloadBuilder();
            }
        }
        finally {
            if (collectedPayloadIter instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)collectedPayloadIter)));
            }
        }
        if (accumulatedResource > 0) {
            this.upload(collectionInfo, statistics, uploadBuilder.build(), null);
        }
        this.sendCollectionSummaryResource(collectionInfo, statistics, CT_STRUCTURED_DATA, accumulationSize);
    }

    private void sendCollectionSummaryResource(CollectionInfo collectionInfo, CollectionStatistics statistics, String collectionType, int pageSize) throws InterruptedException {
        if (statistics.payloadCount == 0) {
            logger.info("There are no payloads for collection type {}, will not send summary resource.", (Object)collectionType);
            return;
        }
        Resource collectionResource = this.createCollectionResource(collectionInfo);
        Resource summaryResource = this.createSummaryResource(statistics, collectionType, pageSize);
        PayloadBuilder payloadBuilder = new PayloadBuilder();
        payloadBuilder.add(new Resource[]{collectionResource});
        payloadBuilder.add(new Resource[]{summaryResource});
        PhClient phClient = collectionInfo.phClient;
        String uploadId = this.getNextUploadId();
        PayloadEnvelope header = new PayloadEnvelope(collectionInfo.collector);
        try {
            Future<?> uploadTask;
            if (this.localFsPayloadUploader.isEnabled()) {
                logger.info("Initiated upload using local fs uploader of summary resource for collection type {}.", (Object)collectionType);
                uploadTask = this.localFsPayloadUploader.upload(payloadBuilder.build(), header, uploadId);
            } else {
                logger.info("Initiated upload of summary resource for collection type {}.", (Object)collectionType);
                uploadTask = phClient.sendPayload(payloadBuilder.build(), header, uploadId);
            }
            uploadTask.get();
            logger.info("Completed upload of summary resource for collection type {}.", (Object)collectionType);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            logger.error("Exception occured while uploading summary resource.", (Throwable)e);
        }
        catch (PhClientConnectionException e) {
            logger.error("Exception occured while uploading summary resource.", (Throwable)e);
        }
        catch (PhClientException e) {
            logger.error("Exception occured while uploading summary resource.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileBasedCollectors(CollectionInfo collectionInfo, Document manifest, DataService dataService, VcService vcService, Context context, CollectionStatistics statistics) throws InterruptedException {
        logger.info("started processing file based collectors, collection id {}.", (Object)collectionInfo.collectionId);
        Iterable<CollectedFile> files = this.fileCollector.collect(manifest, dataService, vcService, context);
        for (CollectedFile file : files) {
            ++statistics.payloadCount;
            this.updateErrorStatistic(statistics, file);
            if (file.getFile() != null) {
                try {
                    this.upload(collectionInfo, statistics, null, file.getFile());
                    continue;
                }
                finally {
                    file.dispose();
                    continue;
                }
            }
            logger.warn("CollectedFile without existing file was found.");
        }
        this.sendCollectionSummaryResource(collectionInfo, statistics, CT_FILE_BASED, 0);
    }

    private void updateErrorStatistic(CollectionStatistics statistics, ContainsErrorInfo dataPackage) {
        if (dataPackage.getCollectorError() != null) {
            ++statistics.errorCount;
            statistics.fatalErrorCount = statistics.fatalErrorCount + (dataPackage.hasFatalError() ? 1 : 0);
        }
    }

    private void upload(CollectionInfo collectionInfo, CollectionStatistics statistics, Payload payload, File file) throws InterruptedException {
        assert (payload != null || file != null);
        String uploadId = this.getNextUploadId();
        PhClient phClient = collectionInfo.phClient;
        try {
            Future<?> uploadTask;
            ++statistics.attemptedUploads;
            if (payload != null) {
                PayloadEnvelope header = new PayloadEnvelope(collectionInfo.collector);
                Payload payloadWithCollectionResource = this.preparePayloadWithCollectionResource(collectionInfo, payload);
                if (this.localFsPayloadUploader.isEnabled()) {
                    logger.info("Initiated local fs payload upload ({} resources)", (Object)payloadWithCollectionResource.getResources().size());
                    uploadTask = this.localFsPayloadUploader.upload(payloadWithCollectionResource, header, uploadId);
                } else {
                    logger.info("Initiated payload upload ({} resources)", (Object)payloadWithCollectionResource.getResources().size());
                    uploadTask = phClient.sendPayload(payloadWithCollectionResource, header, uploadId);
                }
            } else {
                String collectorId = collectionInfo.collector.getCollectorId();
                String instanceId = collectionInfo.collector.getCollectorInstanceId();
                logger.info("Initiated upload of file: {}", (Object)file.getAbsolutePath());
                uploadTask = phClient.upload(collectorId, instanceId, uploadId, file);
            }
            uploadTask.get();
            logger.info("Upload completed successfully.");
            ++statistics.successfulUploads;
        }
        catch (PhClientConnectionException e) {
            this.logUploadError(e);
        }
        catch (PhClientException e) {
            this.logUploadError(e);
        }
        catch (IOException e) {
            this.logUploadError(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            this.logUploadError(cause);
        }
    }

    private Payload preparePayloadWithCollectionResource(CollectionInfo collectionInfo, Payload payload) {
        PayloadBuilder payloadBuilder = new PayloadBuilder();
        Resource collectionResource = this.createCollectionResource(collectionInfo);
        payloadBuilder.addResources(Collections.singleton(collectionResource));
        PayloadUtil.merge(payloadBuilder, payload);
        return payloadBuilder.build();
    }

    private Resource createCollectionResource(CollectionInfo collectionInfo) {
        Resource collectionResource = new Resource(RT_COLLECTION, collectionInfo.collectionId, null, null);
        return collectionResource;
    }

    private Resource createSummaryResource(CollectionStatistics statistics, String collectionType, int pageSize) {
        Resource.KeyValue[] summaryAttributes = new Resource.KeyValue[]{new Resource.KeyValue(RAN_UPLOAD_ATTEMPTS, new AnyPrimitive(Integer.valueOf(statistics.attemptedUploads))), new Resource.KeyValue(RAN_SUCCESSFUL_ATTEMPTS, new AnyPrimitive(Integer.valueOf(statistics.attemptedUploads))), new Resource.KeyValue(RAN_PAYLOAD_COUNT, new AnyPrimitive(Integer.valueOf(statistics.payloadCount))), new Resource.KeyValue(RAN_COLLECTION_TYPE, new AnyPrimitive(collectionType)), new Resource.KeyValue(RAN_PAGE_SIZE, new AnyPrimitive(Integer.valueOf(pageSize)))};
        String id = UUID.randomUUID().toString().replace("-", "");
        return new Resource(RT_COLLECTION_SUMMARY, id, summaryAttributes, null);
    }

    private CollectionInfo setupCollectionInfo(PhClient phClient, VcService vcService, Collector collector) throws PhClientConnectionException {
        String manifestContent = this.getManifestContent(phClient, collector);
        logger.info("Retrieved manifest from collection platform: " + StringUtils.abbreviate((String)manifestContent, (int)1000));
        return new CollectionInfo(phClient, collector, manifestContent);
    }

    private String getManifestContent(PhClient phClient, Collector collector) throws PhClientConnectionException {
        if (this.localFsManifestProvider.isEnabled()) {
            try {
                return this.localFsManifestProvider.getManifestContent();
            }
            catch (IOException e) {
                throw new PhClientConnectionException("An IOException occurred while trying to read local file system manifest.", (Exception)e);
            }
        }
        return phClient.getManifest(collector.getCollectorId(), collector.getCollectorInstanceId());
    }

    private Context createMappingContext(CollectionInfo collectionInfo, VcService vcService) {
        return this.contextFactory.createVcAwareContext(collectionInfo.collector, collectionInfo.collectionId, vcService);
    }

    private String getNextUploadId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private int resourceCount(Payload payload) {
        return payload.getResources().size() + payload.getFreeforms().size();
    }

    private int getPageSizeFromManifest(Document manifestDoc) {
        int pageSize;
        String pageSizeStr = manifestDoc.getDocumentElement().getAttributeNS(null, MANIFEST_PAGE_SIZE_ATTRIBUTE);
        if (!StringUtils.isEmpty((String)pageSizeStr)) {
            try {
                pageSize = Integer.parseInt(pageSizeStr);
            }
            catch (NumberFormatException e) {
                logger.warn("Manifest contains invalid {}: {}. Defaulting to {}.", new Object[]{MANIFEST_PAGE_SIZE_ATTRIBUTE, e.getMessage(), 1000});
                pageSize = 1000;
            }
        } else {
            pageSize = 1000;
        }
        return pageSize;
    }

    private void logUploadError(Throwable e) {
        String reason = e instanceof PhClientConnectionException ? "Connection" : (e instanceof PhClientException ? "PhoneHome client" : (e instanceof IOException ? "I/O" : "Unexpected"));
        logger.warn("{} exception while trying to upload: {}", new Object[]{reason, e.getMessage(), e});
    }

    private void logCollectionStatistics(CollectionStatistics statistics, String statisticsLabel) {
        if (logger.isInfoEnabled()) {
            StringBuilder msg = new StringBuilder("Usage data collection of type ");
            msg.append(statisticsLabel);
            msg.append(" completed ");
            if (statistics.errorCount > 0) {
                msg.append(" with ").append(statistics.errorCount).append(" error(s) (").append(statistics.fatalErrorCount).append(" fatal.)");
            } else {
                msg.append(" without errors.");
            }
            msg.append(" There were ").append(statistics.successfulUploads).append(" successful uploads of total ").append(statistics.attemptedUploads).append(" attempts. Collected payload count is ").append(statistics.payloadCount).append(".");
            logger.info(msg.toString());
        }
    }

    private String getCollectorId() {
        String result = DEFAULT_COLLECTOR_ID;
        String configuredCollectorId = this.configurationService.getProperty(PROP_COLLECTOR_ID);
        if (StringUtils.isNotBlank((String)configuredCollectorId)) {
            result = configuredCollectorId;
        }
        return result;
    }

    private static final class CollectionStatistics {
        public int attemptedUploads = 0;
        public int successfulUploads = 0;
        public int errorCount = 0;
        public int fatalErrorCount = 0;
        public int payloadCount = 0;

        private CollectionStatistics() {
        }
    }

    private static final class CollectionInfo {
        public final PhClient phClient;
        public final Collector collector;
        public final String manifest;
        public final String collectionId;

        public CollectionInfo(PhClient phClient, Collector collectorInfo, String manifest) {
            this.phClient = phClient;
            this.collector = collectorInfo;
            this.manifest = manifest;
            this.collectionId = UUID.randomUUID().toString().replace("-", "");
        }
    }
}

