/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUtils {
    private static final String STORAGE_DIRECTORY_PROPERTY = "PS_BASEDIR";
    private static final String TEMP_DIRECTORY_PROPERTY = "java.io.tmpdir";
    private static final Logger log = LoggerFactory.getLogger(StorageUtils.class);

    public static String getStorageDirectory() {
        String targetDirectory = System.getProperty(STORAGE_DIRECTORY_PROPERTY);
        log.info("storage target directory from sytem property {}: {}", (Object)STORAGE_DIRECTORY_PROPERTY, (Object)targetDirectory);
        if (targetDirectory == null) {
            targetDirectory = System.getProperty(TEMP_DIRECTORY_PROPERTY);
            log.warn("Could not find storage directory. Will default to {}", (Object)targetDirectory);
        }
        return targetDirectory;
    }
}

