/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc;

import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;

public final class Utils {
    private static final char INDENTATION_CHAR = ' ';
    private static final String NEW_LINE = "\n";

    public static String renderResultSets(ResultSet[] resultSets) {
        if (resultSets == null) {
            return "null";
        }
        if (resultSets.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        for (ResultSet resultSet : resultSets) {
            Utils.appendResultSet(sb, resultSet);
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    private static void appendResultSet(StringBuilder output, ResultSet resultSet) {
        if (resultSet == null) {
            Utils.writeLine(output, "ResultSet: null", 0);
            return;
        }
        Utils.writeLine(output, "ResultSet", 0);
        if (!StringUtil.isNullOrEmpty((String)resultSet.queryName)) {
            Utils.writeLine(output, "QueryName: " + resultSet.queryName, 1);
        }
        Utils.writeLine(output, "TotalMatchedObjectCount: " + resultSet.totalMatchedObjectCount, 1);
        if (resultSet.error != null) {
            Utils.writeLine(output, "Error: " + resultSet.error, 1);
        }
        if (resultSet.items != null) {
            Utils.writeLine(output, "Items[" + resultSet.items.length + "]", 1);
            for (ResultItem item : resultSet.items) {
                Utils.appendResultItem(output, item, 2);
            }
        } else {
            Utils.writeLine(output, "Items: null", 1);
        }
        if (resultSet.facets != null) {
            Utils.writeLine(output, "Facets[" + resultSet.facets.length + "]", 1);
        }
    }

    private static void appendResultItem(StringBuilder output, ResultItem item, int indentation) {
        Utils.writeLine(output, "ResultItem", indentation);
        Utils.writeLine(output, "ResourceObject: " + item.resourceObject, indentation + 1);
        if (!ArrayUtil.isNullOrEmpty((Object[])item.properties)) {
            Utils.writeLine(output, "Properties[" + item.properties.length + "]", indentation + 1);
            for (PropertyValue propertyValue : item.properties) {
                Utils.appendPropertyValue(output, propertyValue, indentation + 2);
            }
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])item.currentGenerations)) {
            Utils.writeLine(output, "CurrentGenerations[" + item.currentGenerations.length + "]", indentation + 1);
            for (PropertyValue propertyValue : item.currentGenerations) {
                Utils.appendGenerationNumber(output, (IdentifiableGenerationNumber)propertyValue, indentation + 2);
            }
        }
    }

    private static void appendPropertyValue(StringBuilder output, PropertyValue propertyValue, int indentation) {
        if (propertyValue == null) {
            Utils.writeLine(output, "null", indentation);
        } else {
            Utils.writeLine(output, propertyValue.toString(), indentation);
        }
    }

    private static void appendGenerationNumber(StringBuilder output, IdentifiableGenerationNumber generationNumber, int indentation) {
        if (generationNumber == null) {
            Utils.writeLine(output, "null", indentation);
        } else {
            Utils.writeLine(output, generationNumber.key + "=" + generationNumber.value, indentation);
        }
    }

    private static void writeLine(StringBuilder output, String message, int indentation) {
        for (int i = 0; i < indentation; ++i) {
            output.append(' ');
        }
        output.append(message);
        output.append(NEW_LINE);
    }
}

