/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.cdf;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vsphere.telemetry.cmc.cdf.VelocityResourceMapping;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="moRefResultItemMapping")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataServiceResultItemMapping
extends VelocityResourceMapping<ResultItem> {
    private static final Logger logger = LoggerFactory.getLogger(DataServiceResultItemMapping.class);
    String forType = "";

    public DataServiceResultItemMapping() {
    }

    public DataServiceResultItemMapping(String forType, String resourceType, String idPattern, Map<String, String> attributeMapping, Map<String, String> relationPatterns) {
        super(resourceType, idPattern, attributeMapping, relationPatterns);
        this.forType = forType;
    }

    @Override
    protected Map<String, Object> createDictionary(ResultItem input) {
        logger.trace("Will create dictionary with properties for mapping data service ResultItem which resourceObject class is: {}", (Object)input.resourceObject.getClass().getCanonicalName());
        if (input.resourceObject instanceof ManagedObjectReference) {
            ManagedObjectReference moRef = (ManagedObjectReference)input.resourceObject;
            if (!moRef.getType().equalsIgnoreCase(this.forType)) {
                logger.trace("Skipping current ResultItem, because its MOR type is {}, while current resultItemMapping is for type {}.", (Object)moRef.getType(), (Object)this.forType);
                return null;
            }
        } else if (input.resourceObject instanceof URI) {
            URI uri = (URI)input.resourceObject;
            if (!uri.toString().toLowerCase().startsWith(this.forType.toLowerCase())) {
                logger.trace("Skipping current ResultItem, becausee its URI type is {}, while current resultItemMapping is for type {}.", (Object)uri, (Object)this.forType);
                return null;
            }
        } else {
            logger.trace("Skipping current ResultItem, because its resourceObject is not of one of the supported types (ManagedObjectReference or java.net.URI).Its type is: ", (Object)input.resourceObject.getClass().getCanonicalName());
            return null;
        }
        return this.createPropertiesMap(input);
    }

    private Map<String, Object> createPropertiesMap(ResultItem input) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put("resultItem-resourceObject-class", input.resourceObject.getClass().getCanonicalName());
        if (input.resourceObject instanceof ManagedObjectReference) {
            ManagedObjectReference moref = (ManagedObjectReference)input.resourceObject;
            propertiesMap.put("moref-serverGuid", moref.getServerGuid() == null ? null : moref.getServerGuid().toUpperCase());
            propertiesMap.put("moref-value", moref.getValue());
        }
        if (input.resourceObject instanceof URI) {
            URI uri = (URI)input.resourceObject;
            propertiesMap.put("resultItem-resourceObject-uri", uri);
        }
        for (PropertyValue pv : input.properties) {
            propertiesMap.put(pv.propertyName, pv.value);
        }
        return propertiesMap;
    }
}

