/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.cdf;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import com.vmware.vsphere.telemetry.cmc.collection.DataObjectMapping;
import com.vmware.vsphere.telemetry.cmc.event.response.Response;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="eventMapping")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EventMapping
implements Mapping<Response, Payload> {
    private static Logger log = LoggerFactory.getLogger(EventMapping.class);
    @XmlElement(name="resultMappings")
    Map<String, DataObjectMapping> resultMappings = new HashMap<String, DataObjectMapping>();

    public Map<String, DataObjectMapping> getResultMappings() {
        return this.resultMappings;
    }

    @Override
    public Payload map(Response input, Context context) {
        assert (input != null);
        assert (context != null);
        Mapping queryMap = this.resultMappings.get(input.queryName);
        if (queryMap == null) {
            log.debug("Skipping the '{}' query since missing a mapping tag. Hence returning empty payload.", (Object)input.queryName);
            return new PayloadBuilder().build();
        }
        PayloadBuilder payloadBuilder = new PayloadBuilder();
        for (Event e : input.events) {
            PayloadUtil.merge(payloadBuilder, (Payload)queryMap.map(e, context));
        }
        return payloadBuilder.build();
    }
}

