/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.cdf;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.Mappings;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IndepedentResultsMapping
implements Mapping<Response, Payload> {
    Map<String, Mappings.Wrapper<Mapping<ResultSet, Payload>>> resultSetMappings = new HashMap<String, Mappings.Wrapper<Mapping<ResultSet, Payload>>>();

    public Map<String, Mappings.Wrapper<Mapping<ResultSet, Payload>>> getResultSetMappings() {
        return this.resultSetMappings;
    }

    @Override
    public Payload map(Response input, Context context) {
        PayloadBuilder payloadBuilder = new PayloadBuilder();
        for (ResultSet resultSet : input.resultSet) {
            Mappings.Wrapper<Mapping<ResultSet, Payload>> wrappedMapping = this.resultSetMappings.get(resultSet.queryName);
            if (wrappedMapping == null) continue;
            Payload resultSetPayload = wrappedMapping.getValue().map(resultSet, context);
            PayloadUtil.merge(payloadBuilder, resultSetPayload);
        }
        return payloadBuilder.build();
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return "IndepedentResultsMapping [resultSetMappings=" + this.resultSetMappings + "]";
    }
}

