/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.cdf;

import com.vmware.ph.exceptions.Bug;
import com.vmware.vsphere.telemetry.cmc.InvalidManifestException;
import com.vmware.vsphere.telemetry.cmc.cdf.CdfMappingParser;
import com.vmware.vsphere.telemetry.cmc.cdf.DataServiceResultItemMapping;
import com.vmware.vsphere.telemetry.cmc.cdf.EventMapping;
import com.vmware.vsphere.telemetry.cmc.cdf.IndepedentResultsMapping;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.Mappings;
import com.vmware.vsphere.telemetry.cmc.cdf.ObjectMapping;
import com.vmware.vsphere.telemetry.cmc.cdf.ResultSetMapping;
import com.vmware.vsphere.telemetry.cmc.collection.DataObjectMapping;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxbCdfMappingParser
implements CdfMappingParser {
    private final JAXBContext _ctx;
    private final Unmarshaller _parser;

    public JaxbCdfMappingParser() {
        try {
            this._ctx = JaxbCdfMappingParser.createContext();
            this._parser = this._ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new Bug("Bad hardcoded JAXB configuration.", (Throwable)e);
        }
    }

    @Override
    public <I, O> Mapping<I, O> parse(Node xmlNode) {
        try {
            Object parsedObj = this._parser.unmarshal(this.getFirstChildElement(xmlNode));
            if (!(parsedObj instanceof Mapping)) {
                throw new IllegalArgumentException("Unexpected cdfMapping first child element in XML manifest.");
            }
            Mapping result = (Mapping)parsedObj;
            return result;
        }
        catch (JAXBException e) {
            throw new InvalidManifestException("Failed parsing mapping from XML.", e);
        }
    }

    private Node getFirstChildElement(Node xmlNode) {
        NodeList children = xmlNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            return children.item(i);
        }
        throw new IllegalArgumentException("No child elements of given node.");
    }

    static JAXBContext createContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{IndepedentResultsMapping.class, ResultSetMapping.class, DataServiceResultItemMapping.class, DataObjectMapping.class, Mappings.Wrapper.class, ObjectMapping.class, EventMapping.class});
    }
}

