/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.cdf;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;

public class PayloadUtil {
    public static final String PERF_DATA_RESOURCE_TYPE = "pa__collection_event";

    public static void merge(PayloadBuilder target, Payload subPayload) {
        if (subPayload == null) {
            return;
        }
        target.addResources((Collection)subPayload.getResources());
        target.addStreams((Collection)subPayload.getFreeforms());
    }

    public static Iterable<CollectedPayload> buildPerfData(long elapsedNano, String name, Context ctx) {
        Resource res = PayloadUtil.buildPerfDataResource(elapsedNano, name, null, ctx);
        Payload payload = new PayloadBuilder().add(new Resource[]{res}).build();
        CollectedPayload cp = new CollectedPayload.Builder().setPayload(payload).build();
        return Collections.singleton(cp);
    }

    public static Resource buildPerfDataResource(long elapsedNano, String name, Integer page, Context ctx) {
        String uuid = UUID.randomUUID().toString();
        long elapsedMillis = TimeUnit.MILLISECONDS.convert(elapsedNano, TimeUnit.NANOSECONDS);
        Object[] attributes = new Resource.KeyValue[]{new Resource.KeyValue("name", new AnyPrimitive(name)), new Resource.KeyValue("elapsed_ms", new AnyPrimitive(Long.valueOf(elapsedMillis))), new Resource.KeyValue("collection_id", new AnyPrimitive(ctx.getCollectionId()))};
        if (page != null) {
            attributes = (Resource.KeyValue[])ArrayUtils.add((Object[])attributes, (Object)new Resource.KeyValue("page", new AnyPrimitive(page)));
        }
        return new Resource(PERF_DATA_RESOURCE_TYPE, uuid, (Resource.KeyValue[])attributes, null);
    }
}

