/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.cdf;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.types.FreeFormData;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import com.vmware.vsphere.telemetry.cmc.cdf.VelocityResourceMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResultSetMapping
implements Mapping<ResultSet, Payload> {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetMapping.class);
    @XmlAnyElement(lax=true)
    List<Mapping<ResultItem, ? extends Object>> itemMappings = new ArrayList<Mapping<ResultItem, ? extends Object>>();
    @XmlElement(required=false)
    ResultSetResourceMapping setMapping;

    public ResultSetMapping() {
    }

    public ResultSetMapping(ResultSetResourceMapping setMapping) {
        this.setMapping = setMapping;
    }

    @Override
    public Payload map(ResultSet input, Context context) {
        PayloadBuilder builder = new PayloadBuilder();
        this.applyItemMappings(input, builder, context);
        this.applySetMapping(input, builder, context);
        return builder.build();
    }

    private void applySetMapping(ResultSet input, PayloadBuilder builder, Context context) {
        Resource result;
        if (this.setMapping != null && (result = this.setMapping.map(input, context)) != null) {
            builder.add(new Resource[]{result});
        }
    }

    private void applyItemMappings(ResultSet input, PayloadBuilder builder, Context context) {
        if (input.items == null) {
            return;
        }
        for (ResultItem item : input.items) {
            for (Mapping<ResultItem, ? extends Object> itemMapping : this.itemMappings) {
                Object result = itemMapping.map(item, context);
                if (result instanceof Payload) {
                    PayloadUtil.merge(builder, (Payload)result);
                    continue;
                }
                if (result instanceof Resource) {
                    builder.add(new Resource[]{(Resource)result});
                    continue;
                }
                if (result instanceof FreeFormData) {
                    builder.add(new FreeFormData[]{(FreeFormData)result});
                    continue;
                }
                if (result == null) continue;
                logger.warn("Ignoring unexpected result of type " + result.getClass().getName());
            }
        }
    }

    public void addItemMapping(Mapping<ResultItem, ? extends Object> newMapping) {
        this.itemMappings.add(newMapping);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return "ResultSetMapping [itemMappings=" + this.itemMappings + "]";
    }

    public static class ResultSetResourceMapping
    extends VelocityResourceMapping<ResultSet> {
        public ResultSetResourceMapping() {
        }

        public ResultSetResourceMapping(String resourceType, String idPattern, Map<String, String> attributePatterns, Map<String, String> relationPatterns) {
            super(resourceType, idPattern, attributePatterns, relationPatterns);
        }

        @Override
        protected Map<String, Object> createDictionary(ResultSet input) {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("totalMatchedObjectCount", input.totalMatchedObjectCount);
            ctx.put("error", input.error);
            return ctx;
        }
    }
}

