/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.cdf;

import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.RelatedResource;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.SystemWrapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.util.introspection.SecureUberspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class VelocityResourceMapping<T>
implements Mapping<T, Resource> {
    private static final Logger logger = LoggerFactory.getLogger(VelocityResourceMapping.class);
    private static final String PREDEFINED_PREFIX = "GLOBAL-";
    private static final String GLOBAL_EMPTY = "GLOBAL-EMPTY";
    private static final Map<String, Object> predefinedMappings;
    String resourceType = "";
    String idPattern = "";
    Map<String, String> attributePatterns = new HashMap<String, String>();
    Map<String, String> relationPatterns = new HashMap<String, String>();

    public VelocityResourceMapping() {
    }

    public VelocityResourceMapping(String resourceType, String idPattern, Map<String, String> attributePatterns, Map<String, String> relationPatterns) {
        this.resourceType = resourceType;
        this.idPattern = idPattern;
        this.attributePatterns = attributePatterns;
        this.relationPatterns = relationPatterns;
    }

    protected abstract Map<String, Object> createDictionary(T var1);

    @Override
    public Resource map(T input, Context parentContext) {
        Map<String, Object> velocityDictionary = this.createDictionary(input);
        if (velocityDictionary == null) {
            return null;
        }
        VelocityContext context = new VelocityContext();
        this.safeAddMap(predefinedMappings, context);
        this.safeAddMap(parentContext, context);
        this.safeAddMap(velocityDictionary, context);
        VelocityEngine velocityEngine = this.createVelocityEngine();
        String id = this.replace(velocityEngine, context, this.idPattern, "idPattern");
        if (id == null) {
            return null;
        }
        Resource.KeyValue[] attributes = this.buildAttributes(velocityEngine, context);
        RelatedResource[] relations = this.buildRelations(velocityEngine, context);
        Resource resource = new Resource(this.resourceType, id, attributes, relations);
        return resource;
    }

    private void safeAddMap(Map<String, Object> dict, VelocityContext context) {
        for (Map.Entry<String, Object> ent : dict.entrySet()) {
            this.safeAddEntry(context, ent.getKey(), ent.getValue());
        }
    }

    private void safeAddEntry(VelocityContext context, String key, Object value) {
        StringBuilder sb = new StringBuilder(key.length());
        for (int n : key.toCharArray()) {
            if (!(n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 95 || n == 45)) {
                n = 45;
            }
            sb.append((char)n);
        }
        context.put(sb.toString(), value);
    }

    private RelatedResource[] buildRelations(VelocityEngine velocityEngine, VelocityContext substitutor) {
        ArrayList<RelatedResource> result = new ArrayList<RelatedResource>();
        if (this.relationPatterns != null) {
            for (Map.Entry<String, String> ent : this.relationPatterns.entrySet()) {
                String evaluated = this.replace(velocityEngine, substitutor, ent.getValue(), ent.getKey());
                if (StringUtils.isBlank((String)evaluated)) continue;
                RelatedResource rr = new RelatedResource(ent.getKey(), evaluated);
                result.add(rr);
            }
        }
        return result.toArray(new RelatedResource[0]);
    }

    private Resource.KeyValue[] buildAttributes(VelocityEngine velocityEngine, VelocityContext context) {
        if (this.attributePatterns == null) {
            return new Resource.KeyValue[0];
        }
        ArrayList<Resource.KeyValue> result = new ArrayList<Resource.KeyValue>();
        for (Map.Entry<String, String> ent : this.attributePatterns.entrySet()) {
            Resource.KeyValue rr;
            Object value;
            Object rawValue = this.getValue(ent.getValue(), context);
            if (rawValue != null) {
                value = rawValue instanceof Double || rawValue instanceof Float ? new AnyPrimitive(Double.valueOf(((Number)rawValue).doubleValue())) : (rawValue instanceof Number ? new AnyPrimitive(Long.valueOf(((Number)rawValue).longValue())) : new AnyPrimitive(rawValue.toString()));
                rr = new Resource.KeyValue(ent.getKey(), value);
                result.add(rr);
                continue;
            }
            if (!ent.getValue().contains("$") || (value = this.replace(velocityEngine, context, ent.getValue(), ent.getKey())) == null) continue;
            rr = new Resource.KeyValue(ent.getKey(), new AnyPrimitive((String)value));
            result.add(rr);
        }
        return result.toArray(new Resource.KeyValue[0]);
    }

    private String replace(VelocityEngine velocityEngine, VelocityContext substitutor, String expression, String logTag) {
        StringWriter sw = new StringWriter();
        try {
            velocityEngine.evaluate((org.apache.velocity.context.Context)substitutor, (Writer)sw, logTag, expression);
            return sw.toString();
        }
        catch (VelocityException e) {
            logger.debug("Returning null for input expression {}, because of VelocityException. Exception is: {}", (Object)expression, (Object)ExceptionUtils.getMessage((Throwable)e));
            return null;
        }
    }

    private Object getValue(String key, VelocityContext context) {
        return context.get(key);
    }

    private VelocityEngine createVelocityEngine() {
        Properties properties = new Properties();
        properties.setProperty("runtime.references.strict", "true");
        properties.setProperty("runtime.references.strict.escape", "true");
        properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
        properties.setProperty("runtime.introspector.uberspect", SecureUberspector.class.getName());
        return new VelocityEngine(properties);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static {
        HashMap<String, Class> m = new HashMap<String, Class>();
        m.put(GLOBAL_EMPTY, null);
        m.put(PREDEFINED_PREFIX + DigestUtils.class.getSimpleName(), DigestUtils.class);
        m.put(PREDEFINED_PREFIX + Collections.class.getSimpleName(), Collections.class);
        m.put(PREDEFINED_PREFIX + Arrays.class.getSimpleName(), Arrays.class);
        m.put("GLOBAL-System", SystemWrapper.class);
        predefinedMappings = Collections.unmodifiableMap(m);
    }
}

