/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CdfCollector;
import com.vmware.vsphere.telemetry.cmc.CollectedFile;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.FileCollector;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.PayloadUtil;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;

public final class Aggregators {
    public static CdfCollector cdf(List<CdfCollector> collectors) {
        return new Cdf(collectors);
    }

    public static FileCollector file(List<FileCollector> collectors) {
        return new File(collectors);
    }

    private static final class File
    implements FileCollector {
        private final List<FileCollector> collectors;

        public File(List<FileCollector> collectors) {
            Validate.notNull(collectors, (String)"Argument `collectors' is requried.");
            this.collectors = collectors;
        }

        @Override
        public Iterable<CollectedFile> collect(final Document manifest, final DataService dataService, final VcService vcService, final Context context) {
            return Iterables.concat((Iterable)Iterables.transform(this.collectors, (Function)new Function<FileCollector, Iterable<CollectedFile>>(){

                public Iterable<CollectedFile> apply(FileCollector input) {
                    return input.collect(manifest, dataService, vcService, context);
                }
            }));
        }
    }

    private static final class Cdf
    implements CdfCollector {
        private final List<CdfCollector> collectors;

        public Cdf(List<CdfCollector> collectors) {
            Validate.notNull(collectors, (String)"Argument `collectors' is requried.");
            this.collectors = collectors;
        }

        @Override
        public Iterable<CollectedPayload> collect(final Document manifest, final DataService dataService, final VcService vcService, final Context context, final int pageSize) {
            return Iterables.concat((Iterable)Iterables.transform(this.collectors, (Function)new Function<CdfCollector, Iterable<CollectedPayload>>(){

                public Iterable<CollectedPayload> apply(CdfCollector input) {
                    long startTimeNano = System.nanoTime();
                    Iterable<CollectedPayload> result = input.collect(manifest, dataService, vcService, context, pageSize);
                    long endTimeNano = System.nanoTime();
                    String collectorName = input.getClass().getSimpleName();
                    Iterable<CollectedPayload> perfData = PayloadUtil.buildPerfData(endTimeNano - startTimeNano, collectorName, context);
                    return Iterables.concat(result, perfData);
                }
            }));
        }
    }
}

