/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.exceptions.Bug;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.cdf.Mappings;
import com.vmware.vsphere.telemetry.cmc.cdf.VelocityResourceMapping;
import com.vmware.vsphere.telemetry.cmc.collection.VmodlDomFormatter;
import com.vmware.vsphere.telemetry.cmc.collection.VmodlDomSerializer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataObjectMapping
implements Mapping<DataObject, Payload> {
    private static Logger log = LoggerFactory.getLogger(DataObjectMapping.class);
    @XmlElement(required=true)
    ResourceMapping resourceMapping;
    @XmlElement(required=false)
    Map<String, Mappings.Wrapper<ResourceMapping>> resourcePatterns = new HashMap<String, Mappings.Wrapper<ResourceMapping>>();

    @Override
    public Payload map(DataObject input, Context context) {
        assert (input != null);
        assert (context != null);
        if (this.resourceMapping == null) {
            throw new Bug("Missing resourceMapping within DataObjectMapping");
        }
        VmodlDomSerializer vmodlTransformer = new VmodlDomSerializer();
        Node rootNode = vmodlTransformer.getDataObjectAsNode(input);
        if (rootNode == null) {
            log.warn("Failed to serialize the data object, {}, to DOM XML node. Returning empty payload", input.getClass());
            return new PayloadBuilder().build();
        }
        PayloadBuilder dataObjectPayload = new PayloadBuilder();
        Resource topLevelResource = this.resourceMapping.map(rootNode, context);
        dataObjectPayload.add(new Resource[]{topLevelResource});
        log.trace("Mapped data object to a Resource: {} -> {}", (Object)input, (Object)topLevelResource);
        VmodlDomFormatter domFormatter = new VmodlDomFormatter();
        Map<String, Object> rootProperties = domFormatter.getKeyValuePairs(rootNode);
        NodeList propertyNodes = rootNode.getChildNodes();
        for (int propIndex = 0; propIndex < propertyNodes.getLength(); ++propIndex) {
            boolean propertyHasResourceMapping;
            Node prop = propertyNodes.item(propIndex);
            Mappings.Wrapper<ResourceMapping> propMapping = this.resourcePatterns.get(prop.getNodeName());
            boolean bl = propertyHasResourceMapping = propMapping != null;
            if (!propertyHasResourceMapping) continue;
            log.trace("Mapping property {} of {} as Resource", (Object)prop.getNodeName(), input.getClass());
            assert (propMapping.getValue() != null);
            Context parentContext = new Context(context);
            parentContext.putAll(rootProperties);
            Resource propResource = propMapping.getValue().map(prop, parentContext);
            log.trace("Mapped data object property to Resource: {} -> {}", input.getClass(), (Object)prop);
            dataObjectPayload.add(new Resource[]{propResource});
        }
        return dataObjectPayload.build();
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class ResourceMapping
    extends VelocityResourceMapping<Node> {
        public ResourceMapping() {
        }

        public ResourceMapping(String resourceType, String idPattern, Map<String, String> attributePatterns, Map<String, String> relationPatterns) {
            super(resourceType, idPattern, attributePatterns, relationPatterns);
        }

        @Override
        protected Map<String, Object> createDictionary(Node input) {
            VmodlDomFormatter formatter = new VmodlDomFormatter();
            return formatter.flattenToKeyValuePairs(input);
        }
    }
}

