/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.telemetry.cmc.collection;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.telemetry.cmc.CdfCollector;
import com.vmware.vsphere.telemetry.cmc.CollectedPayload;
import com.vmware.vsphere.telemetry.cmc.InvalidManifestException;
import com.vmware.vsphere.telemetry.cmc.cdf.CdfMappingParser;
import com.vmware.vsphere.telemetry.cmc.cdf.Context;
import com.vmware.vsphere.telemetry.cmc.cdf.Mapping;
import com.vmware.vsphere.telemetry.cmc.collection.PagingQueryBatchIterator;
import com.vmware.vsphere.telemetry.cmc.request.RequestSpecParser;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.log.NullLogChute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DataServiceCdfCollector
implements CdfCollector {
    private static final String MAPPING_ELEMENT_NAME = "cdfMapping";
    private static final String REQUEST_ELEMENT_NAME = "request";
    private final RequestSpecParser _requestParser;
    private final CdfMappingParser _mappingParser;
    private final PagingQueryIteratorFactory _iteratorFactory;

    public DataServiceCdfCollector(RequestSpecParser requestParser, CdfMappingParser mappingParser) {
        this(requestParser, mappingParser, new PagingQueryIteratorFactory());
    }

    DataServiceCdfCollector(RequestSpecParser requestParser, CdfMappingParser mappingParser, PagingQueryIteratorFactory iteratorFactory) {
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)NullLogChute.class.getName());
        this._requestParser = requestParser;
        this._mappingParser = mappingParser;
        this._iteratorFactory = iteratorFactory;
    }

    @Override
    public Iterable<CollectedPayload> collect(Document manifest, final DataService dataService, VcService vcService, final Context context, final int pageSize) {
        final RequestSpec request = this.parseRequestSpecFromManifest(manifest);
        if (ArrayUtils.isEmpty((Object[])request.querySpec)) {
            return Collections.emptyList();
        }
        final Mapping responseMapping = this.parseMappingFromManifest(manifest);
        return new Iterable<CollectedPayload>(){

            @Override
            public Iterator<CollectedPayload> iterator() {
                return DataServiceCdfCollector.this._iteratorFactory.getIterator(dataService, responseMapping, context, request, pageSize);
            }
        };
    }

    private <T> Mapping<T, Payload> parseMappingFromManifest(Document manifestDoc) {
        Element mappingElement = this.getRequiredElement(manifestDoc, MAPPING_ELEMENT_NAME);
        return this._mappingParser.parse(mappingElement);
    }

    private RequestSpec parseRequestSpecFromManifest(Document manifestDoc) {
        Element requestElement = this.getRequiredElement(manifestDoc, REQUEST_ELEMENT_NAME);
        return this._requestParser.parse(requestElement);
    }

    private Element getRequiredElement(Document manifest, String elementName) {
        NodeList elements = manifest.getElementsByTagNameNS("", elementName);
        if (elements.getLength() < 1 || elements.item(0).getNodeType() != 1) {
            throw new InvalidManifestException("Collection manifest is missing required element: " + elementName);
        }
        return (Element)elements.item(0);
    }

    static class PagingQueryIteratorFactory {
        PagingQueryIteratorFactory() {
        }

        public PagingQueryBatchIterator getIterator(DataService dataService, Mapping<Response, Payload> responseMapping, Context context, RequestSpec request, int pageSize) {
            return new PagingQueryBatchIterator(dataService, responseMapping, context, request.querySpec, pageSize);
        }
    }
}

